## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 5,
  fig.height = 4,
  dpi=200
)

## ---- message=FALSE, warning=FALSE--------------------------------------------
library(NanoStringNCTools)
library(GeomxTools)

## -----------------------------------------------------------------------------
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
DCCFiles <- dir(datadir, pattern=".dcc$", full.names=TRUE)
PKCFiles <- unzip(zipfile = file.path(datadir,  "/pkcs.zip"))
SampleAnnotationFile <- file.path(datadir, "annotations.xlsx")

demoData <-
  suppressWarnings(readNanoStringGeomxSet(dccFiles = DCCFiles,
                                          pkcFiles = PKCFiles,
                                          phenoDataFile = SampleAnnotationFile,
                                          phenoDataSheet = "CW005",
                                          phenoDataDccColName = "Sample_ID",
                                          protocolDataColNames = c("aoi",
                                                                   "cell_line",
                                                                   "roi_rep",
                                                                   "pool_rep",
                                                                   "slide_rep"),
                                          experimentDataColNames = c("panel")))
class( demoData )
isS4( demoData )
is( demoData, "ExpressionSet" )
demoData

## -----------------------------------------------------------------------------
head( pData( demoData ), 2 )
protocolData( demoData )
svarLabels( demoData )
head( sData(demoData), 2 )

## -----------------------------------------------------------------------------
design( demoData ) <- ~ `segments`
design( demoData )

dimLabels( demoData )
dimLabels( demoData )[2] <- "Sample ID"
dimLabels( demoData )

## -----------------------------------------------------------------------------
sessionInfo()

