## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  comment = "#>", collapse = TRUE, message = FALSE, warning = FALSE,
  fig.align='center'
)

## ----eval = FALSE-------------------------------------------------------------
#  if (!require("BiocManager"))
#      install.packages("BiocManager")
#  BiocManager::install("GenomicSuperSignature")
#  BiocManager::install("bcellViper")

## ----results="hide", message=FALSE, warning=FALSE-----------------------------
library(GenomicSuperSignature)
library(bcellViper)

## ----load_model---------------------------------------------------------------
RAVmodel <- getModel("PLIERpriors", load=TRUE)
RAVmodel

## ----message=FALSE, warning=FALSE---------------------------------------------
data(bcellViper)
dset

## -----------------------------------------------------------------------------
val_all <- validate(dset, RAVmodel)
head(val_all)

## ----out.height="40%", out.width="40%", message=FALSE, warning=FALSE----------
heatmapTable(val_all, num.out = 5, swCutoff = 0)

## ----out.height="75%", out.width="75%", plotValidate_function-----------------
plotValidate(val_all, interactive = FALSE)

## -----------------------------------------------------------------------------
validated_ind <- validatedSignatures(val_all, num.out = 3, 
                                     swCutoff = 0, indexOnly = TRUE)
validated_ind

## ----out.height="50%", out.width="50%"----------------------------------------
set.seed(1) # only if you want to reproduce identical display of the same words
drawWordcloud(RAVmodel, validated_ind[1])
drawWordcloud(RAVmodel, validated_ind[2])
drawWordcloud(RAVmodel, validated_ind[3])

## -----------------------------------------------------------------------------
RAVnum <- validated_ind[2]  # RAV1139
res <- gsea(RAVmodel)[[RAVnum]]   
head(res)

## -----------------------------------------------------------------------------
findSignature(RAVmodel, "Bcell")

## -----------------------------------------------------------------------------
findSignature(RAVmodel, "Bcell", k = 5)

## -----------------------------------------------------------------------------
findKeywordInRAV(RAVmodel, "Bcell", ind = 695)

## -----------------------------------------------------------------------------
subsetEnrichedPathways(RAVmodel, ind = RAVnum, n = 3, both = TRUE)
subsetEnrichedPathways(RAVmodel, ind = 695, n = 3, both = TRUE)
subsetEnrichedPathways(RAVmodel, ind = 1994, n = 3, both = TRUE)

## -----------------------------------------------------------------------------
studyAccess <- findStudiesInCluster(RAVmodel, validated_ind[2])
studyAccess

## -----------------------------------------------------------------------------
dir <- system.file("extdata", package = "GenomicSuperSignature")
studyMeta <- read.table(file.path(dir, "studyMeta.tsv.gz"))

ind <- which(studyMeta$studyName %in% studyAccess)
studyMeta[ind, c("studyName", "title")]

## -----------------------------------------------------------------------------
sessionInfo()

