/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.FDRcalculator;
import cn.bgi.FastaReader;
import cn.bgi.ProteinGroup;
import cn.bgi.PsmPool;
import cn.bgi.Spectra;
import de.proteinms.xtandemparser.interfaces.Modification;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.FragmentIon;
import de.proteinms.xtandemparser.xtandem.ModificationMap;
import de.proteinms.xtandemparser.xtandem.Peptide;
import de.proteinms.xtandemparser.xtandem.PeptideMap;
import de.proteinms.xtandemparser.xtandem.Spectrum;
import de.proteinms.xtandemparser.xtandem.SupportData;
import de.proteinms.xtandemparser.xtandem.XTandemFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MainRun {
    public static boolean reMap = true;

    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException, InterruptedException, ExecutionException {
        String xmlfile = args[0];
        String fasta = args[1];
        String projname = args[2];
        String outdir = args[3];
        String decoyString = args[4];
        String sapPrefixString = args[5];
        reMap = !args[6].startsWith("0");
        FastaReader.setCpu(Integer.valueOf(args[7]));
        MainRun.run(xmlfile, fasta, projname, outdir, decoyString, sapPrefixString);
    }

    public static void run(String xmlfile, String fasta, String projname, String outdir, String decoyString, String sapPrefixString) throws IOException, SAXException, ParserConfigurationException, InterruptedException, ExecutionException {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(dateformat.format(new Date()));
        if (reMap) {
            System.out.println("You set to re-map the peptide to protein!");
        }
        System.out.println("Process file: " + xmlfile + "...");
        File cdir = new File(outdir);
        if (!cdir.isDirectory()) {
            cdir.mkdirs();
        }
        XTandemFile xf = new XTandemFile(xmlfile);
        ModificationMap modMap = xf.getModificationMap();
        String modmass = xf.getInputParameters().getResiduePotModMass();
        String[] varmod = null;
        HashMap<String, Double> varModifiableSites = new HashMap<String, Double>();
        if (modmass != null && !modmass.isEmpty()) {
            String[] stringArray = varmod = xf.getInputParameters().getResiduePotModMass().split(",");
            int n = varmod.length;
            int n2 = 0;
            while (n2 < n) {
                String modif = stringArray[n2];
                double mass = Double.parseDouble(modif.split("@")[0]);
                modif = modif.split("@")[1];
                Pattern pattern = Pattern.compile("\\[(\\w+)\\]");
                Matcher matcher = pattern.matcher(modif);
                if (matcher.find()) {
                    String[] multiSites;
                    String[] stringArray2 = multiSites = matcher.group(1).split("");
                    int n3 = multiSites.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String ms = stringArray2[n4];
                        if (!varModifiableSites.containsKey(ms) && !ms.isEmpty()) {
                            varModifiableSites.put(ms, mass);
                        }
                        ++n4;
                    }
                } else if (!varModifiableSites.containsKey(modif)) {
                    varModifiableSites.put(modif, mass);
                }
                ++n2;
            }
        }
        ArrayList<Spectrum> specList = xf.getSpectraList();
        PeptideMap pepMap = xf.getPeptideMap();
        String pepfile = String.valueOf(outdir) + "/" + projname + "-rawPSMs.txt";
        BufferedWriter pepfilebw = new BufferedWriter(new FileWriter(new File(pepfile)));
        pepfilebw.write("index\tevalue\tcharge\tmass\tmz\tdelta_da\tdelta_ppm\tpeptide\tisdecoy\tmiss\tprotein\trt\tmods\tisSap\tposition\n");
        PsmPool psmPool = new PsmPool();
        int i = 0;
        while (i < specList.size()) {
            Spectrum specTemp = specList.get(i);
            int specNum = specTemp.getSpectrumNumber();
            ArrayList<Peptide> spectrumPeptides = pepMap.getAllPeptides(specNum);
            Peptide bestPeptide = spectrumPeptides.get(0);
            if (bestPeptide != null) {
                boolean isSAP = true;
                StringBuilder pepPosInProString = new StringBuilder();
                Domain firstDomainBestPep = bestPeptide.getDomains().get(0);
                int pstart = firstDomainBestPep.getDomainStart();
                int pend = firstDomainBestPep.getDomainEnd();
                pepPosInProString.append(String.valueOf(pstart) + ":" + pend);
                StringBuilder accStringBuilder = new StringBuilder();
                String accString = firstDomainBestPep.getProteinKey().split("\\s")[0];
                accStringBuilder.append(accString);
                if (!accString.startsWith(sapPrefixString)) {
                    isSAP = false;
                }
                boolean isDecoy = false;
                if (accString.startsWith(decoyString)) {
                    isDecoy = true;
                }
                int j = 1;
                while (j < bestPeptide.getDomains().size()) {
                    Domain dm = bestPeptide.getDomains().get(j);
                    int pstart1 = dm.getDomainStart();
                    int pend1 = dm.getDomainEnd();
                    accStringBuilder.append(";");
                    String accTmp = dm.getProteinKey().split("\\s")[0];
                    accStringBuilder.append(accTmp);
                    pepPosInProString.append(";" + pstart1 + ":" + pend1);
                    if (!accTmp.startsWith(sapPrefixString)) {
                        isSAP = false;
                    }
                    if (accTmp.startsWith(decoyString)) {
                        isDecoy = true;
                    }
                    ++j;
                }
                int k = 1;
                while (k < spectrumPeptides.size()) {
                    if (spectrumPeptides.get(k).getDomains().get(0).getDomainExpect() == bestPeptide.getDomains().get(0).getDomainExpect() && spectrumPeptides.get(k).getDomains().get(0).getDomainSequence().equalsIgnoreCase(bestPeptide.getDomains().get(0).getDomainSequence())) {
                        int j2 = 0;
                        while (j2 < spectrumPeptides.get(k).getDomains().size()) {
                            Domain dm = spectrumPeptides.get(k).getDomains().get(j2);
                            int pstart1 = dm.getDomainStart();
                            int pend1 = dm.getDomainEnd();
                            accStringBuilder.append(";");
                            String accTmp = dm.getProteinKey().split("\\s")[0];
                            accStringBuilder.append(accTmp);
                            pepPosInProString.append(";" + pstart1 + ":" + pend1);
                            if (!accTmp.startsWith(sapPrefixString)) {
                                isSAP = false;
                            }
                            if (accTmp.startsWith(decoyString)) {
                                isDecoy = true;
                            }
                            ++j2;
                        }
                    }
                    ++k;
                }
                String domainKey = firstDomainBestPep.getDomainKey();
                ArrayList<String> modString = new ArrayList<String>();
                String modSites = "";
                ArrayList<Modification> mdl = modMap.getVariableModifications(domainKey);
                int j3 = 0;
                while (j3 < mdl.size()) {
                    modSites = String.valueOf(modSites) + mdl.get(j3).getName() + ";";
                    String residue = mdl.get(j3).getName().split("@")[1];
                    if (varModifiableSites.containsKey(residue) && !modString.contains(residue)) {
                        modString.add(residue);
                    }
                    ++j3;
                }
                mdl = modMap.getFixedModifications(domainKey);
                j3 = 0;
                while (j3 < mdl.size()) {
                    modSites = String.valueOf(modSites) + mdl.get(j3).getName() + ";";
                    ++j3;
                }
                modSites = modSites.isEmpty() ? "-" : modSites.replaceAll(";$", "");
                Spectra psm = new Spectra(String.valueOf(specNum));
                specTemp.getExpectValue();
                StringBuilder pepoutBuilder = new StringBuilder();
                pepoutBuilder.append(String.valueOf(specNum) + "\t");
                pepoutBuilder.append(String.valueOf(firstDomainBestPep.getDomainExpect()) + "\t");
                psm.setScore(firstDomainBestPep.getDomainExpect());
                pepoutBuilder.append(String.valueOf(specTemp.getPrecursorCharge()) + "\t");
                psm.setCharge(specTemp.getPrecursorCharge());
                double precmass = specTemp.getPrecursorMh() - firstDomainBestPep.getDomainDeltaMh() - 1.007825 - 0.00549;
                pepoutBuilder.append(String.valueOf(precmass) + "\t");
                psm.setParentmass(precmass);
                double mz = specTemp.getPrecursorMh();
                pepoutBuilder.append(String.valueOf(mz) + "\t");
                psm.setMz(mz);
                pepoutBuilder.append(String.valueOf(firstDomainBestPep.getDomainDeltaMh()) + "\t");
                psm.setDelta_da(firstDomainBestPep.getDomainDeltaMh());
                double ppm = firstDomainBestPep.getDomainDeltaMh() / precmass * 1000000.0;
                pepoutBuilder.append(String.valueOf(ppm) + "\t");
                psm.setDelta_ppm(ppm);
                pepoutBuilder.append(String.valueOf(firstDomainBestPep.getDomainSequence()) + "\t");
                psm.setPepSeq(firstDomainBestPep.getDomainSequence());
                pepoutBuilder.append(String.valueOf(isDecoy) + "\t");
                psm.setDecoy(isDecoy);
                pepoutBuilder.append(String.valueOf(firstDomainBestPep.getMissedCleavages()) + "\t");
                psm.setMissc(firstDomainBestPep.getMissedCleavages());
                pepoutBuilder.append(accStringBuilder + "\t");
                psm.setProString(accStringBuilder.toString());
                String rt = specTemp.getPrecursorRetentionTime().isEmpty() ? "-1" : specTemp.getPrecursorRetentionTime();
                pepoutBuilder.append(String.valueOf(rt) + "\t");
                psm.setRt(Double.valueOf(rt));
                pepoutBuilder.append(String.valueOf(modSites) + "\t");
                psm.setMods(modSites);
                pepoutBuilder.append(String.valueOf(isSAP) + "\t");
                psm.setSAP(isSAP);
                pepoutBuilder.append(pepPosInProString.toString());
                psm.setPosString(pepPosInProString.toString());
                pepfilebw.write(String.valueOf(pepoutBuilder.toString()) + "\n");
                psmPool.addPsm(psm);
                psmPool.putCharge2lastPSM(psm.getChargeClass(), psm);
            }
            ++i;
        }
        pepfilebw.close();
        System.out.println(dateformat.format(new Date()));
        System.out.println("Raw PSMs information extraction done!");
        String outFilterPsmFile = String.valueOf(outdir) + "/" + projname + "-peptideSummary.txt";
        Spectra.setSapPrefixString(sapPrefixString);
        Spectra.setDecoyPrefixString(decoyString);
        FDRcalculator.initialize(reMap, 0.01, outFilterPsmFile, fasta);
        FDRcalculator.setDecoyString(decoyString);
        FastaReader.setDecoyString(decoyString);
        HashSet<String> psmIdHashSet = FDRcalculator.fdrCalc(psmPool);
        System.out.println(dateformat.format(new Date()));
        System.out.println("FDR calculation done!");
        MainRun.outPSMpeak(psmIdHashSet, xf, outdir);
        System.out.println(dateformat.format(new Date()));
        System.out.println("Peak labeling information extraction done!");
        String outProtienFile = String.valueOf(outdir) + "/" + projname + "-proteinSummary.txt";
        ProteinGroup.proteinGrouper(outFilterPsmFile, outProtienFile, fasta, sapPrefixString);
        System.out.println(dateformat.format(new Date()));
        System.out.println("Protein inference done!");
    }

    private static void outPSMpeak(HashSet<String> psmIdHashSet, XTandemFile xf, String outdir) throws IOException {
        Iterator<String> it = psmIdHashSet.iterator();
        while (it.hasNext()) {
            int specNum = Integer.valueOf(it.next());
            String ms2id = String.valueOf(specNum);
            String ms2file = String.valueOf(outdir) + "/" + ms2id + "_ms2match.txt";
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(ms2file)));
            StringBuilder ms2outBuilder = new StringBuilder();
            PeptideMap pepMap = xf.getPeptideMap();
            ArrayList<Peptide> spectrumPeptides = pepMap.getAllPeptides(specNum);
            Peptide bestPeptide = spectrumPeptides.get(0);
            Domain firstDomainBestPep = bestPeptide.getDomains().get(0);
            Vector fragIonList = xf.getFragmentIonsForPeptide(bestPeptide, firstDomainBestPep, xf.getInputParameters().getSpectrumMonoIsoMassError());
            int j = 0;
            while (j < fragIonList.size()) {
                int k = 0;
                while (k < ((FragmentIon[])fragIonList.get(j)).length) {
                    block11: {
                        String ionDesc;
                        int ionNumber;
                        FragmentIon ion;
                        block10: {
                            block14: {
                                block13: {
                                    block12: {
                                        block9: {
                                            ion = ((FragmentIon[])fragIonList.get(j))[k];
                                            ionNumber = ion.getNumber();
                                            ionDesc = ion.getLetter();
                                            if (!ionDesc.startsWith("b")) break block9;
                                            if (xf.getInputParameters().isScoring_bIons()) break block10;
                                            break block11;
                                        }
                                        if (!ionDesc.startsWith("y")) break block12;
                                        if (xf.getInputParameters().isScoring_yIons()) break block10;
                                        break block11;
                                    }
                                    if (!ionDesc.startsWith("c")) break block13;
                                    if (xf.getInputParameters().isScoring_cIons()) break block10;
                                    break block11;
                                }
                                if (!ionDesc.startsWith("z")) break block14;
                                if (xf.getInputParameters().isScoring_zIons()) break block10;
                                break block11;
                            }
                            if (!ionDesc.startsWith("a") ? !ionDesc.startsWith("x") || !xf.getInputParameters().isScoring_xIons() : !xf.getInputParameters().isScoring_aIons()) break block11;
                        }
                        if (ionNumber > 0) {
                            ionDesc = String.valueOf(ionDesc) + ionNumber;
                        }
                        if (ion.getCharge() > 1.0) {
                            int jj = 0;
                            while ((double)jj < ion.getCharge()) {
                                ionDesc = String.valueOf(ionDesc) + "+";
                                ++jj;
                            }
                        }
                        ms2outBuilder.append(String.valueOf(ion.getMZ()) + "\t");
                        ms2outBuilder.append(String.valueOf(ion.getIntensity()) + "\t");
                        ms2outBuilder.append(String.valueOf(ionDesc) + "\n");
                    }
                    ++k;
                }
                ++j;
            }
            bWriter.write(ms2outBuilder.toString());
            bWriter.close();
            String ms2rawfile = String.valueOf(outdir) + "/" + ms2id + "_rawPeakList.txt";
            BufferedWriter bWriter4ms2rawfile = new BufferedWriter(new FileWriter(new File(ms2rawfile)));
            SupportData supportData = xf.getSupportData(specNum);
            String peakList = MainRun.getPeakList(supportData);
            bWriter4ms2rawfile.write(peakList);
            bWriter4ms2rawfile.close();
        }
    }

    private static String getPeakList(SupportData supportData) {
        StringBuilder sBuilder = new StringBuilder();
        ArrayList<Double> mzValues = supportData.getXValuesFragIonMass2Charge();
        ArrayList<Double> intensityValues = supportData.getYValuesFragIonMass2Charge();
        int i = 0;
        while (i < mzValues.size()) {
            sBuilder.append(mzValues.get(i) + "\t" + intensityValues.get(i) + "\n");
            ++i;
        }
        return sBuilder.toString();
    }
}

