### R code from vignette source 'rRDP.Rnw'

###################################################
### code chunk number 1: rRDP.Rnw:119-122
###################################################
options(width = 70, prompt="R> ", digits=4)
### for sampling
set.seed(1234)


###################################################
### code chunk number 2: rRDP.Rnw:137-142
###################################################
library(rRDP)

seq <- readRNAStringSet(system.file("examples/RNA_example.fasta",
        package="rRDP"))
seq


###################################################
### code chunk number 3: rRDP.Rnw:149-153
###################################################
annotation <- names(seq)

names(seq) <-  sapply(strsplit(names(seq), " "), "[", 1)
seq


###################################################
### code chunk number 4: rRDP.Rnw:159-161
###################################################
pred <- predict(rdp(), seq)
pred


###################################################
### code chunk number 5: rRDP.Rnw:165-166
###################################################
attr(pred, "confidence")


###################################################
### code chunk number 6: rRDP.Rnw:174-176
###################################################
actual <- decode_Greengenes(annotation)
actual


###################################################
### code chunk number 7: rRDP.Rnw:182-184
###################################################
confusionTable(actual, pred, rank="genus")
accuracy(actual, pred, rank="genus")


###################################################
### code chunk number 8: rRDP.Rnw:191-194
###################################################
trainingSequences <- readDNAStringSet(
    system.file("examples/trainingSequences.fasta", package="rRDP"))
trainingSequences


###################################################
### code chunk number 9: rRDP.Rnw:206-207
###################################################
sprintf(names(trainingSequences[1]), fmt="%.65s...")


###################################################
### code chunk number 10: rRDP.Rnw:213-215
###################################################
customRDP <- trainRDP(trainingSequences, dir = "myRDP")
customRDP


###################################################
### code chunk number 11: rRDP.Rnw:218-222
###################################################
testSequences <- readDNAStringSet(
    system.file("examples/testSequences.fasta", package="rRDP"))
pred <- predict(customRDP, testSequences)
pred


###################################################
### code chunk number 12: rRDP.Rnw:228-229
###################################################
customRDP <- rdp(dir = "myRDP")


###################################################
### code chunk number 13: rRDP.Rnw:234-235
###################################################
removeRDP(customRDP)


