/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers;

import edu.msu.cme.rdp.readseq.MaskSequenceNotFoundException;
import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.SeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.EMBLCore;
import edu.msu.cme.rdp.readseq.readers.core.FastaCore;
import edu.msu.cme.rdp.readseq.readers.core.FastqCore;
import edu.msu.cme.rdp.readseq.readers.core.GenbankCore;
import edu.msu.cme.rdp.readseq.readers.core.SFFCore;
import edu.msu.cme.rdp.readseq.readers.core.STKCore;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedSeqReader
implements SeqReader {
    public Map<String, Long> seqIndex = new LinkedHashMap<String, Long>();
    private boolean ignoreGaps = false;
    private boolean filterSeqs = false;
    private static ReentrantLock lock = new ReentrantLock();
    private char[] maskSeq;
    private SeqReaderCore core;
    private SequenceFormat format;

    public IndexedSeqReader(File f) throws IOException {
        this.setup(f, false, true, null, SeqUtils.guessFileFormat(f));
    }

    public IndexedSeqReader(File f, boolean ignoreGaps) throws IOException {
        this.setup(f, ignoreGaps, true, null, SeqUtils.guessFileFormat(f));
    }

    public IndexedSeqReader(File f, File indexFile) throws IOException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, false, true, IndexedSeqReader.readExternalIndex(f, indexFile, guess), guess);
    }

    public IndexedSeqReader(File f, File indexFile, boolean ignoreGaps) throws IOException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, ignoreGaps, true, IndexedSeqReader.readExternalIndex(f, indexFile, guess), guess);
    }

    public IndexedSeqReader(File f, File indexFile, String maskSeqId) throws IOException, MaskSequenceNotFoundException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, maskSeqId, false, true, IndexedSeqReader.readExternalIndex(f, indexFile, guess), guess);
    }

    public IndexedSeqReader(File f, File indexFile, String maskSeqId, boolean ignoreGaps) throws IOException, MaskSequenceNotFoundException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, maskSeqId, ignoreGaps, true, IndexedSeqReader.readExternalIndex(f, indexFile, guess), guess);
    }

    public IndexedSeqReader(File f, String maskSeqId) throws IOException, MaskSequenceNotFoundException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, maskSeqId, false, true, null, guess);
    }

    public IndexedSeqReader(File f, String maskSeqId, boolean ignoreGaps) throws IOException, MaskSequenceNotFoundException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, maskSeqId, ignoreGaps, true, null, guess);
    }

    public IndexedSeqReader(File f, boolean ignoreGaps, boolean filterSeqs) throws IOException {
        this.setup(f, ignoreGaps, filterSeqs, null, SeqUtils.guessFileFormat(f));
    }

    public IndexedSeqReader(File f, File indexFile, boolean ignoreGaps, boolean filterSeqs) throws IOException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, ignoreGaps, filterSeqs, IndexedSeqReader.readExternalIndex(f, indexFile, guess), guess);
    }

    public IndexedSeqReader(File f, File indexFile, String maskSeqId, boolean ignoreGaps, boolean filterSeqs) throws IOException, MaskSequenceNotFoundException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, maskSeqId, ignoreGaps, filterSeqs, IndexedSeqReader.readExternalIndex(f, indexFile, guess), guess);
    }

    public IndexedSeqReader(File f, String maskSeqId, boolean ignoreGaps, boolean filterSeqs) throws IOException, MaskSequenceNotFoundException {
        SequenceFormat guess = SeqUtils.guessFileFormat(f);
        this.setup(f, maskSeqId, ignoreGaps, filterSeqs, null, guess);
    }

    private void setup(File seqFile, String maskSeqId, boolean ignoreGaps, boolean filterSeqs, Map<String, Long> suppliedSeqIndex, SequenceFormat format) throws IOException, MaskSequenceNotFoundException {
        this.setup(seqFile, ignoreGaps, filterSeqs, suppliedSeqIndex, format);
        if (!this.seqIndex.containsKey(maskSeqId)) {
            throw new MaskSequenceNotFoundException(maskSeqId);
        }
        Sequence seq = this.core.parse(this.seqIndex.get(maskSeqId));
        this.maskSeq = SeqUtils.filterSeqString(seq.getSeqString(), false).toCharArray();
        this.core.seek(this.seqIndex.get(this.getSeqIds().get(0)));
    }

    private void setup(File seqFile, boolean ignoreGaps, boolean filterSeqs, Map<String, Long> suppliedSeqIndex, SequenceFormat format) throws IOException {
        if (format == SequenceFormat.FASTA) {
            this.core = new FastaCore(seqFile);
        } else if (format == SequenceFormat.FASTQ) {
            this.core = new FastqCore(seqFile);
        } else if (format == SequenceFormat.SFF) {
            this.core = new SFFCore(seqFile);
        } else if (format == SequenceFormat.STK) {
            this.core = new STKCore(seqFile);
        } else if (format == SequenceFormat.EMBL) {
            this.core = new EMBLCore(seqFile);
        } else if (format == SequenceFormat.GENBANK) {
            this.core = new GenbankCore(seqFile);
        } else if (format == SequenceFormat.EMPTY) {
            this.core = new SeqReaderCore.EmptyCore(seqFile);
        } else {
            throw new IOException("Unsupported file format " + (Object)((Object)format));
        }
        this.ignoreGaps = ignoreGaps;
        this.filterSeqs = filterSeqs;
        this.format = format;
        if (suppliedSeqIndex == null) {
            suppliedSeqIndex = this.core.scan();
        }
        this.seqIndex = suppliedSeqIndex;
    }

    @Override
    public SequenceFormat getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Sequence> readFully(File seqFile, String maskSeq, boolean ignoreGaps, boolean filterSeqs) throws IOException, MaskSequenceNotFoundException {
        ArrayList<Sequence> ret = new ArrayList<Sequence>();
        IndexedSeqReader reader = new IndexedSeqReader(seqFile, maskSeq, ignoreGaps, filterSeqs);
        try {
            for (String seqid : reader.getSeqIdSet()) {
                if (seqid.startsWith("#")) continue;
                ret.add(reader.readSeq(seqid));
            }
            ArrayList<Sequence> arrayList = ret;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    private static Map<String, Long> readExternalIndex(File seqFile, File indexFile, SequenceFormat expectedFormat) throws IOException {
        DataInputStream reader = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile)));
        if (reader.readLong() != seqFile.length()) {
            throw new IOException("Sequence file's size has changed since it was index");
        }
        SequenceFormat format = SequenceFormat.valueOf(reader.readUTF());
        if (format != expectedFormat) {
            throw new IllegalArgumentException("Sequence file format " + (Object)((Object)format) + " is not of the expected format " + (Object)((Object)expectedFormat));
        }
        HashMap<String, Long> ret = new HashMap<String, Long>();
        try {
            while (true) {
                String seqid = reader.readUTF();
                Long index = reader.readLong();
                ret.put(seqid, index);
            }
        }
        catch (EOFException e) {
            reader.close();
            return ret;
        }
    }

    public static void indexSeqFile(File seqFile, File indexFile) throws IOException {
        IndexedSeqReader.indexSeqFile(seqFile, indexFile, SeqUtils.guessFileFormat(seqFile));
    }

    public static void indexSeqFile(File seqFile, File indexFile, SequenceFormat format) throws IOException {
        if (format != SequenceFormat.FASTA) {
            throw new IllegalArgumentException("Format " + (Object)((Object)format) + "is not supported");
        }
        FastaCore core = new FastaCore(seqFile);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
        long startTime = System.currentTimeMillis();
        int written = core.scanToStream(out);
        System.out.println("Indexed " + written + " sequences in " + (System.currentTimeMillis() - startTime) + " ms");
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    public List<String> getSeqIds() {
        ArrayList<String> ret = new ArrayList<String>(this.seqIndex.keySet());
        HashSet<String> remove = new HashSet<String>(Arrays.asList("struct", "structure", "mask"));
        for (String seqid : ret) {
            if (!seqid.startsWith("#")) continue;
            remove.add(seqid);
        }
        ret.removeAll(remove);
        return ret;
    }

    public Set<String> getSeqIdSet() {
        return Collections.unmodifiableSet(this.seqIndex.keySet());
    }

    private Sequence readFrom(long location) throws IOException {
        Sequence seq = this.core.parse(location);
        try {
            if (this.filterSeqs && seq.getSeqName() != null) {
                seq.setSeqString(this.filterSequence(seq.getSeqString()));
            }
            return seq;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to filter sequence " + seq.getSeqName(), e);
        }
    }

    public Sequence readSeq(String id) throws IOException {
        try {
            lock.lock();
            if (this.seqIndex.containsKey(id)) {
                Sequence sequence = this.readFrom(this.seqIndex.get(id));
                return sequence;
            }
            throw new IOException("Sequence " + id + " not found in file");
        }
        finally {
            lock.unlock();
        }
    }

    public List<Sequence> readSeqs(Collection<String> ids) throws IOException {
        ArrayList<Sequence> ret = new ArrayList<Sequence>();
        for (String id : ids) {
            ret.add(this.readSeq(id));
        }
        return ret;
    }

    public Sequence readNextSequence() throws IOException {
        try {
            lock.lock();
            Sequence seq = this.core.readNextSequence();
            try {
                if (this.filterSeqs && seq != null && seq.getSeqName() != null) {
                    seq.setSeqString(this.filterSequence(seq.getSeqString()));
                }
                Sequence sequence = seq;
                return sequence;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to filter sequence " + seq.getSeqName(), e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected String filterSequence(String seq) {
        seq = SeqUtils.filterSeqString(seq, this.ignoreGaps);
        if (this.maskSeq != null) {
            seq = SeqUtils.getMaskedSeq(seq, this.maskSeq);
        }
        return seq;
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        IndexedSeqReader reader = new IndexedSeqReader(new File("/scratch/fishjord/woojun_unifrac_run3/run3.fasta"));
        long stopTime = System.currentTimeMillis();
        System.out.println("Time to index file: " + (stopTime - startTime) + "ms");
        System.out.println("Mask seq index: " + reader.seqIndex.get("#=GC_SS_cons"));
        System.out.println("Mask seq: " + reader.readSeq("#=GC_SS_cons").getSeqString());
        System.out.println("Total seq count: " + reader.getSeqIds().size());
    }
}

