/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.MultiClassifierResult;
import edu.msu.cme.rdp.multicompare.taxon.MCTaxon;
import edu.msu.cme.rdp.multicompare.visitors.DefaultPrintVisitor;
import edu.msu.cme.rdp.taxatree.ConcretRoot;
import edu.msu.cme.rdp.taxatree.Node;
import edu.msu.cme.rdp.taxatree.TaxonHolder;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class MergeTaxonCount {
    private MultiClassifierResult result = null;

    public MultiClassifierResult getResult() {
        return this.result;
    }

    public void processOneHierFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        ArrayList<Object> oneHierBlock = new ArrayList<String[]>();
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("")) continue;
            if (line.startsWith("taxid")) {
                if (oneHierBlock.size() > 0) {
                    this.processOneHierBlock(oneHierBlock);
                }
                oneHierBlock = new ArrayList();
            }
            oneHierBlock.add(line.split("\\t"));
        }
        if (oneHierBlock.size() > 0) {
            this.processOneHierBlock(oneHierBlock);
        }
        reader.close();
    }

    public void processOneHierBlock(ArrayList<String[]> oneHierBlock) throws IOException {
        int offset = 4;
        String[] values = oneHierBlock.get(0);
        ArrayList<MCSample> curSampleList = new ArrayList<MCSample>();
        for (int i = offset; i < values.length; ++i) {
            MCSample sample;
            if (this.result != null) {
                sample = this.result.getSample(values[i]);
                if (sample == null) {
                    sample = new MCSample(values[i]);
                    this.result.addSample(sample);
                }
                curSampleList.add(sample);
                continue;
            }
            sample = new MCSample(values[i]);
            curSampleList.add(sample);
        }
        values = oneHierBlock.get(1);
        if (this.result == null) {
            ConcretRoot root = new ConcretRoot((Node)new MCTaxon(Integer.parseInt(values[0]), values[2], values[3]));
            this.result = new MultiClassifierResult(root);
            this.result.addSampleList(curSampleList);
        }
        MCTaxon curTaxon = (MCTaxon)this.result.getRoot().getRootTaxonHodler().getTaxon();
        for (int i = offset; i < values.length; ++i) {
            curTaxon.incCount((MCSample)curSampleList.get(i - offset), Integer.parseInt(values[i]));
        }
        for (int ln = 2; ln < oneHierBlock.size(); ++ln) {
            values = oneHierBlock.get(ln);
            int taxid = Integer.parseInt(values[0]);
            String[] lineage = values[1].split(";");
            TaxonHolder parentTaxon = this.result.getRoot().getRootTaxonHodler();
            for (int i = 2; i < lineage.length - 2; i += 2) {
                TaxonHolder temp = parentTaxon.getImediateChildTaxon(lineage[i]);
                if (temp == null) {
                    throw new IOException("Error: Something is wrong with input file, can not find parent node " + lineage[i] + " in line: " + values[1]);
                }
                parentTaxon = temp;
            }
            TaxonHolder tempChild = parentTaxon.getImediateChildTaxon(values[2]);
            if (tempChild != null) {
                curTaxon = (MCTaxon)tempChild.getTaxon();
                if (curTaxon.getTaxid() != taxid) {
                    throw new IOException("Error: Something is wrong with input file: taxon name " + values[2] + " with taxid " + taxid + " does not match previous processed taxon " + curTaxon.getName() + " with taxid " + curTaxon.getTaxid() + ". Possibly from different training sets ??");
                }
            } else {
                curTaxon = new MCTaxon(taxid, values[2], values[3], false);
                this.result.getRoot().addChild((Node)curTaxon, parentTaxon.getTaxon().getTaxid());
                curTaxon.setLineage(values[1]);
            }
            for (int i = offset; i < values.length; ++i) {
                curTaxon.incCount((MCSample)curSampleList.get(i - offset), Integer.parseInt(values[i]));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        File outFile;
        String usage = "Usage: out_merged_count.txt in_taxoncount.txt n_taxoncount.txt ...\n  This program merges multiple taxon count files to into one count file, keeping one column for each unique sample.\n  If same sample occurred more than once, the taxon count for this sample will be combined.";
        if (args.length < 2) {
            System.err.println(usage);
            System.exit(1);
        }
        if ((outFile = new File(args[0])).exists()) {
            System.err.println("Error: output file " + args[0] + " already exists!");
            System.exit(1);
        }
        try {
            MergeTaxonCount theObj = new MergeTaxonCount();
            for (int i = 1; i < args.length; ++i) {
                theObj.processOneHierFile(args[i]);
            }
            PrintStream hier_out = new PrintStream(outFile);
            DefaultPrintVisitor printVisitor = new DefaultPrintVisitor(hier_out, theObj.getResult().getSamples());
            theObj.getResult().getRoot().topDownVisit((TreeVisitor)printVisitor);
            hier_out.close();
        }
        catch (Exception ex) {
            outFile.delete();
            throw ex;
        }
    }
}

