/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.utils;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.utils.IUBUtilities;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import java.util.Arrays;

public class ClassifierSequence
extends Sequence {
    public static final int RNA_BASES = 4;
    public static final int WORDSIZE = 8;
    public static final int MASK = 65535;
    private boolean reverse = false;
    private Integer goodWordCount = null;
    private static final int MAX_ASCII = 128;
    private static final int[] charIntegerLookup = new int[128];
    private static final int[] intComplementLookup = new int[4];

    public ClassifierSequence(Sequence seq) {
        this(seq.getSeqName(), seq.getDesc(), seq.getSeqString());
    }

    public ClassifierSequence(String seqName, String desc, String seqString) {
        super(seqName, desc, SeqUtils.getUnalignedSeqString((String)seqString));
    }

    protected void setSeqString(String s) {
        this.seqString = s;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public ClassifierSequence getReversedSeq() {
        ClassifierSequence retval = new ClassifierSequence(this.seqName, this.desc, IUBUtilities.reverseComplement((String)this.seqString));
        retval.reverse = true;
        return retval;
    }

    public static int[] getReversedWord(int[] word) {
        int length = word.length;
        int[] reverseWord = new int[length];
        for (int w = 0; w < length; ++w) {
            reverseWord[length - 1 - w] = intComplementLookup[word[w]];
        }
        return reverseWord;
    }

    public static int getWordIndex(int[] word) {
        int wordIndex = 0;
        for (int w = 0; w < word.length; ++w) {
            wordIndex <<= 2;
            wordIndex &= 0xFFFF;
            wordIndex |= word[w];
        }
        return wordIndex;
    }

    public int[] createWordIndexArr() {
        int[] wordIndexArr = new int[this.seqString.length()];
        this.createWordIndexArr(wordIndexArr);
        return wordIndexArr;
    }

    public void createWordIndexArr(int[] wordIndexArr) {
        if (wordIndexArr.length < this.seqString.length()) {
            throw new IllegalArgumentException("wordIndexArr buffer doesn't have enough room in it");
        }
        Arrays.fill(wordIndexArr, -1);
        int wordCount = 0;
        int count = 0;
        int wordIndex = 0;
        for (char c : this.seqString.toCharArray()) {
            int charIndex = c > '\u0000' && c < '\u0080' ? charIntegerLookup[c] : -1;
            if (charIndex == -1) {
                wordIndex = 0;
                count = 0;
                continue;
            }
            wordIndex <<= 2;
            wordIndex &= 0xFFFF;
            wordIndex |= charIndex;
            if (++count != 8) continue;
            wordIndexArr[wordCount] = wordIndex;
            ++wordCount;
            --count;
        }
        this.goodWordCount = wordCount;
    }

    public int getGoodWordCount() {
        if (this.goodWordCount == null) {
            this.createWordIndexArr();
        }
        return this.goodWordCount;
    }

    static {
        ClassifierSequence.intComplementLookup[0] = 1;
        ClassifierSequence.intComplementLookup[1] = 0;
        ClassifierSequence.intComplementLookup[2] = 3;
        ClassifierSequence.intComplementLookup[3] = 2;
        for (int i = 0; i < 128; ++i) {
            ClassifierSequence.charIntegerLookup[i] = -1;
        }
        ClassifierSequence.charIntegerLookup[65] = 0;
        ClassifierSequence.charIntegerLookup[85] = 1;
        ClassifierSequence.charIntegerLookup[84] = 1;
        ClassifierSequence.charIntegerLookup[71] = 2;
        ClassifierSequence.charIntegerLookup[67] = 3;
        ClassifierSequence.charIntegerLookup[97] = 0;
        ClassifierSequence.charIntegerLookup[117] = 1;
        ClassifierSequence.charIntegerLookup[116] = 1;
        ClassifierSequence.charIntegerLookup[103] = 2;
        ClassifierSequence.charIntegerLookup[99] = 3;
    }
}

