/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation;

import edu.msu.cme.rdp.classifier.train.validation.SortedROCSet;
import edu.msu.cme.rdp.classifier.train.validation.StatusCount;
import java.util.ArrayList;
import java.util.HashMap;

public class StatusCountUtils {
    public static String calROCMatrix(String label, ArrayList<HashMap<String, StatusCount>> statusCountList) {
        StringBuilder matrix = new StringBuilder();
        matrix.append("min_bootstrap_words\t" + label + "\n");
        matrix.append("bootstrap");
        HashMap<String, StatusCount> statusCountMap = statusCountList.get(0);
        for (String rank : statusCountMap.keySet()) {
            if (rank.startsWith("sub")) continue;
            matrix.append("\t" + rank + "_FPR" + "\t" + rank + "_TPR" + "\t" + rank + "_F1score");
        }
        matrix.append("\n");
        for (int b = 0; b < statusCountList.size(); ++b) {
            matrix.append(b);
            statusCountMap = statusCountList.get(b);
            for (String rank : statusCountMap.keySet()) {
                if (rank.startsWith("sub")) continue;
                StatusCount st = statusCountMap.get(rank);
                matrix.append("\t" + st.calFPR() + "\t" + st.calSensitivity() + "\t" + st.calF1score());
            }
            matrix.append("\n");
        }
        return matrix.toString();
    }

    public static String calAUC(String label, ArrayList<HashMap<String, StatusCount>> statusCountList) {
        StringBuilder matrix = new StringBuilder();
        HashMap<String, StatusCount> statusCountMap = statusCountList.get(0);
        matrix.append("AUC");
        for (String rank : statusCountMap.keySet()) {
            if (rank.startsWith("sub")) continue;
            matrix.append("\t" + rank);
        }
        matrix.append("\n");
        matrix.append("min_bootstrap_words_" + label);
        for (String rank : statusCountMap.keySet()) {
            if (rank.startsWith("sub")) continue;
            SortedROCSet sortedSet = new SortedROCSet();
            sortedSet.add(new SortedROCSet.PredictionCount(0.0, 0.0));
            sortedSet.add(new SortedROCSet.PredictionCount(1.0, 1.0));
            for (int b = 0; b < statusCountList.size(); ++b) {
                StatusCount st = statusCountList.get(b).get(rank);
                double se = st.calSensitivity();
                double fpr = st.calFPR();
                sortedSet.add(new SortedROCSet.PredictionCount(fpr, se));
            }
            double area = 0.0;
            Object[] pcArray = sortedSet.toArray();
            for (int i = 0; i < pcArray.length - 1; ++i) {
                SortedROCSet.PredictionCount lpc = (SortedROCSet.PredictionCount)pcArray[i];
                SortedROCSet.PredictionCount hpc = (SortedROCSet.PredictionCount)pcArray[i + 1];
                double trapezoid = 0.5 * Math.abs((hpc.fpr - lpc.fpr) * (hpc.se + lpc.se));
                if (Double.isNaN(trapezoid)) continue;
                area += trapezoid;
            }
            matrix.append("\t" + area);
        }
        matrix.append("\n");
        return matrix.toString();
    }
}

