/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.TranslationTable;

class TranslatedSymbolList
extends AbstractSymbolList
implements SymbolList {
    private final SymbolList source;
    private final TranslationTable transTable;

    public TranslatedSymbolList(SymbolList symbolList, TranslationTable translationTable) throws IllegalAlphabetException {
        if (translationTable.getSourceAlphabet() != symbolList.getAlphabet()) {
            throw new IllegalAlphabetException("The source alphabet and translation table source alphabets don't match: " + symbolList.getAlphabet().getName() + " and " + translationTable.getSourceAlphabet().getName());
        }
        this.source = symbolList;
        this.transTable = translationTable;
    }

    public Alphabet getAlphabet() {
        return this.transTable.getTargetAlphabet();
    }

    public SymbolList getSource() {
        return this.source;
    }

    public TranslationTable getTranslationTable() {
        return this.transTable;
    }

    public int length() {
        return this.source.length();
    }

    public Symbol symbolAt(int n) {
        try {
            return this.transTable.translate(this.source.symbolAt(n));
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "I thought that I had checked that the translation table was compatible with my source, but apparently something has messed up.");
        }
    }
}

