/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import org.biojava.bio.BioError;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;

public class SimpleStrandedFeature
extends SimpleFeature
implements StrandedFeature {
    private StrandedFeature.Strand strand;

    public SimpleStrandedFeature(Sequence sequence, FeatureHolder featureHolder, StrandedFeature.Template template) throws IllegalArgumentException, IllegalAlphabetException {
        super(sequence, featureHolder, template);
        this.strand = template.strand;
        if (sequence.getAlphabet() != DNATools.getDNA()) {
            throw new IllegalAlphabetException("Can not create a stranded feature within a sequence of type " + sequence.getAlphabet().getName());
        }
    }

    protected void fillTemplate(StrandedFeature.Template template) {
        super.fillTemplate(template);
        template.strand = this.getStrand();
    }

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public SymbolList getSymbols() {
        SymbolList symbolList = super.getSymbols();
        if (this.getStrand() == StrandedFeature.NEGATIVE) {
            try {
                symbolList = DNATools.complement(symbolList);
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException, "Could not retrieve symbols for feature as the alphabet can not be complemented.");
            }
        }
        return symbolList;
    }

    public Feature.Template makeTemplate() {
        StrandedFeature.Template template = new StrandedFeature.Template();
        this.fillTemplate(template);
        return template;
    }

    public String toString() {
        String string = this.getStrand() == StrandedFeature.POSITIVE ? "+" : "-";
        return String.valueOf(super.toString()) + " " + string;
    }
}

