/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SimpleSeqSimilaritySearchHit
implements SeqSimilaritySearchHit,
Cloneable {
    private SeqSimilaritySearchResult searchResult;
    private double score;
    private double pValue;
    private double eValue;
    private String sequenceID;
    private List subHits;

    public SimpleSeqSimilaritySearchHit(SeqSimilaritySearchResult seqSimilaritySearchResult, double d, double d2, double d3, String string, List list) {
        Contract.pre(seqSimilaritySearchResult != null, "searchResult was null");
        Contract.pre(Double.isNaN(d) ^ true, "score was NaN");
        Contract.pre(string != null, "sequenceID was null");
        Contract.pre(list != null, "subHits was null");
        this.searchResult = seqSimilaritySearchResult;
        this.score = d;
        this.pValue = d2;
        this.eValue = d3;
        this.sequenceID = string;
        this.subHits = list;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchHit simpleSeqSimilaritySearchHit = (SimpleSeqSimilaritySearchHit)object;
        if (!ObjectUtil.equals(this.searchResult, simpleSeqSimilaritySearchHit.searchResult)) {
            return false;
        }
        if (!ObjectUtil.equals(this.score, simpleSeqSimilaritySearchHit.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, simpleSeqSimilaritySearchHit.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, simpleSeqSimilaritySearchHit.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceID, simpleSeqSimilaritySearchHit.sequenceID)) {
            return false;
        }
        return ObjectUtil.equals(this.subHits, simpleSeqSimilaritySearchHit.subHits);
    }

    public double getEValue() {
        return this.eValue;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getScore() {
        return this.score;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public List getSubHits() {
        return Collections.unmodifiableList(this.subHits);
    }

    public int hashCode() {
        int n = 0;
        n = ObjectUtil.hashCode(n, this.searchResult);
        n = ObjectUtil.hashCode(n, this.score);
        n = ObjectUtil.hashCode(n, this.pValue);
        n = ObjectUtil.hashCode(n, this.eValue);
        n = ObjectUtil.hashCode(n, this.sequenceID);
        n = ObjectUtil.hashCode(n, this.subHits);
        return n;
    }

    public String toString() {
        return "SequenceDBSearchHit to " + this.getSequenceID() + " with score " + this.getScore();
    }
}

