/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.query.larq.IndexBuilderNode;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.File;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public abstract class IndexBuilderModel
extends StatementListener {
    private Directory dir = null;
    protected IndexBuilderNode index;

    public IndexBuilderModel() {
        this.index = new IndexBuilderNode();
    }

    public IndexBuilderModel(IndexWriter existingWriter) {
        this.index = new IndexBuilderNode(existingWriter);
    }

    public IndexBuilderModel(File fileDir) {
        this.index = new IndexBuilderNode(fileDir);
    }

    public IndexBuilderModel(String fileDir) {
        this.index = new IndexBuilderNode(fileDir);
    }

    public void removedStatement(Statement s) {
        this.unindexStatement(s);
    }

    public void unindexStatement(Statement s) {
        throw new UnsupportedOperationException("unindexStatement");
    }

    public void addedStatement(Statement s) {
        this.indexStatement(s);
    }

    public void indexStatements(StmtIterator sIter) {
        while (sIter.hasNext()) {
            this.indexStatement(sIter.nextStatement());
        }
    }

    public abstract void indexStatement(Statement var1);

    public void closeForWriting() {
        this.index.closeForWriting();
    }

    public void flushWriter() {
        this.index.flushWriter();
    }

    public void closeWriter() {
        this.index.closeWriter();
    }

    public IndexLARQ getIndex() {
        return this.index.getIndex();
    }
}

