/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import edu.rit.compbio.seq.Alignment;
import edu.rit.compbio.seq.ProteinLocalAlignment;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Range;

public class ProteinLocalAlignmentSmp
extends ProteinLocalAlignment {
    private ParallelTeam team;

    public ProteinLocalAlignmentSmp(ParallelTeam parallelTeam) {
        if (parallelTeam == null) {
            throw new NullPointerException("ProteinLocalAlignmentSmp(): team is null");
        }
        this.team = parallelTeam;
    }

    public Alignment align() throws Exception {
        if (this.A == null) {
            throw new IllegalStateException("ProteinLocalAlignmentSmp.align(): Query sequence not set");
        }
        if (this.B == null) {
            throw new IllegalStateException("ProteinLocalAlignmentSmp.align(): Subject sequence not set");
        }
        final int n = this.A.length - 1;
        final int n2 = this.B.length - 1;
        final int n3 = this.team.getThreadCount();
        final int n4 = n + n3 - 1;
        final FinishPoint finishPoint = new FinishPoint();
        finishPoint.maxScore = 0;
        finishPoint.theQueryFinish = 0;
        finishPoint.theSubjectFinish = 0;
        this.team.execute(new ParallelRegion(){

            public void run() throws Exception {
                int n11 = this.getThreadIndex();
                Range range = new Range(1, n2).subrange(n3, n11);
                int n22 = range.lb();
                int n32 = range.ub();
                int n42 = 0;
                int n5 = 0;
                int n6 = 0;
                for (int i = 1; i <= n4; ++i) {
                    int n7 = i - n11;
                    if (1 <= n7 && n7 <= n) {
                        byte by = ProteinLocalAlignmentSmp.this.A[n7];
                        int[] nArray = ProteinLocalAlignmentSmp.this.delta[by];
                        int[] nArray2 = ProteinLocalAlignmentSmp.this.S[n7 - 1];
                        int[] nArray3 = ProteinLocalAlignmentSmp.this.S[n7];
                        int[] nArray4 = ProteinLocalAlignmentSmp.this.GA[n7 - 1];
                        int[] nArray5 = ProteinLocalAlignmentSmp.this.GA[n7];
                        int[] nArray6 = ProteinLocalAlignmentSmp.this.GB[n7];
                        for (int j = n22; j <= n32; ++j) {
                            byte by2 = ProteinLocalAlignmentSmp.this.B[j];
                            int n8 = nArray2[j] + ProteinLocalAlignmentSmp.this.g;
                            n8 = Math.max(n8, nArray4[j] + ProteinLocalAlignmentSmp.this.h);
                            int n9 = nArray3[j - 1] + ProteinLocalAlignmentSmp.this.g;
                            n9 = Math.max(n9, nArray6[j - 1] + ProteinLocalAlignmentSmp.this.h);
                            int n10 = nArray2[j - 1] + nArray[by2];
                            n10 = Math.max(n10, n8);
                            n10 = Math.max(n10, n9);
                            if ((n10 = Math.max(n10, 0)) > n42) {
                                n42 = n10;
                                n5 = n7;
                                n6 = j;
                            }
                            nArray3[j] = n10;
                            nArray5[j] = n8;
                            nArray6[j] = n9;
                        }
                    }
                    this.barrier();
                }
                finishPoint.setToBest(n42, n5, n6);
            }
        });
        return this.computeTraceback(finishPoint.maxScore, finishPoint.theQueryFinish, finishPoint.theSubjectFinish);
    }

    private static class FinishPoint {
        public int maxScore;
        public int theQueryFinish;
        public int theSubjectFinish;

        private FinishPoint() {
        }

        public synchronized void setToBest(int n, int n2, int n3) {
            if (n > this.maxScore || n == this.maxScore && n2 < this.theQueryFinish || n == this.maxScore && n2 == this.theQueryFinish && n3 < this.theSubjectFinish) {
                this.maxScore = n;
                this.theQueryFinish = n2;
                this.theSubjectFinish = n3;
            }
        }
    }
}

