/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.antimatter;

import edu.rit.vector.Vector2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AntiprotonFile {
    private long seed;
    private double R;
    private double dt;
    private int steps;
    private int snaps;
    private int N;
    private int L;
    private int M;
    private boolean iamInitialized;

    public AntiprotonFile() {
    }

    public AntiprotonFile(long l, double d, double d2, int n, int n2, int n3, int n4, int n5) {
        this.setAttributes(l, d, d2, n, n2, n3, n4, n5);
    }

    public long getSeed() {
        this.verifyInitialized();
        return this.seed;
    }

    public double getR() {
        this.verifyInitialized();
        return this.R;
    }

    public double getDt() {
        this.verifyInitialized();
        return this.dt;
    }

    public int getSteps() {
        this.verifyInitialized();
        return this.steps;
    }

    public int getSnaps() {
        this.verifyInitialized();
        return this.snaps;
    }

    public int getN() {
        this.verifyInitialized();
        return this.N;
    }

    public int getL() {
        this.verifyInitialized();
        return this.L;
    }

    public int getM() {
        this.verifyInitialized();
        return this.M;
    }

    public void setAttributes(long l, double d, double d2, int n, int n2, int n3, int n4, int n5) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("AntiprotonFile.setAttributes(): R <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("AntiprotonFile.setAttributes(): dt <= 0");
        }
        if (n < 0) {
            throw new IllegalArgumentException("AntiprotonFile.setAttributes(): steps < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("AntiprotonFile.setAttributes(): snaps < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("AntiprotonFile.setAttributes(): N < 0");
        }
        if (n4 < 0) {
            throw new IndexOutOfBoundsException("AntiprotonFile.setAttributes(): L < 0");
        }
        if (n5 < 0) {
            throw new IndexOutOfBoundsException("AntiprotonFile.setAttributes(): M < 0");
        }
        if (n4 + n5 > n3) {
            throw new IndexOutOfBoundsException("AntiprotonFile.setAttributes(): L+M > N");
        }
        this.seed = l;
        this.R = d;
        this.dt = d2;
        this.steps = n;
        this.snaps = n2;
        this.N = n3;
        this.L = n4;
        this.M = n5;
        this.iamInitialized = true;
    }

    public Writer prepareToWrite(OutputStream outputStream) throws IOException {
        this.verifyInitialized();
        return new Writer(outputStream);
    }

    public Reader prepareToRead(InputStream inputStream) throws IOException {
        return new Reader(inputStream);
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length < 2) {
            System.err.println("Usage: java edu.rit.io.AntiprotonFile <outfile> <infile1> [<infile2> ...]");
            System.exit(1);
        }
        int n2 = stringArray.length - 1;
        AntiprotonFile[] antiprotonFileArray = new AntiprotonFile[n2];
        Reader[] readerArray = new Reader[n2];
        for (int i = 0; i < n2; ++i) {
            antiprotonFileArray[i] = new AntiprotonFile();
            readerArray[i] = antiprotonFileArray[i].prepareToRead(new BufferedInputStream(new FileInputStream(stringArray[i + 1])));
        }
        long l = antiprotonFileArray[0].getSeed();
        double d = antiprotonFileArray[0].getR();
        double d2 = antiprotonFileArray[0].getDt();
        int n3 = antiprotonFileArray[0].getSteps();
        int n4 = antiprotonFileArray[0].getSnaps();
        int n5 = antiprotonFileArray[0].getN();
        for (int i = 1; i < n2; ++i) {
            if (l != antiprotonFileArray[i].getSeed()) {
                System.err.println("AntiprotonFile: " + stringArray[1] + " seed (" + l + ") != " + stringArray[i + 1] + " seed (" + antiprotonFileArray[i].getSeed());
                System.exit(1);
            }
            if (d != antiprotonFileArray[i].getR()) {
                System.err.println("AntiprotonFile: " + stringArray[1] + " R (" + d + ") != " + stringArray[i + 1] + " R (" + antiprotonFileArray[i].getR());
                System.exit(1);
            }
            if (d2 != antiprotonFileArray[i].getDt()) {
                System.err.println("AntiprotonFile: " + stringArray[1] + " dt (" + d2 + ") != " + stringArray[i + 1] + " dt (" + antiprotonFileArray[i].getDt());
                System.exit(1);
            }
            if (n3 != antiprotonFileArray[i].getSteps()) {
                System.err.println("AntiprotonFile: " + stringArray[1] + " steps (" + n3 + ") != " + stringArray[i + 1] + " steps (" + antiprotonFileArray[i].getSteps());
                System.exit(1);
            }
            if (n4 != antiprotonFileArray[i].getSnaps()) {
                System.err.println("AntiprotonFile: " + stringArray[1] + " snaps (" + n4 + ") != " + stringArray[i + 1] + " snaps (" + antiprotonFileArray[i].getSnaps());
                System.exit(1);
            }
            if (n5 == antiprotonFileArray[i].getN()) continue;
            System.err.println("AntiprotonFile: " + stringArray[1] + " N (" + n5 + ") != " + stringArray[i + 1] + " N (" + antiprotonFileArray[i].getN());
            System.exit(1);
        }
        Vector2D[] vector2DArray = new Vector2D[n5];
        for (int i = 0; i < n5; ++i) {
            vector2DArray[i] = new Vector2D();
        }
        Vector2D vector2D = new Vector2D();
        Vector2D vector2D2 = new Vector2D();
        AntiprotonFile antiprotonFile = new AntiprotonFile(l, d, d2, n3, n4, n5, 0, n5);
        Writer writer = antiprotonFile.prepareToWrite(new BufferedOutputStream(new FileOutputStream(stringArray[0])));
        for (n = 0; n < n4; ++n) {
            vector2D.clear();
            for (int i = 0; i < n2; ++i) {
                readerArray[i].readSnapshot(vector2DArray, antiprotonFileArray[i].getL(), vector2D2);
                vector2D.add(vector2D2);
            }
            writer.writeSnapshot(vector2DArray, 0, vector2D);
        }
        for (n = 0; n < n2; ++n) {
            readerArray[n].close();
        }
        writer.close();
    }

    private void verifyInitialized() {
        if (!this.iamInitialized) {
            throw new IllegalStateException("AntiprotonFile: Not initialized");
        }
    }

    public class Reader {
        private InputStream myIs;
        private DataInputStream myDis;
        private int mySnaps;

        private Reader(InputStream inputStream) throws IOException {
            if (inputStream == null) {
                throw new NullPointerException("AntiprotonFile.Reader(): theStream is null");
            }
            this.myIs = inputStream;
            this.myDis = new DataInputStream(inputStream);
            AntiprotonFile.this.setAttributes(this.myDis.readLong(), this.myDis.readDouble(), this.myDis.readDouble(), this.myDis.readInt(), this.myDis.readInt(), this.myDis.readInt(), this.myDis.readInt(), this.myDis.readInt());
        }

        public int readSnapshot(Vector2D[] vector2DArray, int n, Vector2D vector2D) throws IOException {
            if (this.mySnaps >= AntiprotonFile.this.snaps) {
                throw new IllegalStateException("AntiprotonFile.Reader.readSnapshot(): Too many snapshots");
            }
            if (n < 0 || n + AntiprotonFile.this.M > vector2DArray.length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = 0; i < AntiprotonFile.this.M; ++i) {
                vector2DArray[i + n].x = this.myDis.readDouble();
                vector2DArray[i + n].y = this.myDis.readDouble();
            }
            vector2D.x = this.myDis.readDouble();
            vector2D.y = this.myDis.readDouble();
            return this.mySnaps++;
        }

        public void close() throws IOException {
            this.myDis.close();
        }
    }

    public class Writer {
        private OutputStream myOs;
        private DataOutputStream myDos;
        private int mySnaps;

        private Writer(OutputStream outputStream) throws IOException {
            if (outputStream == null) {
                throw new NullPointerException("AntiprotonFile.Writer(): theStream is null");
            }
            this.myOs = outputStream;
            this.myDos = new DataOutputStream(outputStream);
            this.myDos.writeLong(AntiprotonFile.this.seed);
            this.myDos.writeDouble(AntiprotonFile.this.R);
            this.myDos.writeDouble(AntiprotonFile.this.dt);
            this.myDos.writeInt(AntiprotonFile.this.steps);
            this.myDos.writeInt(AntiprotonFile.this.snaps);
            this.myDos.writeInt(AntiprotonFile.this.N);
            this.myDos.writeInt(AntiprotonFile.this.L);
            this.myDos.writeInt(AntiprotonFile.this.M);
        }

        public void writeSnapshot(Vector2D[] vector2DArray, int n, Vector2D vector2D) throws IOException {
            if (this.mySnaps >= AntiprotonFile.this.snaps) {
                throw new IllegalStateException("AntiprotonFile.Writer.writeSnapshot(): Too many snapshots");
            }
            if (n < 0 || n + AntiprotonFile.this.M > vector2DArray.length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = 0; i < AntiprotonFile.this.M; ++i) {
                this.myDos.writeDouble(vector2DArray[i + n].x);
                this.myDos.writeDouble(vector2DArray[i + n].y);
            }
            this.myDos.writeDouble(vector2D.x);
            this.myDos.writeDouble(vector2D.y);
            ++this.mySnaps;
        }

        public void close() throws IOException {
            this.myDos.close();
        }
    }
}

