## ----setup, echo = FALSE--------------------------------------------------------------------------
knitr::opts_chunk$set(error = TRUE, cache = FALSE, eval = TRUE)

## ----annotate,echo=FALSE--------------------------------------------------------------------------
options(width=100)

## ----biomaRt--------------------------------------------------------------------------------------
library("biomaRt")
listMarts()

## ----ensembl1-------------------------------------------------------------------------------------
ensembl <- useMart("ensembl")

## ----listDatasets---------------------------------------------------------------------------------
datasets <- listDatasets(ensembl)
head(datasets)

## ----ensembl2, eval=TRUE--------------------------------------------------------------------------
ensembl = useDataset("hsapiens_gene_ensembl",mart=ensembl)

## ----ensembl3-------------------------------------------------------------------------------------
ensembl = useMart("ensembl",dataset="hsapiens_gene_ensembl")

## ----filters--------------------------------------------------------------------------------------
filters = listFilters(ensembl)
filters[1:5,]

## ----attributes-----------------------------------------------------------------------------------
attributes = listAttributes(ensembl)
attributes[1:5,]

## ----getBM1, echo=TRUE, eval=TRUE-----------------------------------------------------------------
affyids=c("202763_at","209310_s_at","207500_at")
getBM(attributes=c('affy_hg_u133_plus_2', 'entrezgene_id'), 
      filters = 'affy_hg_u133_plus_2', 
      values = affyids, 
      mart = ensembl)

## ----searchDatasets, echo = TRUE, eval = TRUE-----------------------------------------------------
searchDatasets(mart = ensembl, pattern = "hsapiens")

## ----searchAttributes, echo = TRUE, eval = TRUE---------------------------------------------------
searchAttributes(mart = ensembl, pattern = "hgnc")

## ----searchFilters, echo = TRUE, eval = TRUE------------------------------------------------------
searchFilters(mart = ensembl, pattern = "ensembl.*id")

## ----filtervalues, fig.cap='The options available to the Chromosome/Scaffold field are limited to a pretermined list based on the values in this dataset.', echo = FALSE----
knitr::include_graphics('filtervalues.png')

## ----chromosomeNames, results = FALSE-------------------------------------------------------------
listFilterValues(mart = ensembl, filter = "chromosome_name")

## ----searchFilterValues, results = FALSE----------------------------------------------------------
searchFilterValues(mart = ensembl, filter = "chromosome_name", pattern = "^GL")
searchFilterValues(mart = ensembl, filter = "phenotype_description", pattern = "Crohn")

## ----cacheInfo------------------------------------------------------------------------------------
biomartCacheInfo()

## ----wormbase, echo=TRUE, eval=TRUE---------------------------------------------------------------
listMarts(host = "parasite.wormbase.org")
wormbase = useMart(biomart = "parasite_mart", 
                   host = "https://parasite.wormbase.org", 
                   port = 443)
listDatasets(wormbase)
wormbase <- useDataset(mart = wormbase, dataset = "wbps_gene")
head(listFilters(wormbase))
head(listAttributes(wormbase))
getBM(attributes = c("external_gene_id", "wbps_transcript_id", "transcript_biotype"), 
      filters="gene_name", 
      values=c("unc-26","his-33"), 
      mart=wormbase)
     

## ----attributePages-------------------------------------------------------------------------------
pages = attributePages(ensembl)
pages

## ----listAttributes-------------------------------------------------------------------------------
head(listAttributes(ensembl, page="feature_page"))

## ----localCopy, eval = FALSE----------------------------------------------------------------------
#  listMarts(host="www.myLocalHost.org", path="/myPathToWebservice/martservice")
#  mart=useMart("nameOfMyMart",dataset="nameOfMyDataset",host="www.myLocalHost.org", path="/myPathToWebservice/martservice")

## ----columnsAndKeyTypes---------------------------------------------------------------------------
mart <- useMart(dataset="hsapiens_gene_ensembl",biomart='ensembl')
head(keytypes(mart), n=3)
head(columns(mart), n=3)

## ----keys1----------------------------------------------------------------------------------------
k = keys(mart, keytype="chromosome_name")
head(k, n=3)

## ----keys2----------------------------------------------------------------------------------------
k = keys(mart, keytype="chromosome_name", pattern="LRG")
head(k, n=3)

## ----select---------------------------------------------------------------------------------------
affy=c("202763_at","209310_s_at","207500_at")
select(mart, keys=affy, columns=c('affy_hg_u133_plus_2','entrezgene_id'),
  keytype='affy_hg_u133_plus_2')

## ----putenv, eval = FALSE-------------------------------------------------------------------------
#  Sys.setenv("http_proxy" = "http://my.proxy.org:9999")

## ----rCurlOptions, eval = FALSE-------------------------------------------------------------------
#  options(RCurlOptions = list(proxy="uscache.kcc.com:80",proxyuserpwd="------:-------"))

## ----sessionInfo----------------------------------------------------------------------------------
sessionInfo()
warnings()

