## ----options, eval=TRUE, echo=FALSE-------------------------------------------
options(showHeadLines=3)
options(showTailLines=3)

## ----Load, message=FALSE------------------------------------------------------
library(VariantExperiment)

## ----makeVariantExperimentFromVCF, eval=FALSE---------------------------------
#  vcf <- SeqArray::seqExampleFileName("vcf")
#  ve <- makeVariantExperimentFromVCF(vcf)
#  ve

## ----retrieve GDS, eval=FALSE-------------------------------------------------
#  gdsfile(ve)

## ----makeVariantExperimentFromVCF2, eval=FALSE--------------------------------
#  assay(ve, 1)

## ----makeVariantExperimentFromVCF3, eval=FALSE--------------------------------
#  rowData(ve)

## ----sampleInfo, eval=FALSE---------------------------------------------------
#  sampleInfo <- system.file("extdata", "Example_sampleInfo.txt",
#                            package="VariantExperiment")
#  ve <- makeVariantExperimentFromVCF(vcf, sample.info = sampleInfo)
#  colData(ve)

## ----makeVariantExperimentFromVCFArgs, eval=FALSE-----------------------------
#  ve1 <- makeVariantExperimentFromVCF(vcf, info.import=c("OR", "GP"))
#  rowData(ve1)

## ----makeVariantExperimentFromVCFArgs_startCount, eval=FALSE------------------
#  ve2 <- makeVariantExperimentFromVCF(vcf, start=101, count=1000)
#  ve2

## ----makeVariantExperimentFromGDS, eval=FALSE---------------------------------
#  gds <- SeqArray::seqExampleFileName("gds")
#  ve <- makeVariantExperimentFromGDS(gds)
#  ve

## ----makeVariantExperimentFromGDS2, eval=FALSE--------------------------------
#  rowData(ve)
#  colData(ve)

## ----showAvailable, eval=FALSE------------------------------------------------
#  showAvailable(gds)

## ----makeVariantExperimentFromGDSArgs, eval=FALSE-----------------------------
#  ve3 <- makeVariantExperimentFromGDS(gds,
#                                      rowDataColumns = c("ID", "ALT", "REF"),
#                                      infoColumns = c("AC", "AN", "DP"),
#                                      rowDataOnDisk = TRUE,
#                                      colDataOnDisk = FALSE)
#  rowData(ve3)  ## DelayedDataFrame object
#  colData(ve3)  ## DataFrame object

## ----stats, eval=FALSE--------------------------------------------------------
#  ## sample missing rate
#  mr.samp <- seqMissing(ve, per.variant = FALSE)
#  head(mr.samp)
#  ## hwe
#  hwe <- hwe(ve)
#  head(hwe)
#  ## titv ratio by sample / overall
#  titv <- titv(ve, by.sample=TRUE)
#  head(titv)
#  titv(ve, by.sample=FALSE)
#  ## countSingletons
#  countSingletons(ve)

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

