## ----options, eval=TRUE, echo=FALSE-------------------------------------------
options(showHeadLines=3)
options(showTailLines=3)

## ----getPackage, eval=FALSE---------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("VariantExperiment")

## ---- eval = FALSE------------------------------------------------------------
#  BiocManager::install(“Bioconductor/VariantExperiment”)

## ----Load, message=FALSE------------------------------------------------------
library(VariantExperiment)

## ---- GDSArray----------------------------------------------------------------
file <- SeqArray::seqExampleFileName("gds")
#> GDSArray(file, "genotype")  #> deactivate temporarily 3/5/20
GDSArray(file, "sample.id")

## ----makeVariantExperimentFromGDS, eval=FALSE---------------------------------
#  ve <- makeVariantExperimentFromGDS(gds)
#  ve

## ----makeVariantExperimentFromGDS2, eval=FALSE--------------------------------
#  assays(ve)
#  assay(ve, 1)

## ----rrrd, eval=FALSE---------------------------------------------------------
#  rowRanges(ve)
#  rowData(ve)

## ----colData, eval=FALSE------------------------------------------------------
#  colData(ve)

## ----gdsfile, eval=FALSE------------------------------------------------------
#  gdsfile(ve)

## ----metaData, eval=FALSE-----------------------------------------------------
#  metadata(ve)

## ---- 2d, eval=FALSE----------------------------------------------------------
#  ve[1:10, 1:5]

## ----colDataExtraction, eval=FALSE--------------------------------------------
#  colData(ve)
#  ve[, as.logical(ve$family == "1328")]

## ----rowDataExtraction, eval=FALSE--------------------------------------------
#  rowData(ve)
#  ve[as.logical(rowData(ve)$REF == "T"),]

## ----overlap, eval=FALSE------------------------------------------------------
#  ve1 <- subsetByOverlaps(ve, GRanges("22:1-48958933"))
#  ve1

## ----saveLoad, eval=FALSE-----------------------------------------------------
#  hwe(ve1)
#  ## Error in .saveGDSMaybe(gdsfile) : use
#  ##   'saveVariantExperiment()' to synchronize on-disk and
#  ##   in-memory representations

## ----saveVE, eval=FALSE-------------------------------------------------------
#  a <- tempfile()
#  ve2 <- saveVariantExperiment(ve1, dir=a, replace=TRUE)

## ----loadVE, eval=FALSE-------------------------------------------------------
#  ve3 <- loadVariantExperiment(dir=a)
#  gdsfile(ve3)
#  all.equal(ve2, ve3)

## ----newVEstats, eval=FALSE---------------------------------------------------
#  head(hwe(ve2))

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

