/*
 * Decompiled with CFR 0.152.
 */
package main;

import base.ArraysMergerHeap;
import base.CountObject;
import base.DebugLog;
import base.MarkovModelInfo;
import base.MarkovModelOption;
import base.RegexOption;
import base.SELEXConfigReader;
import base.Sequence;
import base.Util;
import config.AdditionalDataSet;
import config.CrossValidationSetting;
import config.ExperimentReference;
import config.InformationGainStats;
import config.InputDataSetStats;
import config.KmerCountStats;
import config.MarkovModelStats;
import config.Model;
import config.Round0;
import config.SELEXStats;
import config.Sample;
import config.SequencingRunInfo;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import main.FastQFileScanner;
import main.SimpleKmerCount;

public class SELEX {
    private static long start;
    private static SELEXConfigReader reader;
    private static String TEMP_FOLDER;
    private static SELEXStats stats;

    private static void logStart() {
        start = System.currentTimeMillis();
    }

    private static void logEnd() {
        long l = System.currentTimeMillis();
        long l2 = (l - start) / 1000L;
        DebugLog.log("Time Elapsed: " + l2 + " seconds.");
    }

    public static SELEXConfigReader getConfigReader() {
        if (reader == null) {
            reader = new SELEXConfigReader();
        }
        return reader;
    }

    public static SELEXConfigReader loadProperties(String string, String string2) {
        DebugLog.log("Temp Folder:" + TEMP_FOLDER);
        try {
            SELEX.getConfigReader().readConfig(string, string2);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
        return reader;
    }

    public static void addSequenceInfo(String string, String string2, String string3, Integer n, Integer n2, String string4, String string5, String string6, String string7) {
        SELEX.addSequenceInfo(string, string2, string3, n, n2, string4, string5, string6, string7, null, null);
    }

    public static void addSequenceInfo(String string, String string2, String string3, Integer n, Integer n2, String string4, String string5, String string6, String string7, String string8, String string9) {
        if (reader == null) {
            reader = new SELEXConfigReader();
        }
        if (string6 == null) {
            string6 = string4;
        }
        if (string7 == null) {
            string7 = string5;
        }
        SequencingRunInfo sequencingRunInfo = new SequencingRunInfo();
        sequencingRunInfo.setName(string);
        sequencingRunInfo.setDataFile(string2);
        Sample sample = new Sample();
        sample.setName(string3);
        sample.setLeftBarcode(string4);
        sample.setRightBarcode(string5);
        sample.setLeftFlank(string6);
        sample.setRightFlank(string7);
        sample.setRound(n);
        sample.setVariableRegionLength(n2);
        if (!Util.isEmpty(string8) && !Util.isEmpty(string9)) {
            Round0 round0 = new Round0();
            round0.setSequencingName(string8);
            round0.setSampleName(string9);
            sample.setRound0(round0);
        }
        sequencingRunInfo.getSample().add(sample);
        reader.addSequencingConfig(sequencingRunInfo);
    }

    public static void saveStats() {
        if (stats != null) {
            try {
                String string = SELEX.getStatsXMLOutputPath();
                DebugLog.log("Saving stats to:" + string);
                SELEXConfigReader.writeConfig(string, stats);
            }
            catch (Exception exception) {
                DebugLog.log(exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            throw new RuntimeException("SELEX <a configuration file> <a working directory> [data folder]");
        }
        if (stringArray.length == 3) {
            SELEX.loadConfigFile(stringArray[0], stringArray[2]);
        } else {
            SELEX.loadConfigFile(stringArray[0], null);
        }
        SELEX.setWorkingDirectory(stringArray[1]);
        SELEX.runSELEX();
    }

    public static void setWorkingDirectory(String string) {
        if (!string.endsWith("/") && string.endsWith("\\")) {
            string = string + "/";
        }
        SELEX.createFolders(string);
        String string2 = string + "/log/";
        SELEX.createFolders(string2);
        DebugLog.setDefaultLogFolder(string2);
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new RuntimeException("Path [" + string + "] should be a folder instead of a file.");
        }
        TEMP_FOLDER = file.getAbsolutePath() + "/";
        DebugLog.log("TempFolder:" + TEMP_FOLDER);
        SELEX.loadStats();
    }

    private static void createFolders(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private static String getOutputPath(ExperimentReference experimentReference, String string, Integer n, Boolean bl) {
        String string2 = SELEX.getSampleID(experimentReference);
        if (n == null || n < 0) {
            n = -1;
        }
        if (bl.booleanValue()) {
            return TEMP_FOLDER + "/" + string2 + "." + string + ".o" + n + ".txt";
        }
        return TEMP_FOLDER + "/" + string2 + "." + string + ".o" + n + ".dat";
    }

    public static String getOutputPath(ExperimentReference experimentReference, String string, Boolean bl) {
        String string2 = SELEX.getSampleID(experimentReference);
        if (bl.booleanValue()) {
            return TEMP_FOLDER + "/" + string2 + "." + string + ".txt";
        }
        return TEMP_FOLDER + "/" + string2 + "." + string + ".dat";
    }

    public static String getOutputFolder(String string) {
        return TEMP_FOLDER + "/" + string + "/";
    }

    public static String getStatsOutputPath() {
        return TEMP_FOLDER + "/stats.txt";
    }

    public static String getStatsXMLOutputPath() {
        return TEMP_FOLDER + "/stats.xml";
    }

    public static Object[] splitDataSet(ExperimentReference experimentReference, Integer n, SimpleKmerCount simpleKmerCount, Double[] doubleArray, String string) {
        String string2 = SELEX.getSampleID(experimentReference);
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, -1, false, -1, null);
        InputDataSetStats inputDataSetStats = SELEX.getInputDataSetStats(experimentReference, null);
        Long l = inputDataSetStats.getValidReadCount();
        DebugLog.log("Total Reads of [" + string2 + "][" + n + "]: " + l);
        String string3 = SELEX.getOutputFolder(string2 + "_" + string);
        if (!new File(string3).exists()) {
            new File(string3).mkdirs();
        }
        Properties properties = new Properties();
        ArrayList<InputDataSetStats> arrayList = new ArrayList<InputDataSetStats>();
        Object[] objectArray = simpleKmerCount.splitCacheFile(reader, experimentReference, properties, string, l, doubleArray, string3, arrayList);
        SELEX.removeAdditionalDataSet(inputDataSetStats.getOriginalDataFilePath(), string);
        for (Map.Entry<Object, Object> object : properties.entrySet()) {
            AdditionalDataSet additionalDataSet = new AdditionalDataSet();
            additionalDataSet.setConfigurationPath((String)object.getValue());
            additionalDataSet.setExperimentReference(experimentReference);
            additionalDataSet.setOriginalDataFilePath(inputDataSetStats.getOriginalDataFilePath());
            additionalDataSet.setTag(string);
            SELEX.addAdditionalDataSet(additionalDataSet);
        }
        for (InputDataSetStats inputDataSetStats2 : arrayList) {
            SELEX.addInputDataSetStats(inputDataSetStats2);
        }
        SELEX.saveStats();
        reader.reloadAdditionalSequenceConfig(stats.getAdditionalDataSet());
        return objectArray;
    }

    public static InputDataSetStats getInputDataSetStats(ExperimentReference experimentReference, String string) {
        if (stats == null) {
            return null;
        }
        if (string == null) {
            string = new RegexOption().getVariableRegionRegexFormattedString();
        }
        String string2 = SELEX.getSampleID(experimentReference);
        for (InputDataSetStats inputDataSetStats : stats.getInputDataSetStats()) {
            if (!inputDataSetStats.getId().equals(string2) || !SELEX.isStringEqual(string, inputDataSetStats.getFilter())) continue;
            return inputDataSetStats;
        }
        return null;
    }

    private static void addInputDataSetStats(InputDataSetStats inputDataSetStats) {
        if (Util.isEmpty(inputDataSetStats.getFilter())) {
            inputDataSetStats.setFilter(new RegexOption().getVariableRegionRegexFormattedString());
        }
        List<InputDataSetStats> list = stats.getInputDataSetStats();
        for (int i = 0; i < list.size(); ++i) {
            InputDataSetStats inputDataSetStats2 = list.get(i);
            if (!inputDataSetStats2.getId().equals(inputDataSetStats.getId()) || !SELEX.isStringEqual(inputDataSetStats.getFilter(), inputDataSetStats2.getFilter())) continue;
            DebugLog.log("Replacing <InputDataSetStats>=" + inputDataSetStats.getId());
            list.set(i, inputDataSetStats);
            return;
        }
        DebugLog.log("Adding <InputDataSetStats>=" + inputDataSetStats.getId());
        stats.getInputDataSetStats().add(inputDataSetStats);
    }

    private static void addKmerCountStats(KmerCountStats kmerCountStats) {
        List<KmerCountStats> list = stats.getKmerCountStats();
        for (int i = 0; i < list.size(); ++i) {
            KmerCountStats kmerCountStats2 = list.get(i);
            if (!kmerCountStats2.getId().equals(kmerCountStats.getId()) || kmerCountStats2.getLength() != kmerCountStats.getLength() || kmerCountStats2.getOffset() != kmerCountStats.getOffset() || !SELEX.isStringEqual(kmerCountStats2.getFilter(), kmerCountStats.getFilter())) continue;
            DebugLog.log("Replacing <KmerCountStats>=" + kmerCountStats.getId() + " Length:" + kmerCountStats2.getLength() + " Offset:" + kmerCountStats2.getOffset());
            list.set(i, kmerCountStats);
            return;
        }
        stats.getKmerCountStats().add(kmerCountStats);
    }

    private static boolean isStringEqual(String string, String string2) {
        if (Util.isEmpty(string) && Util.isEmpty(string2)) {
            return true;
        }
        return string != null && string.equals(string2);
    }

    private static void addMarkovModelStats(MarkovModelStats markovModelStats) {
        List<MarkovModelStats> list = stats.getMarkovModelStats();
        for (int i = 0; i < list.size(); ++i) {
            MarkovModelStats markovModelStats2 = list.get(i);
            if (!markovModelStats2.getId().equals(markovModelStats.getId()) || markovModelStats2.getModelLength() != markovModelStats.getModelLength() || !SELEX.isStringEqual(markovModelStats.getFilter(), markovModelStats2.getFilter()) || !SELEX.isStringEqual(markovModelStats.getMarkovModelMethod(), markovModelStats2.getMarkovModelMethod())) continue;
            DebugLog.log("Replacing <MarkovModelStats>=" + markovModelStats.getId());
            list.set(i, markovModelStats);
            return;
        }
        stats.getMarkovModelStats().add(markovModelStats);
    }

    private static void removeAdditionalDataSet(String string, String string2) {
        List<AdditionalDataSet> list = stats.getAdditionalDataSet();
        int n = 0;
        while (n < list.size()) {
            AdditionalDataSet additionalDataSet = list.get(n);
            if (additionalDataSet.getOriginalDataFilePath() != null && additionalDataSet.getOriginalDataFilePath().equals(string) && additionalDataSet.getTag() != null && additionalDataSet.getTag().equals(string2)) {
                DebugLog.log("Removing <AdditionalDataSet>=" + string + " TAG:" + string2);
                list.remove(n);
                continue;
            }
            ++n;
        }
    }

    public static void addAdditionalDataSet(AdditionalDataSet additionalDataSet) {
        stats.getAdditionalDataSet().add(additionalDataSet);
    }

    public static void addInformationGainStats(InformationGainStats informationGainStats) {
        List<InformationGainStats> list = stats.getInformationGainStats();
        for (int i = 0; i < list.size(); ++i) {
            InformationGainStats informationGainStats2 = list.get(i);
            if (!informationGainStats2.getId().equals(informationGainStats.getId()) || informationGainStats2.getLength() != informationGainStats.getLength() || !SELEX.isStringEqual(informationGainStats2.getFilter(), informationGainStats.getFilter()) || !SELEX.isStringEqual(informationGainStats2.getMarkovModelMethod(), informationGainStats.getMarkovModelMethod())) continue;
            DebugLog.log("Replacing <InformationGainStats>=" + informationGainStats.getId());
            list.set(i, informationGainStats);
            return;
        }
        stats.getInformationGainStats().add(informationGainStats);
    }

    public static MarkovModelStats getMarkovStats(ExperimentReference experimentReference, Integer n, RegexOption regexOption, String string) {
        String string2 = Util.getKmerFilterString(regexOption);
        for (MarkovModelStats markovModelStats : stats.getMarkovModelStats()) {
            if (n.intValue() != markovModelStats.getModelLength() || !SELEX.compareExperimentReferences(markovModelStats.getExperimentReference(), experimentReference) || !SELEX.isStringEqual(markovModelStats.getFilter(), string2) || !SELEX.isStringEqual(markovModelStats.getMarkovModelMethod(), string)) continue;
            return markovModelStats;
        }
        return null;
    }

    public static KmerCountStats getKMerCountStats(ExperimentReference experimentReference, Integer n, Integer n2, RegexOption regexOption) {
        String string = Util.getKmerFilterString(regexOption);
        if (n2 == null || n2 < 0) {
            n2 = -1;
        }
        for (KmerCountStats kmerCountStats : stats.getKmerCountStats()) {
            if (n.intValue() != kmerCountStats.getLength() || n2.intValue() != kmerCountStats.getOffset() || !SELEX.compareExperimentReferences(kmerCountStats.getExperimentReference(), experimentReference) || !SELEX.isStringEqual(kmerCountStats.getFilter(), string)) continue;
            return kmerCountStats;
        }
        return null;
    }

    public static InformationGainStats getInformationGainStats(ExperimentReference experimentReference, Integer n, String string, String string2) {
        for (InformationGainStats informationGainStats : stats.getInformationGainStats()) {
            if (n.intValue() != informationGainStats.getLength() || !SELEX.compareExperimentReferences(informationGainStats.getExperimentReference(), experimentReference) || !SELEX.isStringEqual(informationGainStats.getFilter(), string) || !SELEX.isStringEqual(informationGainStats.getMarkovModelMethod(), string2)) continue;
            return informationGainStats;
        }
        return null;
    }

    public static boolean compareExperimentReferences(ExperimentReference experimentReference, ExperimentReference experimentReference2) {
        return experimentReference.getSequencingName().equals(experimentReference2.getSequencingName()) && experimentReference.getSampleName().equals(experimentReference2.getSampleName()) && experimentReference.getSampleRound() == experimentReference2.getSampleRound();
    }

    public static boolean compareBarcodes(Sample sample, Sample sample2) {
        return sample.getLeftBarcode().equals(sample2.getLeftBarcode()) && sample.getRightBarcode().equals(sample2.getRightBarcode());
    }

    public static int doMinimalCounting(ExperimentReference experimentReference, Integer n, MarkovModelOption markovModelOption, Boolean bl, Integer n2, RegexOption regexOption) {
        return SELEX.doMinimalCounting(experimentReference, n, null, markovModelOption, bl, null, false, n2, regexOption);
    }

    public static int doMinimalCounting(ExperimentReference experimentReference, Integer n, MarkovModelOption markovModelOption, Boolean bl, Integer n2, Boolean bl2, RegexOption regexOption) {
        return SELEX.doMinimalCounting(experimentReference, n, null, markovModelOption, bl, n2, bl2, 100, regexOption);
    }

    public static int doMinimalCounting(ExperimentReference experimentReference, Integer n, SimpleKmerCount simpleKmerCount, MarkovModelOption markovModelOption, Boolean bl, Integer n2, Boolean bl2, Integer n3, RegexOption regexOption) {
        Object object;
        if (markovModelOption == null) {
            markovModelOption = new MarkovModelOption();
        }
        String string = Util.getKmerFilterString(regexOption);
        String string2 = SELEX.getSampleID(experimentReference);
        String string3 = SELEX.getSequenceID(experimentReference);
        String string4 = SELEX.getOutputPath(experimentReference, n + "", bl);
        int n4 = n3;
        boolean bl3 = false;
        KmerCountStats kmerCountStats = SELEX.getKMerCountStats(experimentReference, n, n2, regexOption);
        MarkovModelStats markovModelStats = SELEX.getMarkovStats(experimentReference, n, regexOption, markovModelOption.getMethod());
        if (simpleKmerCount == null) {
            simpleKmerCount = new SimpleKmerCount();
        }
        simpleKmerCount.setTempFolder(TEMP_FOLDER);
        simpleKmerCount.initTraining(SELEX.getConfigReader(), experimentReference);
        simpleKmerCount.initKMerLength(n);
        simpleKmerCount.setRegexOption(regexOption);
        if (n2 != null && n2 >= 0) {
            simpleKmerCount.setLeftOffset(n2);
            simpleKmerCount.setUseSlidingWindow(false);
            string4 = SELEX.getOutputPath(experimentReference, n + "", n2, bl);
        }
        string4 = simpleKmerCount.setOutputPath(string4);
        simpleKmerCount.setSaveAsText(bl);
        boolean bl4 = simpleKmerCount.getIsBinaryFile();
        boolean bl5 = simpleKmerCount.getIsFASTQFile();
        if ((bl4 || !bl5 || new File(simpleKmerCount.getCacheFileName()).exists()) && kmerCountStats != null && new File(kmerCountStats.getKmerCountStatsTablePath()).exists() && !bl2.booleanValue()) {
            DebugLog.log("KMerCount for [" + string2 + "][" + n + "] has already been done. Skipping...");
            long l = kmerCountStats.getLowestCount();
            DebugLog.log("KMerCount.minCount for [" + string2 + "][" + n + "] = " + l);
            boolean bl6 = bl3 = l > (long)n4;
            if (!markovModelOption.getBuildMarkovModel().booleanValue() || markovModelStats != null && new File(markovModelStats.getTransitionTablePath()).exists()) {
                return bl3 ? 1 : 0;
            }
        }
        KmerCountStats kmerCountStats2 = SELEX.getKMerCountStats(experimentReference, n - 1, n2, regexOption);
        if (markovModelOption.getBuildMarkovModel().booleanValue() && n != 1) {
            if (kmerCountStats2 == null || !new File(kmerCountStats2.getKmerCountStatsTablePath()).exists()) {
                DebugLog.log("SubKmerCountTable[" + kmerCountStats2.getKmerCountStatsTablePath() + "] not found.");
                DebugLog.log("Calculating for SubKmerCountTable[" + kmerCountStats2.getKmerCountStatsTablePath() + "]");
                SELEX.doMinimalCounting(experimentReference, n - 1, simpleKmerCount, markovModelOption, false, -1, false, n3, null);
            }
            kmerCountStats2 = SELEX.getKMerCountStats(experimentReference, n - 1, n2, regexOption);
        }
        DebugLog.log("Scanning [" + string2 + "][ K = " + n + " ]");
        try {
            simpleKmerCount.process();
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
        Properties properties = simpleKmerCount.getStats();
        Long l = (Long)properties.get("lowestCount");
        Boolean bl7 = (Boolean)properties.get("fastqFileProcessed");
        DebugLog.log("runStats=" + properties);
        bl3 = l > (long)n4;
        KmerCountStats kmerCountStats3 = new KmerCountStats();
        kmerCountStats3.setId(string2);
        kmerCountStats3.setKmerCountStatsTablePath(string4);
        kmerCountStats3.setLength(n);
        kmerCountStats3.setLowestCount((Long)properties.get("lowestCount"));
        kmerCountStats3.setHighestCount((Long)properties.get("highestCount"));
        if (n2 != null && n2 >= 0) {
            kmerCountStats3.setOffset(n2);
        } else {
            kmerCountStats3.setOffset(-1);
        }
        kmerCountStats3.setValidReadCount((Long)properties.get("noOfValidRead"));
        kmerCountStats3.setExperimentReference(experimentReference);
        kmerCountStats3.setFilter(string);
        SELEX.addKmerCountStats(kmerCountStats3);
        SELEX.saveStats();
        DebugLog.log("fastqFileProcessed = " + bl7);
        if (bl7.booleanValue()) {
            object = (Long)properties.get("fastqTotalLineCount");
            Long l2 = (Long)properties.get("fastqTotalReadCount");
            Long l3 = (Long)properties.get("fastqBarcodeMatchedReadCount");
            Long l4 = (Long)properties.get("fastqValidReadCount");
            String string5 = (String)properties.get("fastqCacheFileName");
            InputDataSetStats inputDataSetStats = SELEX.getInputDataSetStats(experimentReference, Util.getVariableRegionFilterString(regexOption));
            if (inputDataSetStats == null) {
                inputDataSetStats = new InputDataSetStats();
                inputDataSetStats.setId(string2);
                inputDataSetStats.setOriginalDataFilePath(reader.getSequencingRunInfo(experimentReference).getDataFile());
                inputDataSetStats.setCachedDataFilePath(string5);
                inputDataSetStats.setExperimentReference(experimentReference);
                Sample sample = reader.getSample(experimentReference);
                inputDataSetStats.setLeftBarcode(sample.getLeftBarcode());
                inputDataSetStats.setRightBarcode(sample.getRightBarcode());
                inputDataSetStats.setTotalLineCount((Long)object);
                inputDataSetStats.setTotalReadCount(l2);
                inputDataSetStats.setTotalBarcodeMatchedReadCount(l3);
                inputDataSetStats.setValidReadCount(l4);
                inputDataSetStats.setFilter(Util.getVariableRegionFilterString(regexOption));
                DebugLog.log("Adding InputDataSetStats = " + inputDataSetStats.getId());
                SELEX.addInputDataSetStats(inputDataSetStats);
            } else {
                DebugLog.log("Found InputDataSetStats = " + inputDataSetStats.getId());
            }
        }
        if (markovModelOption.getBuildMarkovModel().booleanValue()) {
            if (markovModelOption.getMethod().contains("TRANSITION")) {
                simpleKmerCount.buildMarkovModelEfficient(markovModelOption);
            } else if (kmerCountStats2 == null && n == 1) {
                simpleKmerCount.buildMarkovModelDivisionMethod(null, 0L, markovModelOption);
            } else {
                simpleKmerCount.buildMarkovModelDivisionMethod(kmerCountStats2.getKmerCountStatsTablePath(), kmerCountStats2.getValidReadCount(), markovModelOption);
            }
            object = new MarkovModelStats();
            ((MarkovModelStats)object).setId(string2);
            ((MarkovModelStats)object).setExperimentReference(experimentReference);
            ((MarkovModelStats)object).setModelLength(n);
            ((MarkovModelStats)object).setModelOrder(n - 1);
            ((MarkovModelStats)object).setFilter(string);
            ((MarkovModelStats)object).setModelLogPath(markovModelOption.getModelLogFile());
            ((MarkovModelStats)object).setTransitionTablePath(markovModelOption.getModelOutputFile());
            ((MarkovModelStats)object).setMarkovModelMethod(markovModelOption.getMethod());
            SELEX.addMarkovModelStats((MarkovModelStats)object);
        }
        SELEX.saveStats();
        return bl3 ? 1 : 0;
    }

    public static MarkovModelInfo trainMarkovModel(ExperimentReference experimentReference, Integer n, RegexOption regexOption, String string) {
        return SELEX.trainMarkovModel(experimentReference, null, n, 0, regexOption, string);
    }

    public static MarkovModelInfo trainMarkovModel(ExperimentReference experimentReference, ExperimentReference experimentReference2, Integer n, Integer n2, RegexOption regexOption, String string) {
        try {
            KmerCountStats kmerCountStats;
            Object object;
            if (string == null) {
                string = "DIVISION";
            }
            String string2 = Util.getKmerFilterString(regexOption);
            String string3 = SELEX.getSampleID(experimentReference);
            KmerCountStats kmerCountStats2 = SELEX.getKMerCountStats(experimentReference, n, -1, regexOption);
            MarkovModelStats markovModelStats = SELEX.getMarkovStats(experimentReference, n, regexOption, string);
            if (kmerCountStats2 != null && new File(kmerCountStats2.getKmerCountStatsTablePath()).exists() && markovModelStats != null && new File(markovModelStats.getTransitionTablePath()).exists()) {
                boolean bl = false;
                if (experimentReference2 != null) {
                    object = markovModelStats.getCrossValidationSetting();
                    if (object == null || ((CrossValidationSetting)object).getExperimentReference() == null) {
                        bl = true;
                    } else {
                        DebugLog.log("kmax:" + n2 + " cv length:" + ((CrossValidationSetting)object).getLength());
                        if (!SELEX.compareExperimentReferences(((CrossValidationSetting)object).getExperimentReference(), experimentReference2) || ((CrossValidationSetting)object).getLength() != n2.intValue()) {
                            bl = true;
                        }
                    }
                }
                if (!bl) {
                    DebugLog.log("MarkovModel for [" + string3 + "][" + n + "] has already been done. CalculationNeeded[" + bl + "]. Skipping...");
                    object = SELEX.getMarkModelInfo(experimentReference, experimentReference2, n, regexOption, string);
                    return object;
                }
            }
            if (!(n == 1 || (kmerCountStats = SELEX.getKMerCountStats(experimentReference, n - 1, -1, regexOption)) != null && new File(kmerCountStats.getKmerCountStatsTablePath()).exists())) {
                DebugLog.log("Sub Kmer [" + (n - 1) + "] is not calculated. Calculating ...");
                SELEX.doMinimalCounting(experimentReference, n - 1, null, null, false, -1, false, -1, regexOption);
            }
            SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
            object = new MarkovModelOption();
            ((MarkovModelOption)object).setBuildMarkovModel(true);
            if (string != null) {
                ((MarkovModelOption)object).setMethod(string);
            }
            SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, (MarkovModelOption)object, false, -1, true, -1, regexOption);
            if (experimentReference2 == null) {
                MarkovModelInfo markovModelInfo = SELEX.getMarkModelInfo(experimentReference, experimentReference2, n, regexOption, string);
                return markovModelInfo;
            }
            SimpleKmerCount.includeReversed = false;
            SELEX.doMinimalCounting(experimentReference2, n2, null, null, false, -1, false, -1, null);
            KmerCountStats kmerCountStats3 = SELEX.getKMerCountStats(experimentReference2, n2, -1, null);
            long l = kmerCountStats3.getValidReadCount();
            DebugLog.log("KMax[" + n2 + "] Total Read:" + l);
            try {
                String string4 = kmerCountStats3.getKmerCountStatsTablePath();
                boolean bl = false;
                if (string.contains("WITH_LEFT_FLANK")) {
                    bl = true;
                }
                double d = simpleKmerCount.crossValidatePR(string4, l, bl);
                MarkovModelStats markovModelStats2 = SELEX.getMarkovStats(experimentReference, n, regexOption, string);
                CrossValidationSetting crossValidationSetting = new CrossValidationSetting();
                crossValidationSetting.setExperimentReference(experimentReference2);
                crossValidationSetting.setLength(n2);
                markovModelStats2.setCrossValidationSetting(crossValidationSetting);
                markovModelStats2.setPearsonCoefficient(d);
                markovModelStats2.setFilter(string2);
                MarkovModelInfo markovModelInfo = SELEX.getMarkModelInfo(experimentReference, experimentReference2, n, regexOption, string);
                SELEX.saveStats();
                return markovModelInfo;
            }
            catch (Exception exception) {
                DebugLog.log(exception);
                throw new RuntimeException(exception);
            }
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            SELEX.saveStats();
            return null;
        }
    }

    public static double calculateInformationGain(ExperimentReference experimentReference, Integer n, MarkovModelInfo markovModelInfo, RegexOption regexOption) {
        return SELEX.calculateInformationGain(experimentReference, n, markovModelInfo, regexOption, false);
    }

    public static double calculateInformationGain(ExperimentReference experimentReference, Integer n, MarkovModelInfo markovModelInfo, RegexOption regexOption, Boolean bl) {
        Object object;
        Object object2;
        String string = "InfoGainFilter:" + Util.getKmerFilterString(regexOption) + "\nMarkovModelFilter:" + markovModelInfo.getFilter();
        String string2 = SELEX.getSampleID(experimentReference);
        if (bl.booleanValue()) {
            object2 = reader.getSample(experimentReference);
            object = reader.getSample(markovModelInfo.getSample());
            if (!SELEX.compareBarcodes((Sample)object, (Sample)object2)) {
                throw new RuntimeException("Barcodes in the infomration gain sample don't match those of Markov model's.");
            }
        }
        object2 = SELEX.getKMerCountStats(experimentReference, n, -1, regexOption);
        object = SELEX.getInformationGainStats(experimentReference, n, string, markovModelInfo.getMarkovModelMethod());
        if (object != null && new File(((KmerCountStats)object2).getKmerCountStatsTablePath()).exists()) {
            DebugLog.log("InfomationGain for [" + string2 + "][" + n + "] has already been done. Skipping...");
            double d = ((InformationGainStats)object).getInformationGainValue();
            return d;
        }
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, -1, true, -1, regexOption);
        try {
            double d = simpleKmerCount.calculateInformationGain(markovModelInfo);
            InformationGainStats informationGainStats = new InformationGainStats();
            informationGainStats.setExperimentReference(experimentReference);
            informationGainStats.setId(string2);
            informationGainStats.setInformationGainValue(d);
            informationGainStats.setLength(n);
            informationGainStats.setFilter(string);
            informationGainStats.setModelID(SELEX.getSampleID(markovModelInfo.getSample()) + ".Order" + (markovModelInfo.getMarkovLength() - 1));
            informationGainStats.setMarkovModelMethod(markovModelInfo.getMarkovModelMethod());
            SELEX.addInformationGainStats(informationGainStats);
            SELEX.saveStats();
            return d;
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            return -1.0;
        }
    }

    public static String getSampleID(ExperimentReference experimentReference) {
        String string = experimentReference.getSequencingName() + "." + experimentReference.getSampleName() + "." + experimentReference.getSampleRound();
        return string;
    }

    public static String getSequenceID(ExperimentReference experimentReference) {
        String string = experimentReference.getSequencingName();
        return string;
    }

    public static MarkovModelInfo getMarkModelInfo(ExperimentReference experimentReference, ExperimentReference experimentReference2, Integer n, RegexOption regexOption, String string) {
        KmerCountStats kmerCountStats = SELEX.getKMerCountStats(experimentReference, n, -1, regexOption);
        MarkovModelStats markovModelStats = SELEX.getMarkovStats(experimentReference, n, regexOption, string);
        String string2 = kmerCountStats.getKmerCountStatsTablePath();
        String string3 = markovModelStats.getTransitionTablePath();
        long l = kmerCountStats.getValidReadCount();
        Double d = markovModelStats.getPearsonCoefficient();
        MarkovModelInfo markovModelInfo = new MarkovModelInfo();
        markovModelInfo.setFilter(markovModelStats.getFilter());
        markovModelInfo.setMarkovLength(n);
        markovModelInfo.setMarkovLengthTotalCount(l);
        markovModelInfo.setMarkovCountsPath(string2);
        markovModelInfo.setMarkovObjPath(string3);
        markovModelInfo.setMarkovR2(d);
        markovModelInfo.setSample(experimentReference);
        markovModelInfo.setCrossValidationSample(experimentReference2);
        markovModelInfo.setMarkovModelMethod(string);
        return markovModelInfo;
    }

    public static int kmax(ExperimentReference experimentReference) {
        int n = 0;
        int n2 = 100;
        MarkovModelOption markovModelOption = new MarkovModelOption();
        markovModelOption.setBuildMarkovModel(true);
        for (int i = 1; i < 16; ++i) {
            n = i - 1;
            int n3 = SELEX.doMinimalCounting(experimentReference, i, null, markovModelOption, false, -1, false, n2, null);
            if (n3 == 0) break;
            SELEX.saveStats();
        }
        InputDataSetStats inputDataSetStats = SELEX.getInputDataSetStats(experimentReference, null);
        inputDataSetStats.setKmax(n);
        return n;
    }

    public static void runSELEX() {
        String string = "DIVISION";
        Model model = null;
        try {
            model = reader.getProcessConfig().getProcess().getModel();
        }
        catch (Exception exception) {
            throw new RuntimeException("Please provide a SELEX process configuration file.", exception);
        }
        ExperimentReference experimentReference = model.getDataSource().getExperimentReference();
        ExperimentReference experimentReference2 = model.getCrossValidation().getExperimentReference();
        ExperimentReference experimentReference3 = model.getInformationGain().getExperimentReference();
        SELEX.logStart();
        try {
            int n;
            int n2;
            Object object;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 100;
            InputDataSetStats inputDataSetStats = SELEX.getInputDataSetStats(experimentReference2, null);
            if (inputDataSetStats != null && (object = inputDataSetStats.getKmax()) != null) {
                n3 = (Integer)object;
            }
            if (n3 == 0) {
                for (int i = 1; i < 16; ++i) {
                    n3 = i - 1;
                    n2 = SELEX.doMinimalCounting(experimentReference2, i, null, null, false, -1, false, n6, null);
                    if (n2 == 0) break;
                }
            }
            inputDataSetStats = SELEX.getInputDataSetStats(experimentReference2, null);
            inputDataSetStats.setKmax(n3);
            SELEX.saveStats();
            DebugLog.log("Kmax = " + n3);
            if (n4 == 0) {
                double d = 0.0;
                for (n = 1; n <= n3; ++n) {
                    double d2 = SELEX.trainMarkovModel(experimentReference, experimentReference2, n, n3, null, string).getMarkovR2();
                    if (d < d2) {
                        d = d2;
                        n4 = n;
                    }
                    SELEX.saveStats();
                }
            }
            DebugLog.log("markov.optimal.length = " + n4);
            n5 = n5 == 0 ? n4 : ++n5;
            DebugLog.log("information gain starting from k = " + n5);
            object = SELEX.getMarkModelInfo(experimentReference, experimentReference2, n4, null, string);
            for (n2 = n3; n2 <= 16; ++n2) {
                SELEX.calculateInformationGain(experimentReference3, n2, (MarkovModelInfo)object, null);
                SELEX.saveStats();
            }
            System.out.println("===========INFOGAIN========");
            Object[] objectArray = SELEX.getInformationGain();
            for (n = 0; n < Array.getLength(objectArray); ++n) {
                Object object2 = Array.get(objectArray, n);
                for (int i = 0; i < Array.getLength(object2); ++i) {
                    System.out.println(Array.get(object2, i));
                }
            }
            System.out.println("===========MARKOV========");
            Object[] objectArray2 = SELEX.getMarkovPR();
            for (int i = 0; i < Array.getLength(objectArray2); ++i) {
                Object object3 = Array.get(objectArray2, i);
                for (int j = 0; j < Array.getLength(object3); ++j) {
                    System.out.println(Array.get(object3, j));
                }
            }
        }
        catch (Exception exception) {
            DebugLog.log(exception);
        }
        SELEX.logEnd();
    }

    private static void loadStats() {
        String string = SELEX.getStatsXMLOutputPath();
        if (new File(string).exists()) {
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance("config");
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                stats = (SELEXStats)unmarshaller.unmarshal(new FileInputStream(string));
            }
            catch (Exception exception) {
                DebugLog.log(exception);
            }
            try {
                SELEX.getConfigReader().readAdditionalDS(stats.getAdditionalDataSet());
            }
            catch (Exception exception) {
                DebugLog.log(exception);
            }
        }
        if (stats == null) {
            stats = new SELEXStats();
        }
    }

    public static Object[] getInformationGain() {
        Pattern pattern = Pattern.compile("(.+)\\.(\\d+)\\.gain");
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        for (InformationGainStats informationGainStats : stats.getInformationGainStats()) {
            String string = SELEX.getSampleID(informationGainStats.getExperimentReference());
            arrayList.add(informationGainStats.getInformationGainValue());
            arrayList2.add(informationGainStats.getLength());
            arrayList3.add(string);
            arrayList4.add(informationGainStats.getModelID());
            arrayList5.add(informationGainStats.getFilter());
            arrayList6.add(informationGainStats.getMarkovModelMethod());
        }
        Object object = new double[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Double)arrayList.get(i);
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            nArray[i] = (Integer)arrayList2.get(i);
        }
        String[] stringArray = new String[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            stringArray[i] = (String)arrayList3.get(i);
        }
        String[] stringArray2 = new String[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            stringArray2[i] = (String)arrayList4.get(i);
        }
        String[] stringArray3 = new String[arrayList2.size()];
        arrayList5.toArray(stringArray3);
        String[] stringArray4 = new String[arrayList2.size()];
        arrayList6.toArray(stringArray4);
        return new Object[]{stringArray, nArray, object, stringArray2, stringArray3, stringArray4};
    }

    public static Object[] getMarkovPR() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        for (MarkovModelStats markovModelStats : stats.getMarkovModelStats()) {
            String string = SELEX.getSampleID(markovModelStats.getExperimentReference());
            if (markovModelStats.getPearsonCoefficient() == null) continue;
            arrayList.add(markovModelStats.getPearsonCoefficient());
            arrayList2.add(markovModelStats.getModelLength());
            arrayList3.add(string);
            CrossValidationSetting crossValidationSetting = markovModelStats.getCrossValidationSetting();
            if (crossValidationSetting != null) {
                arrayList4.add(SELEX.getSampleID(crossValidationSetting.getExperimentReference()));
                arrayList5.add(crossValidationSetting.getLength());
            } else {
                arrayList4.add("NA");
                arrayList5.add(0);
            }
            arrayList6.add(markovModelStats.getFilter());
            arrayList7.add(markovModelStats.getMarkovModelMethod());
        }
        Object object = new double[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Double)arrayList.get(i);
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            nArray[i] = (Integer)arrayList2.get(i);
        }
        String[] stringArray = new String[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            stringArray[i] = (String)arrayList3.get(i);
        }
        String[] stringArray2 = new String[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            stringArray2[i] = (String)arrayList4.get(i);
        }
        int[] nArray2 = new int[arrayList2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            nArray2[i] = (Integer)arrayList5.get(i);
        }
        String[] stringArray3 = new String[arrayList2.size()];
        arrayList6.toArray(stringArray3);
        String[] stringArray4 = new String[arrayList2.size()];
        arrayList7.toArray(stringArray4);
        return new Object[]{stringArray, nArray, object, stringArray2, nArray2, stringArray3, stringArray4};
    }

    public static Object[] getCountStats() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Long> arrayList4 = new ArrayList<Long>();
        ArrayList<Long> arrayList5 = new ArrayList<Long>();
        ArrayList<Long> arrayList6 = new ArrayList<Long>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        for (KmerCountStats object2 : stats.getKmerCountStats()) {
            arrayList.add(SELEX.getSampleID(object2.getExperimentReference()));
            arrayList2.add(object2.getLength());
            arrayList3.add(object2.getOffset());
            arrayList4.add(object2.getLowestCount());
            arrayList5.add(object2.getHighestCount());
            arrayList6.add(object2.getValidReadCount());
            arrayList7.add(object2.getFilter());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        int[] nArray = new int[arrayList.size()];
        for (int nArray2 = 0; nArray2 < arrayList.size(); ++nArray2) {
            nArray[nArray2] = (Integer)arrayList2.get(nArray2);
        }
        int[] nArray3 = new int[arrayList.size()];
        for (int lArray = 0; lArray < arrayList.size(); ++lArray) {
            nArray3[lArray] = (Integer)arrayList3.get(lArray);
        }
        long[] lArray = new long[arrayList.size()];
        for (int lArray2 = 0; lArray2 < arrayList.size(); ++lArray2) {
            lArray[lArray2] = (Long)arrayList4.get(lArray2);
        }
        long[] lArray2 = new long[arrayList.size()];
        for (int lArray3 = 0; lArray3 < arrayList.size(); ++lArray3) {
            lArray2[lArray3] = (Long)arrayList5.get(lArray3);
        }
        long[] lArray3 = new long[arrayList.size()];
        for (int stringArray2 = 0; stringArray2 < arrayList.size(); ++stringArray2) {
            lArray3[stringArray2] = (Long)arrayList6.get(stringArray2);
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList7.toArray(stringArray2);
        return new Object[]{stringArray, nArray, nArray3, lArray, lArray2, lArray3, stringArray2};
    }

    public static Object[] splitDataSet(ExperimentReference experimentReference, String string, ArrayList<Double> arrayList) {
        Double[] doubleArray = null;
        if (arrayList == null || arrayList.size() == 0) {
            doubleArray = new Double[]{0.5, 0.5};
        } else {
            doubleArray = new Double[arrayList.size()];
            arrayList.toArray(doubleArray);
        }
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        simpleKmerCount.initTraining(SELEX.getConfigReader(), experimentReference);
        simpleKmerCount.setTempFolder(TEMP_FOLDER);
        Sample sample = reader.getSample(experimentReference);
        Integer n = sample.getVariableRegionLength();
        Object[] objectArray = SELEX.splitDataSet(experimentReference, n, simpleKmerCount, doubleArray, string);
        return objectArray;
    }

    public static void loadConfigFile(String string) {
        if (!new File(string).exists()) {
            throw new RuntimeException("File not found:" + string);
        }
        SELEX.loadProperties(string, null);
    }

    public static void loadConfigFile(String string, String string2) {
        if (!new File(string).exists()) {
            throw new RuntimeException("File not found:" + string);
        }
        SELEX.loadProperties(string, string2);
    }

    public static void exportConfigFile(String string) {
        SELEX.getConfigReader().exportSamples(string);
    }

    public static ExperimentReference getRound0(ExperimentReference experimentReference) {
        return SELEX.getConfigReader().getRound0(experimentReference);
    }

    public static Object[] showSamples() {
        if (reader != null) {
            return reader.showSamples();
        }
        return new Object[0];
    }

    public static void unloadSamples() {
        if (reader != null) {
            reader.clear();
        }
    }

    public static Object[] getPSFM(ExperimentReference experimentReference, Integer n, Integer n2) {
        int n3;
        Object object;
        SELEX.doMinimalCounting(experimentReference, n, null, null, false, n2, false, -1, null);
        KmerCountStats kmerCountStats = SELEX.getKMerCountStats(experimentReference, n, n2, null);
        String string = kmerCountStats.getKmerCountStatsTablePath();
        ArraysMergerHeap.MinHeapNode minHeapNode = new ArraysMergerHeap.MinHeapNode(string);
        CountObject countObject = null;
        long[][] lArray = new long[4][n.intValue()];
        while ((countObject = minHeapNode.peek()) != null) {
            object = countObject.getKey();
            String string2 = ((Sequence)object).getString();
            int n4 = 0;
            while (n4 < n) {
                char c = string2.charAt(n4);
                n3 = (int)Sequence.getCharCode(c);
                long[] lArray2 = lArray[n3];
                int n5 = n4++;
                lArray2[n5] = lArray2[n5] + (long)countObject.getCount().intValue();
            }
            minHeapNode.pop();
        }
        object = new double[4][n.intValue()];
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (n3 = 0; n3 < 4; ++n3) {
                l += lArray[n3][i];
            }
            for (n3 = 0; n3 < 4; ++n3) {
                object[n3][i] = (double)lArray[n3][i] * 1.0 / (double)l;
            }
        }
        Object[] objectArray = new Object[4];
        for (int i = 0; i < 4; ++i) {
            objectArray[i] = object[i];
        }
        return objectArray;
    }

    public static Object[] getSamplePSFM(ExperimentReference experimentReference) {
        Object[] objectArray;
        SequencingRunInfo sequencingRunInfo = reader.getSequencingRunInfo(experimentReference);
        String string = sequencingRunInfo.getDataFile();
        Sample sample = reader.getSample(experimentReference);
        Properties properties = new Properties();
        FastQFileScanner fastQFileScanner = new FastQFileScanner();
        try {
            objectArray = fastQFileScanner.calculatePSFM(string, sample.getVariableRegionLength(), sample.getLeftBarcode(), sample.getRightBarcode(), properties);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
        return objectArray;
    }

    public static Object[] getFastqPSFM(String string) {
        Object[] objectArray;
        String string2 = reader.getSequencingRunInfoDataFile(string);
        DebugLog.log("Fastq file:" + string2);
        if (string2 == null) {
            throw new RuntimeException("Fastq file with seqName[" + string + "] not found.");
        }
        Properties properties = new Properties();
        FastQFileScanner fastQFileScanner = new FastQFileScanner();
        try {
            objectArray = fastQFileScanner.calculatePSFM(string2, properties);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
        return objectArray;
    }

    public static Object[] getFastqPSFM(ExperimentReference experimentReference) {
        Object[] objectArray;
        SequencingRunInfo sequencingRunInfo = reader.getSequencingRunInfo(experimentReference);
        String string = sequencingRunInfo.getDataFile();
        DebugLog.log("Fastq file:" + string);
        Properties properties = new Properties();
        FastQFileScanner fastQFileScanner = new FastQFileScanner();
        try {
            objectArray = fastQFileScanner.calculatePSFM(string, properties);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
        return objectArray;
    }

    public static Object[] getKmerCount(ExperimentReference experimentReference, Integer n, Integer n2, Integer n3, Integer n4, MarkovModelInfo markovModelInfo, RegexOption regexOption) {
        return SELEX.getKmerCount(experimentReference, n, n2, n3, n4, markovModelInfo, regexOption, "");
    }

    public static Object[] getKmerCount(ExperimentReference experimentReference, Integer n, Integer n2, Integer n3, Integer n4, MarkovModelInfo markovModelInfo, RegexOption regexOption, String string) {
        try {
            Object[] objectArray;
            Object object;
            Object object2;
            CountObject countObject;
            Object object3;
            Closeable closeable;
            Object object4;
            Object object5;
            KmerCountStats kmerCountStats = SELEX.getKMerCountStats(experimentReference, n, n2, regexOption);
            Sample sample = reader.getSample(experimentReference);
            String string2 = sample.getLeftFlank();
            String string3 = kmerCountStats.getKmerCountStatsTablePath();
            ArraysMergerHeap.MinHeapNode minHeapNode = new ArraysMergerHeap.MinHeapNode(string3);
            Pattern pattern = null;
            Pattern pattern2 = null;
            Pattern pattern3 = null;
            if (regexOption != null) {
                pattern = regexOption.getViewIncludePattern();
                pattern2 = regexOption.getViewExcludePattern();
                pattern3 = regexOption.getViewIncludeOnlyPattern();
            }
            DebugLog.log("minCount is set to " + n3);
            boolean bl = true;
            if (n4 == null || n4 <= 0) {
                bl = false;
            }
            DebugLog.log("useTop is set to " + bl);
            class LocalCountObjectComparator
            implements Comparator<ArrayList> {
                LocalCountObjectComparator() {
                }

                @Override
                public int compare(ArrayList arrayList, ArrayList arrayList2) {
                    CountObject countObject = (CountObject)arrayList.get(0);
                    CountObject countObject2 = (CountObject)arrayList2.get(0);
                    return countObject2.compareTo(countObject);
                }
            }
            PriorityQueue<ArrayList> priorityQueue = new PriorityQueue<ArrayList>(100, new LocalCountObjectComparator());
            float[] fArray = null;
            String string4 = null;
            String string5 = null;
            int n5 = 0;
            int[] nArray = null;
            long l = 0L;
            long l2 = 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            if (markovModelInfo != null && markovModelInfo.getMarkovObjPath() != null) {
                bl3 = markovModelInfo.getMarkovModelMethod().toUpperCase().contains("WITH_LEFT_FLANK");
                bl2 = true;
                object5 = SELEX.getKMerCountStats(experimentReference, n, -1, regexOption);
                l2 = ((KmerCountStats)object5).getValidReadCount();
                try {
                    string4 = markovModelInfo.getMarkovObjPath();
                    string5 = markovModelInfo.getMarkovCountsPath();
                    n5 = markovModelInfo.getMarkovLength();
                    l = markovModelInfo.getMarkovLengthTotalCount();
                    DebugLog.log("Reading Markov Prob file:" + string4);
                    object4 = new FileInputStream(string4);
                    closeable = new ObjectInputStream((InputStream)object4);
                    fArray = (float[])((ObjectInputStream)closeable).readObject();
                    DebugLog.log("Reading Markov Count file:" + string5);
                    object3 = new ArraysMergerHeap.MinHeapNode(string5);
                    countObject = null;
                    nArray = new int[1 << 2 * n5];
                    while ((countObject = ((ArraysMergerHeap.MinHeapNode)object3).peek()) != null) {
                        Sequence sequence = countObject.getKey();
                        nArray[(int)sequence.getValue()] = countObject.getCount();
                        ((ArraysMergerHeap.MinHeapNode)object3).pop();
                    }
                }
                catch (Exception exception) {
                    DebugLog.log(exception);
                    throw new RuntimeException(exception);
                }
            }
            object5 = new String[]{"Kmer", "ObservedCount"};
            object4 = new String[]{"Kmer", "ObservedCount", "Probability", "ExpectedCount"};
            closeable = null;
            if (!Util.isEmpty(string)) {
                closeable = new PrintWriter(new BufferedOutputStream(new FileOutputStream(string), 0xA00000));
                DebugLog.log("Output counts to file: " + string);
            }
            if (((Boolean)(object3 = Boolean.valueOf(closeable != null && !bl))).booleanValue()) {
                if (!bl2) {
                    Util.output1DArray((PrintWriter)closeable, (Object[])object5);
                } else {
                    Util.output1DArray((PrintWriter)closeable, object4);
                }
            }
            countObject = null;
            int n6 = 0;
            int n7 = 10000000;
            int n8 = 10000000;
            while ((countObject = minHeapNode.peek()) != null) {
                if (++n6 == n8) {
                    DebugLog.log("Lines processed:" + n6);
                    n8 += n7;
                }
                if (countObject.getCount() >= n3) {
                    if (pattern != null && !((Matcher)(object2 = pattern.matcher(countObject.getKey().getString()))).find()) {
                        minHeapNode.pop();
                        continue;
                    }
                    if (pattern2 != null && ((Matcher)(object2 = pattern2.matcher(countObject.getKey().getString()))).find()) {
                        minHeapNode.pop();
                        continue;
                    }
                    if (pattern3 != null && !((Matcher)(object2 = pattern3.matcher(countObject.getKey().getString()))).find()) {
                        minHeapNode.pop();
                        continue;
                    }
                    object2 = new ArrayList();
                    ((ArrayList)object2).add(countObject);
                    ((ArrayList)object2).add(countObject.getKey());
                    ((ArrayList)object2).add(countObject.getCount());
                    if (bl2) {
                        object = countObject.getKey();
                        double d = 1.0;
                        d = bl3 ? SimpleKmerCount.getPredictedCountWithLeftFlank(string2, n5, (Sequence)object, fArray) : SimpleKmerCount.getPredictedCount(n5, l, (Sequence)object, nArray, fArray);
                        double d2 = d * (double)l2;
                        ((ArrayList)object2).add(d);
                        ((ArrayList)object2).add(d2);
                    }
                    if (((Boolean)object3).booleanValue()) {
                        ((ArrayList)object2).set(1, ((Sequence)((ArrayList)object2).get(1)).getString());
                        Util.output1DArray((PrintWriter)closeable, (Collection)object2, 1);
                    } else {
                        priorityQueue.add((ArrayList)object2);
                    }
                    if (bl && priorityQueue.size() > n4) {
                        priorityQueue.poll();
                    }
                }
                minHeapNode.pop();
            }
            DebugLog.log("Lines processed:" + n6);
            object2 = new String[priorityQueue.size()];
            object = new int[priorityQueue.size()];
            double[] dArray = new double[priorityQueue.size()];
            double[] dArray2 = new double[priorityQueue.size()];
            int n9 = 0;
            while (!priorityQueue.isEmpty()) {
                objectArray = priorityQueue.poll();
                object2[n9] = ((Sequence)objectArray.get(1)).getString();
                object[n9] = (Integer)objectArray.get(2);
                if (bl2) {
                    dArray2[n9] = (Double)objectArray.get(3);
                    dArray[n9] = (Double)objectArray.get(4);
                }
                ++n9;
            }
            if (((Boolean)object3).booleanValue()) {
                ((PrintWriter)closeable).close();
            }
            objectArray = null;
            if (!bl2) {
                objectArray = new Object[]{object2, object};
                if (closeable != null && bl) {
                    Util.outputColumnBasedArrays((PrintWriter)closeable, objectArray, (String[])object5);
                    ((PrintWriter)closeable).close();
                    return null;
                }
                return objectArray;
            }
            objectArray = new Object[]{object2, object, dArray2, dArray};
            if (closeable != null && bl) {
                Util.outputColumnBasedArrays((PrintWriter)closeable, objectArray, (String[])object4);
                ((PrintWriter)closeable).close();
                return null;
            }
            return objectArray;
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            return null;
        }
    }

    public static double getProbability(String string, MarkovModelInfo markovModelInfo) {
        Object object;
        float[] fArray = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        int[] nArray = null;
        long l = 0L;
        try {
            string2 = markovModelInfo.getMarkovObjPath();
            string3 = markovModelInfo.getMarkovCountsPath();
            n = markovModelInfo.getMarkovLength();
            l = markovModelInfo.getMarkovLengthTotalCount();
            DebugLog.log("Reading Markov Prob file:" + string2);
            FileInputStream fileInputStream = new FileInputStream(string2);
            object = new ObjectInputStream(fileInputStream);
            fArray = (float[])((ObjectInputStream)object).readObject();
            DebugLog.log("Reading Markov Count file:" + string3);
            ArraysMergerHeap.MinHeapNode minHeapNode = new ArraysMergerHeap.MinHeapNode(string3);
            CountObject countObject = null;
            nArray = new int[1 << 2 * n];
            while ((countObject = minHeapNode.peek()) != null) {
                Sequence sequence = countObject.getKey();
                nArray[(int)sequence.getValue()] = countObject.getCount();
                minHeapNode.pop();
            }
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
        int n2 = string.length();
        object = new Sequence(string, 0, n2);
        double d = SimpleKmerCount.getPredictedCount(n, l, (Sequence)object, nArray, fArray);
        return d;
    }

    public static ExperimentReference getExperimentReference(String string, String string2, Integer n) {
        ExperimentReference experimentReference = new ExperimentReference();
        experimentReference.setSequencingName(string);
        experimentReference.setSampleName(string2);
        experimentReference.setSampleRound(n);
        Sample sample = reader.getSample(experimentReference);
        if (sample == null) {
            throw new RuntimeException("Sample [" + SELEX.getSampleID(experimentReference) + "] not found.");
        }
        return experimentReference;
    }

    public static Object[] getExperimentReferenceInfo(ExperimentReference experimentReference) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        SequencingRunInfo sequencingRunInfo = reader.getSequencingRunInfo(experimentReference);
        Sample sample = reader.getSample(experimentReference);
        if (sample == null) {
            throw new RuntimeException("Sample [" + SELEX.getSampleID(experimentReference) + "] not found.");
        }
        arrayList.add("FilePath");
        arrayList2.add(sequencingRunInfo.getDataFile());
        arrayList.add("LeftBarcode");
        arrayList2.add(sample.getLeftBarcode());
        arrayList.add("RightBarcode");
        arrayList2.add(sample.getRightBarcode());
        arrayList.add("VariableRegionLength");
        arrayList2.add(sample.getVariableRegionLength() + "");
        String[] stringArray = new String[arrayList.size()];
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        arrayList2.toArray(stringArray2);
        return new Object[]{stringArray, stringArray2};
    }

    public static void removeTempFiles(String string) {
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            if (file2.getName().endsWith(".txt")) continue;
            DebugLog.log("Removing temp file:" + file2.getAbsolutePath());
            file2.delete();
        }
    }

    static {
        TEMP_FOLDER = "./SELEXworkspace/";
        stats = null;
    }
}

