### R code from vignette source 'SDAMS.Rnw'

###################################################
### code chunk number 1: quick start (eval = FALSE)
###################################################
## library("SDAMS")
## data("exampleSumExp")
## results <- SDA(exampleSumExp)


###################################################
### code chunk number 2: directory (eval = FALSE)
###################################################
## path1 <- "/path/to/your/feature.csv/"
## path2 <- "/path/to/your/group.csv/"


###################################################
### code chunk number 3: GetDirectory
###################################################
directory1 <- system.file("extdata", package = "SDAMS", mustWork = TRUE)
path1 <- file.path(directory1, "ProstateFeature.csv")
directory2 <- system.file("extdata", package = "SDAMS", mustWork = TRUE)
path2 <- file.path(directory2, "ProstateGroup.csv")


###################################################
### code chunk number 4: CsvInput
###################################################
library("SDAMS")
exampleSE1 <- createSEFromCSV(path1, path2)
exampleSE1


###################################################
### code chunk number 5: Accessors
###################################################
head(assay(exampleSE1)[,1:10])
head(colData(exampleSE1)$grouping)


###################################################
### code chunk number 6: MatrixInput
###################################################
set.seed(100)
featureInfo <- matrix(runif(800, -2, 5), ncol = 40)
featureInfo[featureInfo<0] <- 0
rownames(featureInfo) <- paste("feature", 1:20, sep = '')
colnames(featureInfo) <- paste('subject', 1:40, sep = '')
groupInfo <- data.frame(grouping=matrix(sample(0:1, 40, replace = TRUE),
                        ncol = 1))
rownames(groupInfo) <- colnames(featureInfo)

exampleSE2 <- createSEFromMatrix(feature = featureInfo, colData = groupInfo)
exampleSE2
head(assay(exampleSE2)[,1:10])
head(colData(exampleSE2)$grouping)



###################################################
### code chunk number 7: resultsForGamma
###################################################
results <- SDA(exampleSE1)
head(results$gamma)
head(results$pv_gamma)
head(results$qv_gamma)


###################################################
### code chunk number 8: resultsForBeta
###################################################
head(results$beta)
head(results$pv_beta)
head(results$qv_beta)


###################################################
### code chunk number 9: resultsFor2part
###################################################
head(results$pv_2part)
head(results$qv_2part)


###################################################
### code chunk number 10: outputForFeatureName
###################################################
head(results$feat.names)


###################################################
### code chunk number 11: sessionInfo
###################################################
toLatex(sessionInfo())


