/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.tags.matchers;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.MutationMatrix;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.SequenceSegment;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.identification.tags.tagcomponents.MassGap;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TagMatcher {
    private double fixedNTermPeptideModificationsMass = 0.0;
    private double fixedCTermPeptideModificationsMass = 0.0;
    private double fixedNTermProteinModificationsMass = 0.0;
    private double fixedCTermProteinModificationsMass = 0.0;
    private HashMap<Character, Double> fixedAaModificationsMasses = new HashMap(1);
    private HashMap<Character, Double> fixedAaModificationsPeptideNtermMasses = new HashMap(1);
    private HashMap<Character, Double> fixedAaModificationsProteinNtermMasses = new HashMap(1);
    private HashMap<Character, Double> fixedAaModificationsPeptideCtermMasses = new HashMap(1);
    private HashMap<Character, Double> fixedAaModificationsProteinCtermMasses = new HashMap(1);
    private HashMap<String, Double> variableNTermPeptideModifications = null;
    private HashMap<String, Double> variableCTermPeptideModifications = null;
    private HashMap<String, Double> variableNTermProteinModifications = null;
    private HashMap<String, Double> variableCTermProteinModifications = null;
    private HashMap<Character, HashMap<String, Double>> variableAaModifications = new HashMap(1);
    private HashMap<Character, HashMap<String, Double>> variableAaModificationsAtPeptideNterm = new HashMap(1);
    private HashMap<Character, HashMap<String, Double>> variableAaModificationsAtProteinNterm = new HashMap(1);
    private HashMap<Character, HashMap<String, Double>> variableAaModificationsAtPeptideCterm = new HashMap(1);
    private HashMap<Character, HashMap<String, Double>> variableAaModificationsAtProteinCterm = new HashMap(1);
    private double minNtermMod = 0.0;
    private double minCtermMod = 0.0;
    private double maxNtermMod = 0.0;
    private double maxCtermMod = 0.0;
    private boolean useCache = true;
    private boolean synchronizedIndexing = false;
    private HashMap<String, HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>>> nTermCache = new HashMap();
    private HashMap<String, HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>>> cTermCache = new HashMap();
    private SequenceMatchingPreferences sequenceMatchingPreferences;
    private BufferedWriter debugbw = null;

    public TagMatcher(ArrayList<String> fixedModifications, ArrayList<String> variableModifications, SequenceMatchingPreferences sequenceMatchingPreferences) {
        this.sequenceMatchingPreferences = sequenceMatchingPreferences;
        this.importModificationMapping(fixedModifications, variableModifications);
    }

    private void importModificationMapping(ArrayList<String> fixedModifications, ArrayList<String> variableModifications) {
        PTM ptm;
        for (String modificationName : fixedModifications) {
            Double fixedMass;
            AminoAcidPattern ptmPattern;
            ptm = PTMFactory.getInstance().getPTM(modificationName);
            if (ptm.getType() == 1) {
                this.fixedNTermProteinModificationsMass += ptm.getMass();
                continue;
            }
            if (ptm.getType() == 3) {
                this.fixedCTermProteinModificationsMass += ptm.getMass();
                continue;
            }
            if (ptm.getType() == 5) {
                this.fixedNTermPeptideModificationsMass += ptm.getMass();
                continue;
            }
            if (ptm.getType() == 7) {
                this.fixedCTermPeptideModificationsMass += ptm.getMass();
                continue;
            }
            if (ptm.getType() == 0) {
                ptmPattern = ptm.getPattern();
                if (ptmPattern.length() > 1) {
                    throw new UnsupportedOperationException("Fixed modifications on patterns is not supported, try variable.");
                }
                for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                    fixedMass = this.fixedAaModificationsMasses.get(aa);
                    if (fixedMass == null) {
                        fixedMass = 0.0;
                    }
                    this.fixedAaModificationsMasses.put(aa, fixedMass + ptm.getMass());
                }
                continue;
            }
            if (ptm.getType() == 2) {
                ptmPattern = ptm.getPattern();
                if (ptmPattern.length() > 1) {
                    throw new UnsupportedOperationException("Fixed modifications on patterns is not supported, try variable.");
                }
                for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                    fixedMass = this.fixedAaModificationsProteinNtermMasses.get(aa);
                    if (fixedMass == null) {
                        fixedMass = 0.0;
                    }
                    this.fixedAaModificationsProteinNtermMasses.put(aa, fixedMass + ptm.getMass());
                }
                continue;
            }
            if (ptm.getType() == 6) {
                ptmPattern = ptm.getPattern();
                if (ptmPattern.length() > 1) {
                    throw new UnsupportedOperationException("Fixed modifications on patterns is not supported, try variable.");
                }
                for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                    fixedMass = this.fixedAaModificationsPeptideNtermMasses.get(aa);
                    if (fixedMass == null) {
                        fixedMass = 0.0;
                    }
                    this.fixedAaModificationsPeptideNtermMasses.put(aa, fixedMass + ptm.getMass());
                }
                continue;
            }
            if (ptm.getType() == 4) {
                ptmPattern = ptm.getPattern();
                if (ptmPattern.length() > 1) {
                    throw new UnsupportedOperationException("Fixed modifications on patterns is not supported, try variable.");
                }
                for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                    fixedMass = this.fixedAaModificationsProteinCtermMasses.get(aa);
                    if (fixedMass == null) {
                        fixedMass = 0.0;
                    }
                    this.fixedAaModificationsProteinCtermMasses.put(aa, fixedMass + ptm.getMass());
                }
                continue;
            }
            if (ptm.getType() != 8) continue;
            ptmPattern = ptm.getPattern();
            if (ptmPattern.length() > 1) {
                throw new UnsupportedOperationException("Fixed modifications on patterns is not supported, try variable.");
            }
            for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                fixedMass = this.fixedAaModificationsPeptideCtermMasses.get(aa);
                if (fixedMass == null) {
                    fixedMass = 0.0;
                }
                this.fixedAaModificationsPeptideCtermMasses.put(aa, fixedMass + ptm.getMass());
            }
        }
        for (String modificationName : variableModifications) {
            HashMap<String, Double> ptmMap;
            ptm = PTMFactory.getInstance().getPTM(modificationName);
            if (ptm.getType() == 5) {
                if (this.variableNTermPeptideModifications == null) {
                    this.variableNTermPeptideModifications = new HashMap(1);
                }
                this.variableNTermPeptideModifications.put(modificationName, ptm.getMass());
                if (ptm.getMass() < this.minNtermMod) {
                    this.minNtermMod = ptm.getMass();
                }
                if (!(ptm.getMass() > this.maxNtermMod)) continue;
                this.maxNtermMod = ptm.getMass();
                continue;
            }
            if (ptm.getType() == 7) {
                if (this.variableCTermPeptideModifications == null) {
                    this.variableCTermPeptideModifications = new HashMap(1);
                }
                this.variableCTermPeptideModifications.put(modificationName, ptm.getMass());
                if (ptm.getMass() < this.minCtermMod) {
                    this.minCtermMod = ptm.getMass();
                }
                if (!(ptm.getMass() > this.maxCtermMod)) continue;
                this.maxCtermMod = ptm.getMass();
                continue;
            }
            if (ptm.getType() == 1) {
                if (this.variableNTermProteinModifications == null) {
                    this.variableNTermProteinModifications = new HashMap(1);
                }
                this.variableNTermProteinModifications.put(modificationName, ptm.getMass());
                continue;
            }
            if (ptm.getType() == 3) {
                if (this.variableCTermProteinModifications == null) {
                    this.variableCTermProteinModifications = new HashMap(1);
                }
                this.variableCTermProteinModifications.put(modificationName, ptm.getMass());
                continue;
            }
            if (ptm.getType() == 0) {
                for (Character aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                    ptmMap = this.variableAaModifications.get(aa);
                    if (ptmMap == null) {
                        ptmMap = new HashMap(1);
                        this.variableAaModifications.put(aa, ptmMap);
                    }
                    ptmMap.put(modificationName, ptm.getMass());
                }
                continue;
            }
            if (ptm.getType() == 2) {
                for (Character aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                    ptmMap = this.variableAaModificationsAtProteinNterm.get(aa);
                    if (ptmMap == null) {
                        ptmMap = new HashMap(1);
                        this.variableAaModificationsAtProteinNterm.put(aa, ptmMap);
                    }
                    ptmMap.put(modificationName, ptm.getMass());
                }
                continue;
            }
            if (ptm.getType() == 6) {
                for (Character aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                    ptmMap = this.variableAaModificationsAtPeptideNterm.get(aa);
                    if (ptmMap == null) {
                        ptmMap = new HashMap(1);
                        this.variableAaModificationsAtPeptideNterm.put(aa, ptmMap);
                    }
                    ptmMap.put(modificationName, ptm.getMass());
                }
                if (ptm.getMass() < this.minNtermMod) {
                    this.minNtermMod = ptm.getMass();
                }
                if (!(ptm.getMass() > this.maxNtermMod)) continue;
                this.maxNtermMod = ptm.getMass();
                continue;
            }
            if (ptm.getType() == 4) {
                for (Character aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                    ptmMap = this.variableAaModificationsAtProteinNterm.get(aa);
                    if (ptmMap == null) {
                        ptmMap = new HashMap(1);
                        this.variableAaModificationsAtProteinNterm.put(aa, ptmMap);
                    }
                    ptmMap.put(modificationName, ptm.getMass());
                }
                continue;
            }
            if (ptm.getType() != 8) continue;
            for (Character aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                ptmMap = this.variableAaModificationsAtPeptideNterm.get(aa);
                if (ptmMap == null) {
                    ptmMap = new HashMap(1);
                    this.variableAaModificationsAtPeptideNterm.put(aa, ptmMap);
                }
                ptmMap.put(modificationName, ptm.getMass());
            }
            if (ptm.getMass() < this.minCtermMod) {
                this.minCtermMod = ptm.getMass();
            }
            if (!(ptm.getMass() > this.maxCtermMod)) continue;
            this.maxCtermMod = ptm.getMass();
        }
    }

    public HashMap<Integer, ArrayList<Peptide>> getPeptideMatches(Tag tag, String accession, String sequence, Integer tagIndex, Integer componentIndex, double massTolerance) {
        int componentAtIndexLength;
        ArrayList<TagComponent> content = tag.getContent();
        TagComponent componentAtIndex = content.get(componentIndex);
        HashMap<Integer, ArrayList<ModificationMatch>> modificationsAtIndex = null;
        if (componentAtIndex instanceof AminoAcidPattern) {
            AminoAcidPattern tagPattern = (AminoAcidPattern)componentAtIndex;
            componentAtIndexLength = tagPattern.length();
            modificationsAtIndex = tagPattern.getModificationMatches();
        } else if (componentAtIndex instanceof AminoAcidSequence) {
            AminoAcidSequence tagSequence = (AminoAcidSequence)componentAtIndex;
            componentAtIndexLength = tagSequence.length();
            modificationsAtIndex = tagSequence.getModificationMatches();
        } else {
            throw new UnsupportedOperationException("Tag mapping not supported for tag component " + componentAtIndex.getClass() + ".");
        }
        String seedSequence = sequence.substring(tagIndex, tagIndex + componentAtIndexLength);
        int seedMutations = 0;
        if (this.sequenceMatchingPreferences.hasMutationMatrix()) {
            if (componentAtIndex instanceof AminoAcidPattern) {
                AminoAcidPattern tagPattern = (AminoAcidPattern)componentAtIndex;
                seedMutations = tagPattern.nMutations(seedSequence, this.sequenceMatchingPreferences);
            } else if (componentAtIndex instanceof AminoAcidSequence) {
                AminoAcidSequence tagSequence = (AminoAcidSequence)componentAtIndex;
                seedMutations = tagSequence.nMutations(seedSequence, this.sequenceMatchingPreferences);
            } else {
                throw new UnsupportedOperationException("Tag mapping not supported for tag component " + componentAtIndex.getClass() + ".");
            }
        }
        if (this.sequenceMatchingPreferences.hasMutationMatrix() && this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() != null && this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() < seedMutations) {
            return new HashMap<Integer, ArrayList<Peptide>>(0);
        }
        ArrayList<SequenceSegment> nTermPossibleSequences = new ArrayList<SequenceSegment>(1);
        nTermPossibleSequences.add(new SequenceSegment(tagIndex, true));
        for (int i = componentIndex - 1; i >= 0; --i) {
            TagComponent tagComponent = content.get(i);
            nTermPossibleSequences = this.mapTagComponent(accession, sequence, tagComponent, nTermPossibleSequences, massTolerance, this.useCache && i == componentIndex - 1, true, i == 0);
            if (!nTermPossibleSequences.isEmpty()) continue;
            return new HashMap<Integer, ArrayList<Peptide>>(0);
        }
        ArrayList<SequenceSegment> cTermPossibleSequences = new ArrayList<SequenceSegment>(1);
        cTermPossibleSequences.add(new SequenceSegment(tagIndex + componentAtIndexLength - 1, false));
        for (int i = componentIndex + 1; i < content.size(); ++i) {
            TagComponent tagComponent = content.get(i);
            cTermPossibleSequences = this.mapTagComponent(accession, sequence, tagComponent, cTermPossibleSequences, massTolerance, this.useCache && i == componentIndex + 1, false, i == content.size() - 1);
            if (!cTermPossibleSequences.isEmpty()) continue;
            return new HashMap<Integer, ArrayList<Peptide>>(0);
        }
        HashMap<Integer, ArrayList<Peptide>> result = this.buildPeptides(sequence, nTermPossibleSequences, seedSequence, cTermPossibleSequences, modificationsAtIndex, seedMutations);
        return result;
    }

    public HashMap<Integer, ArrayList<Peptide>> buildPeptides(String sequence, ArrayList<SequenceSegment> nTermPossibleSequences, String seedSequence, ArrayList<SequenceSegment> cTermPossibleSequences, HashMap<Integer, ArrayList<ModificationMatch>> modificationsAtIndex, int mutationsAtIndex) {
        HashMap<Integer, ArrayList<Peptide>> result = new HashMap<Integer, ArrayList<Peptide>>(nTermPossibleSequences.size() * cTermPossibleSequences.size());
        if (this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() == null || this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() > mutationsAtIndex) {
            for (SequenceSegment nTermSegment : nTermPossibleSequences) {
                StringBuilder nTermSequence = new StringBuilder(nTermSegment.length() + seedSequence.length());
                nTermSequence.append(nTermSegment.getSegmentSequence(sequence));
                nTermSequence.append(seedSequence);
                if (this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() != null && this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() <= mutationsAtIndex + nTermSegment.getnMutations()) continue;
                for (SequenceSegment cTermSegment : cTermPossibleSequences) {
                    if (this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() != null && this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() <= mutationsAtIndex + nTermSegment.getnMutations() + cTermSegment.getnMutations()) continue;
                    StringBuilder peptideSequence = new StringBuilder(nTermSegment.length() + seedSequence.length() + cTermSegment.length());
                    peptideSequence.append((CharSequence)nTermSequence);
                    ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>(1);
                    HashMap<Integer, String> nTermModifications = nTermSegment.getModificationMatches();
                    if (nTermModifications != null) {
                        for (Integer n : nTermModifications.keySet()) {
                            String ptmName = nTermModifications.get(n);
                            modificationMatches.add(new ModificationMatch(ptmName, true, nTermSegment.length() - 1 - n));
                        }
                    }
                    if (modificationsAtIndex != null) {
                        for (Integer n : modificationsAtIndex.keySet()) {
                            for (ModificationMatch modificationMatch : modificationsAtIndex.get(n)) {
                                modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), nTermSegment.length() + n));
                            }
                        }
                    }
                    peptideSequence.append(cTermSegment.getSegmentSequence(sequence));
                    HashMap<Integer, String> cTermModifications = cTermSegment.getModificationMatches();
                    if (cTermModifications != null) {
                        for (Integer site : cTermModifications.keySet()) {
                            String ptmName = cTermModifications.get(site);
                            modificationMatches.add(new ModificationMatch(ptmName, true, nTermSegment.length() + seedSequence.length() + site));
                        }
                    }
                    Peptide peptide = new Peptide(peptideSequence.toString(), modificationMatches);
                    Integer nTermIndex = nTermSegment.getTerminalIndex() + 1;
                    ArrayList<Peptide> peptides = result.get(nTermIndex);
                    if (peptides == null) {
                        peptides = new ArrayList(1);
                        result.put(nTermIndex, peptides);
                    }
                    peptides.add(peptide);
                }
            }
        }
        return result;
    }

    private ArrayList<SequenceSegment> mapTagComponent(String accession, String sequence, TagComponent tagComponent, ArrayList<SequenceSegment> terminalPreviousSequences, double massTolerance, boolean useCache, boolean nTerminus, boolean lastComponent) {
        if (tagComponent instanceof AminoAcidPattern) {
            for (SequenceSegment terminalSequence : terminalPreviousSequences) {
                Integer aaIndex = terminalSequence.getTerminalIndex();
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                String subSequence = null;
                if (nTerminus) {
                    Integer startIndex = aaIndex - aminoAcidPattern.length();
                    if (startIndex >= 0) {
                        subSequence = sequence.substring(startIndex, aaIndex);
                    }
                } else {
                    Integer endIndex = aaIndex + aminoAcidPattern.length();
                    if (endIndex <= sequence.length() - 1) {
                        subSequence = sequence.substring(aaIndex, endIndex);
                    }
                }
                if (subSequence == null || !aminoAcidPattern.matches(subSequence, this.sequenceMatchingPreferences)) continue;
                terminalSequence.appendTerminus((SequenceSegment)((Object)tagComponent));
            }
            return terminalPreviousSequences;
        }
        if (tagComponent instanceof AminoAcidSequence) {
            for (SequenceSegment terminalSequence : terminalPreviousSequences) {
                Integer aaIndex = terminalSequence.getTerminalIndex();
                AminoAcidSequence aminoAcidPattern = (AminoAcidSequence)tagComponent;
                String subSequence = null;
                if (nTerminus) {
                    Integer startIndex = aaIndex - aminoAcidPattern.length();
                    if (startIndex >= 0) {
                        subSequence = sequence.substring(startIndex, aaIndex);
                    }
                } else {
                    Integer endIndex = aaIndex + aminoAcidPattern.length();
                    if (endIndex <= sequence.length() - 1) {
                        subSequence = sequence.substring(aaIndex, endIndex);
                    }
                }
                if (subSequence == null || !aminoAcidPattern.matches(subSequence, this.sequenceMatchingPreferences)) continue;
                terminalSequence.appendTerminus((SequenceSegment)((Object)tagComponent));
            }
            return terminalPreviousSequences;
        }
        if (tagComponent instanceof MassGap) {
            double massGap = tagComponent.getMass();
            ArrayList<SequenceSegment> newSequences = new ArrayList<SequenceSegment>(1);
            for (int i = 0; i < terminalPreviousSequences.size(); ++i) {
                SequenceSegment terminalSequence = terminalPreviousSequences.get(i);
                int aaIndex = terminalSequence.getTerminalIndex();
                Integer currentIndex = aaIndex;
                ArrayList<SequenceSegment> possibleSequences = null;
                ArrayList<SequenceSegment> validSequences = new ArrayList<SequenceSegment>(1);
                HashMap<Integer, ArrayList<SequenceSegment>> indexCache = this.getIndexCache(accession, currentIndex, nTerminus);
                aaIndex = nTerminus ? --aaIndex : ++aaIndex;
                while (aaIndex >= 0 && aaIndex < sequence.length()) {
                    char sequenceAa = sequence.charAt(aaIndex);
                    AminoAcid sequenceAminoAcid = AminoAcid.getAminoAcid(sequenceAa);
                    int segmentLength = Math.abs(aaIndex - currentIndex);
                    if (useCache && segmentLength <= 12) {
                        possibleSequences = indexCache.get(aaIndex);
                        if (possibleSequences == null) {
                            possibleSequences = this.synchronizedIndexing ? this.addSequenceSegmentsToCacheSynchronized(indexCache, sequence, sequenceAminoAcid, currentIndex, aaIndex, nTerminus) : this.addSequenceSegmentsToCache(indexCache, sequence, sequenceAminoAcid, currentIndex, aaIndex, nTerminus);
                        }
                    } else {
                        possibleSequences = this.getCombinationsForAminoAcid(sequence, possibleSequences, sequenceAminoAcid, currentIndex, aaIndex, nTerminus);
                    }
                    if (this.validateSegments(possibleSequences, validSequences, massGap, massTolerance, sequence, sequenceAa, nTerminus)) {
                        if (this.debugbw == null) break;
                        try {
                            this.debugbw.write(segmentLength + "\n");
                            this.debugbw.flush();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    if (nTerminus) {
                        --aaIndex;
                        continue;
                    }
                    ++aaIndex;
                }
                if (!lastComponent) {
                    for (SequenceSegment validSegment : validSequences) {
                        SequenceSegment sequenceSegment = new SequenceSegment(validSegment);
                        sequenceSegment.appendTerminus(terminalSequence);
                        newSequences.add(sequenceSegment);
                    }
                    continue;
                }
                newSequences.addAll(validSequences);
            }
            return newSequences;
        }
        throw new IllegalArgumentException("Tag component " + tagComponent.getClass() + " not implemented for sequence matching.");
    }

    public HashMap<Integer, ArrayList<SequenceSegment>> getIndexCache(String accession, Integer currentIndex, boolean nTerminus) {
        HashMap<Integer, ArrayList<SequenceSegment>> indexCache;
        HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>> proteinCache = nTerminus ? this.nTermCache.get(accession) : this.cTermCache.get(accession);
        if (proteinCache == null) {
            proteinCache = this.synchronizedIndexing ? this.addProteinCacheSynchronized(accession, currentIndex, nTerminus) : this.addProteinCache(accession, currentIndex, nTerminus);
        }
        if ((indexCache = proteinCache.get(currentIndex)) == null) {
            indexCache = this.synchronizedIndexing ? this.addIndexCacheSynchronized(proteinCache, currentIndex) : this.addIndexCache(proteinCache, currentIndex);
        }
        return indexCache;
    }

    private synchronized HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>> addProteinCacheSynchronized(String accession, Integer currentIndex, boolean nTerminus) {
        HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>> proteinCache = nTerminus ? this.nTermCache.get(accession) : this.cTermCache.get(accession);
        if (proteinCache == null) {
            proteinCache = this.addProteinCache(accession, currentIndex, nTerminus);
        }
        return proteinCache;
    }

    private HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>> addProteinCache(String accession, Integer currentIndex, boolean nTerminus) {
        HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>> proteinCache = new HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>>();
        if (nTerminus) {
            this.nTermCache.put(accession, proteinCache);
        } else {
            this.cTermCache.put(accession, proteinCache);
        }
        HashMap indexCache = new HashMap(1);
        proteinCache.put(currentIndex, indexCache);
        return proteinCache;
    }

    private HashMap<Integer, ArrayList<SequenceSegment>> addIndexCacheSynchronized(HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>> proteinCache, Integer currentIndex) {
        HashMap<Integer, ArrayList<SequenceSegment>> indexCache = proteinCache.get(currentIndex);
        if (indexCache == null) {
            this.addIndexCache(proteinCache, currentIndex);
        }
        return indexCache;
    }

    private HashMap<Integer, ArrayList<SequenceSegment>> addIndexCache(HashMap<Integer, HashMap<Integer, ArrayList<SequenceSegment>>> proteinCache, Integer currentIndex) {
        HashMap<Integer, ArrayList<SequenceSegment>> indexCache = new HashMap<Integer, ArrayList<SequenceSegment>>(1);
        proteinCache.put(currentIndex, indexCache);
        return indexCache;
    }

    public synchronized ArrayList<SequenceSegment> addSequenceSegmentsToCacheSynchronized(HashMap<Integer, ArrayList<SequenceSegment>> indexCache, String sequence, AminoAcid aminoAcid, Integer currentIndex, Integer aaIndex, boolean nTerminus) {
        ArrayList<SequenceSegment> result = indexCache.get(aaIndex);
        if (result == null) {
            result = this.addSequenceSegmentsToCache(indexCache, sequence, aminoAcid, currentIndex, aaIndex, nTerminus);
        }
        return result;
    }

    public ArrayList<SequenceSegment> addSequenceSegmentsToCache(HashMap<Integer, ArrayList<SequenceSegment>> indexCache, String sequence, AminoAcid aminoAcid, Integer currentIndex, Integer aaIndex, boolean nTerminus) {
        ArrayList<SequenceSegment> previousSequences = nTerminus ? indexCache.get(aaIndex + 1) : indexCache.get(aaIndex - 1);
        ArrayList<SequenceSegment> result = this.getCombinationsForAminoAcid(sequence, previousSequences, aminoAcid, currentIndex, aaIndex, nTerminus);
        indexCache.put(aaIndex, result);
        return result;
    }

    public ArrayList<SequenceSegment> getCombinationsForAminoAcid(String sequence, ArrayList<SequenceSegment> possibleSequences, AminoAcid aminoAcid, Integer currentIndex, Integer aaIndex, boolean nTerminus) {
        char aa = aminoAcid.getSingleLetterCodeAsChar();
        Double fixedMass = this.fixedAaModificationsMasses.get(Character.valueOf(aa));
        HashMap<String, Double> variableModificationsAtAa = this.variableAaModifications.get(Character.valueOf(aa));
        if (possibleSequences == null) {
            HashMap<String, Double> aaTerminalModifications;
            Double aaTerminalMass;
            possibleSequences = new ArrayList(2);
            SequenceSegment sequenceSegment = new SequenceSegment(aaIndex, nTerminus);
            possibleSequences.add(sequenceSegment);
            sequenceSegment.appendTerminus(aminoAcid);
            double modificationMass = 0.0;
            if (fixedMass != null) {
                modificationMass += fixedMass.doubleValue();
            }
            if (nTerminus && aaIndex == 0) {
                modificationMass += this.fixedNTermProteinModificationsMass;
                if (!this.fixedAaModificationsProteinNtermMasses.isEmpty() && (aaTerminalMass = this.fixedAaModificationsProteinNtermMasses.get(Character.valueOf(aa))) != null) {
                    modificationMass += aaTerminalMass.doubleValue();
                }
            } else if (!nTerminus && aaIndex == sequence.length() - 1) {
                modificationMass += this.fixedCTermProteinModificationsMass;
                if (!this.fixedAaModificationsProteinCtermMasses.isEmpty() && (aaTerminalMass = this.fixedAaModificationsProteinCtermMasses.get(Character.valueOf(aa))) != null) {
                    modificationMass += aaTerminalMass.doubleValue();
                }
            }
            sequenceSegment.addMass(modificationMass);
            this.addVariableModifications(variableModificationsAtAa, sequenceSegment, possibleSequences);
            if (nTerminus && aaIndex == 0) {
                this.addVariableModifications(this.variableNTermProteinModifications, sequenceSegment, possibleSequences);
                if (!this.variableAaModificationsAtProteinNterm.isEmpty() && (aaTerminalModifications = this.variableAaModificationsAtProteinNterm.get(Character.valueOf(aa))) != null) {
                    this.addVariableModifications(aaTerminalModifications, sequenceSegment, possibleSequences);
                }
            } else if (!nTerminus && aaIndex == sequence.length() - 1) {
                this.addVariableModifications(this.variableCTermProteinModifications, sequenceSegment, possibleSequences);
                if (!this.variableAaModificationsAtProteinCterm.isEmpty() && (aaTerminalModifications = this.variableAaModificationsAtProteinCterm.get(Character.valueOf(aa))) != null) {
                    this.addVariableModifications(aaTerminalModifications, sequenceSegment, possibleSequences);
                }
            }
            return possibleSequences;
        }
        ArrayList<SequenceSegment> newPossibleSequences = new ArrayList<SequenceSegment>(possibleSequences.size());
        for (int i = 0; i < possibleSequences.size(); ++i) {
            HashMap<String, Double> aaTerminalModifications;
            SequenceSegment sequenceSegment = possibleSequences.get(i);
            SequenceSegment newSegment = new SequenceSegment(sequenceSegment);
            newPossibleSequences.add(newSegment);
            newSegment.appendTerminus(aminoAcid);
            double modificationMass = 0.0;
            if (fixedMass != null) {
                modificationMass += fixedMass.doubleValue();
            }
            if (nTerminus && aaIndex == 0) {
                modificationMass += this.fixedNTermProteinModificationsMass;
            } else if (!nTerminus && aaIndex == sequence.length() - 1) {
                modificationMass += this.fixedCTermProteinModificationsMass;
            }
            newSegment.addMass(modificationMass);
            this.addVariableModifications(variableModificationsAtAa, newSegment, newPossibleSequences);
            if (nTerminus && aaIndex == 0) {
                this.addVariableModifications(this.variableNTermProteinModifications, newSegment, newPossibleSequences);
                if (this.variableAaModificationsAtProteinNterm.isEmpty() || (aaTerminalModifications = this.variableAaModificationsAtProteinNterm.get(Character.valueOf(aa))) == null) continue;
                this.addVariableModifications(aaTerminalModifications, newSegment, newPossibleSequences);
                continue;
            }
            if (nTerminus || aaIndex != sequence.length() - 1) continue;
            this.addVariableModifications(this.variableCTermProteinModifications, newSegment, newPossibleSequences);
            if (this.variableAaModificationsAtProteinCterm.isEmpty() || (aaTerminalModifications = this.variableAaModificationsAtProteinCterm.get(Character.valueOf(aa))) == null) continue;
            this.addVariableModifications(aaTerminalModifications, newSegment, newPossibleSequences);
        }
        return newPossibleSequences;
    }

    public boolean validateSegments(ArrayList<SequenceSegment> possibleSequences, ArrayList<SequenceSegment> validSequences, double massGap, double massTolerance, String sequence, char sequenceAa, boolean nTerminus) {
        boolean allInspected = true;
        for (int i = 0; i < possibleSequences.size(); ++i) {
            SequenceSegment sequenceSegment = possibleSequences.get(i);
            double sequenceMass = sequenceSegment.getMass();
            if (nTerminus) {
                Double aaTerminalMass;
                sequenceMass += this.fixedNTermPeptideModificationsMass;
                if (!this.fixedAaModificationsPeptideNtermMasses.isEmpty() && (aaTerminalMass = this.fixedAaModificationsPeptideNtermMasses.get(Character.valueOf(sequenceAa))) != null) {
                    sequenceMass += aaTerminalMass.doubleValue();
                }
            } else {
                Double aaTerminalMass;
                sequenceMass += this.fixedCTermPeptideModificationsMass;
                if (!this.fixedAaModificationsPeptideCtermMasses.isEmpty() && (aaTerminalMass = this.fixedAaModificationsPeptideCtermMasses.get(Character.valueOf(sequenceAa))) != null) {
                    sequenceMass += aaTerminalMass.doubleValue();
                }
            }
            double terminalModificationMin = nTerminus ? this.minNtermMod : this.minCtermMod;
            double terminalModificationMax = nTerminus ? this.maxNtermMod : this.maxCtermMod;
            boolean found = false;
            boolean overGap = true;
            if (sequenceMass + terminalModificationMin <= massGap + massTolerance) {
                overGap = false;
                if (sequenceMass + terminalModificationMax >= massGap - massTolerance) {
                    found = this.validateSegment(validSequences, sequenceSegment, sequenceMass, massGap, massTolerance, sequenceAa, nTerminus);
                }
            }
            if (!found && this.sequenceMatchingPreferences.hasMutationMatrix() && (this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() == null || this.sequenceMatchingPreferences.getMaxMutationsPerPeptide() > sequenceSegment.getnMutations())) {
                MutationMatrix mutationMatrix = this.sequenceMatchingPreferences.getMutationMatrix();
                Double minDelta = 0.0;
                if (mutationMatrix.getMinDelta() != null) {
                    minDelta = mutationMatrix.getMinDelta();
                }
                if (sequenceMass + terminalModificationMin + minDelta <= massGap + massTolerance) {
                    overGap = false;
                    Double maxDelta = 0.0;
                    if (mutationMatrix.getMaxDelta() != null) {
                        maxDelta = mutationMatrix.getMaxDelta();
                    }
                    if (sequenceMass + terminalModificationMax + maxDelta >= massGap - massTolerance) {
                        for (int j = 0; j < sequenceSegment.length(); ++j) {
                            int indexOnProtein = sequenceSegment.getIndexOnProtein() + j;
                            int indexOnSegment = nTerminus ? sequenceSegment.length() - 1 - j : j;
                            char originalAa = sequence.charAt(indexOnProtein);
                            HashMap<Double, HashSet<Character>> mutationMap = mutationMatrix.getMutatedMasses(Character.valueOf(originalAa));
                            if (mutationMap == null) continue;
                            for (Double deltaMass : mutationMap.keySet()) {
                                if (!this.validateSegment(validSequences, sequenceSegment, sequenceMass, massGap, massTolerance, sequenceAa, indexOnSegment, deltaMass, mutationMap.get(deltaMass), nTerminus)) continue;
                                found = true;
                            }
                        }
                    }
                }
            }
            if (found || overGap) continue;
            allInspected = false;
        }
        return allInspected;
    }

    private boolean validateSegment(ArrayList<SequenceSegment> validSequences, SequenceSegment sequenceSegment, double sequenceMass, double massGap, double massTolerance, char sequenceAa, boolean nTerminus) {
        return this.validateSegment(validSequences, sequenceSegment, sequenceMass, massGap, massTolerance, sequenceAa, 0, 0.0, null, nTerminus);
    }

    private boolean validateSegment(ArrayList<SequenceSegment> validSequences, SequenceSegment sequenceSegment, double sequenceMass, double massGap, double massTolerance, char sequenceAa, int mutatedIndex, double deltaMutation, HashSet<Character> mutated, boolean nTerminus) {
        block24: {
            HashMap<String, Double> variableTermPeptideModificationsAtAa;
            block23: {
                HashMap<String, Double> variableTermPeptideModificationsAtAa2;
                if (Math.abs(sequenceMass + deltaMutation - massGap) <= massTolerance) {
                    if (mutated == null) {
                        validSequences.add(sequenceSegment);
                    } else {
                        for (char c : mutated) {
                            SequenceSegment mutatedSegment = new SequenceSegment(sequenceSegment);
                            mutatedSegment.addMutation(mutatedIndex, Character.valueOf(c));
                            validSequences.add(mutatedSegment);
                        }
                    }
                    return true;
                }
                if (!nTerminus) break block23;
                if (this.variableNTermPeptideModifications != null) {
                    for (String string : this.variableNTermPeptideModifications.keySet()) {
                        double modifiedMass = sequenceMass + this.variableNTermPeptideModifications.get(string);
                        if (!(Math.abs(modifiedMass + deltaMutation - massGap) <= massTolerance)) continue;
                        if (mutated == null) {
                            SequenceSegment modifiedSegment = new SequenceSegment(sequenceSegment);
                            modifiedSegment.addModificationTerminus(string);
                            validSequences.add(modifiedSegment);
                        } else {
                            for (char aa : mutated) {
                                SequenceSegment mutatedSegment = new SequenceSegment(sequenceSegment);
                                mutatedSegment.addMutation(mutatedIndex, Character.valueOf(aa));
                                mutatedSegment.addModificationTerminus(string);
                                validSequences.add(mutatedSegment);
                            }
                        }
                        return true;
                    }
                }
                if (this.variableAaModificationsAtPeptideNterm.isEmpty() || (variableTermPeptideModificationsAtAa2 = this.variableAaModificationsAtPeptideNterm.get(Character.valueOf(sequenceAa))) == null) break block24;
                for (String modificationName : variableTermPeptideModificationsAtAa2.keySet()) {
                    double modifiedMass = sequenceMass + variableTermPeptideModificationsAtAa2.get(modificationName);
                    if (!(Math.abs(modifiedMass + deltaMutation - massGap) <= massTolerance)) continue;
                    if (mutated == null) {
                        SequenceSegment modifiedSegment = new SequenceSegment(sequenceSegment);
                        modifiedSegment.addModificationTerminus(modificationName);
                        validSequences.add(modifiedSegment);
                    } else {
                        for (char aa : mutated) {
                            SequenceSegment mutatedSegment = new SequenceSegment(sequenceSegment);
                            mutatedSegment.addMutation(mutatedIndex, Character.valueOf(aa));
                            mutatedSegment.addModificationTerminus(modificationName);
                            validSequences.add(mutatedSegment);
                        }
                    }
                    return true;
                }
                break block24;
            }
            if (this.variableCTermPeptideModifications != null) {
                for (String string : this.variableCTermPeptideModifications.keySet()) {
                    double modifiedMass = sequenceMass + this.variableCTermPeptideModifications.get(string);
                    if (!(Math.abs(modifiedMass + deltaMutation - massGap) <= massTolerance)) continue;
                    if (mutated == null) {
                        SequenceSegment modifiedSegment = new SequenceSegment(sequenceSegment);
                        modifiedSegment.addModificationTerminus(string);
                        validSequences.add(modifiedSegment);
                    } else {
                        for (char aa : mutated) {
                            SequenceSegment mutatedSegment = new SequenceSegment(sequenceSegment);
                            mutatedSegment.addMutation(mutatedIndex, Character.valueOf(aa));
                            mutatedSegment.addModificationTerminus(string);
                            validSequences.add(mutatedSegment);
                        }
                    }
                    return true;
                }
            }
            if (!this.variableAaModificationsAtPeptideCterm.isEmpty() && (variableTermPeptideModificationsAtAa = this.variableAaModificationsAtPeptideCterm.get(Character.valueOf(sequenceAa))) != null) {
                for (String modificationName : variableTermPeptideModificationsAtAa.keySet()) {
                    double modifiedMass = sequenceMass + variableTermPeptideModificationsAtAa.get(modificationName);
                    if (!(Math.abs(modifiedMass + deltaMutation - massGap) <= massTolerance)) continue;
                    if (mutated == null) {
                        SequenceSegment modifiedSegment = new SequenceSegment(sequenceSegment);
                        modifiedSegment.addModificationTerminus(modificationName);
                        validSequences.add(modifiedSegment);
                    } else {
                        for (char aa : mutated) {
                            SequenceSegment mutatedSegment = new SequenceSegment(sequenceSegment);
                            mutatedSegment.addMutation(mutatedIndex, Character.valueOf(aa));
                            mutatedSegment.addModificationTerminus(modificationName);
                            validSequences.add(mutatedSegment);
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void addVariableModifications(HashMap<String, Double> variableModifications, SequenceSegment noModSegment, ArrayList<SequenceSegment> possibleSegments) {
        if (variableModifications != null) {
            for (String modificationName : variableModifications.keySet()) {
                SequenceSegment modifiedSegment = new SequenceSegment(noModSegment);
                Double ptmMass = variableModifications.get(modificationName);
                modifiedSegment.addModificationTerminus(modificationName, ptmMass);
                possibleSegments.add(modifiedSegment);
            }
        }
    }

    public void clearCache() {
        this.nTermCache.clear();
        this.cTermCache.clear();
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setSynchronizedIndexing(boolean synchronizedIndexing) {
        this.synchronizedIndexing = synchronizedIndexing;
    }
}

