## ----eval = TRUE, echo = TRUE, message = FALSE--------------------------------
library(ORFik)

## ----eval = TRUE, echo = TRUE-------------------------------------------------
# Read from (create.experiment() template)
# 1. Pick directory (normally a folder with bam / bed / wig files)
dir <- system.file("extdata", "", package = "ORFik")
list.files(dir)

## ----eval = TRUE, echo = TRUE-------------------------------------------------
# 2. Pick an experiment name
exper <- "ORFik"
# 3. Pick .gff/.gtf and fasta location
txdb <- system.file("extdata", "annotations.gtf", package = "ORFik")
fasta <- system.file("extdata", "genome.fasta", package = "ORFik")
template <- create.experiment(dir = dir,   # dir is the NGS files
                              exper,       # Experiment name
                              txdb = txdb, # gtf / gff / gff.db annotation
                              fa = fasta,  # Fasta genome
                              viewTemplate = FALSE)
data.frame(template)

## ----eval = TRUE, echo = TRUE-------------------------------------------------
template$X5[6] <- "heart_valve" # <- fix non unique row (tissue fraction is heart valve)
# read experiment from template
df <- read.experiment(template)

## ----eval = FALSE, echo = TRUE------------------------------------------------
#  save.experiment(df, file = "path/to/save/experiment.csv")

## ----eval = TRUE, echo = TRUE-------------------------------------------------
df

## ----eval = TRUE, echo = TRUE-------------------------------------------------
df$filepath

## ----eval = TRUE, echo = TRUE, warning = FALSE--------------------------------
# First load experiment if not present
# We use our already loaded experiment: (df) here

# Load transcript annotation
txdb <- loadTxdb(df) # transcript annotation
# And now NGS data
outputLibs(df, chrStyle = seqlevelsStyle(txdb)) # Use txdb as seqlevelsStyle reference

## ----eval = TRUE, echo = TRUE-------------------------------------------------
bamVarName(df) #This will be the names:

## ----eval = TRUE, echo = TRUE-------------------------------------------------
df@expInVarName <- FALSE
bamVarName(df) #This will be the names:

## ----eval = TRUE, echo = TRUE-------------------------------------------------
df@expInVarName <- TRUE
remove.experiments(df)
df@expInVarName <- FALSE
outputLibs(df, chrStyle = seqlevelsStyle(txdb)) 

## ----eval = TRUE, echo = TRUE-------------------------------------------------
txNames <- filterTranscripts(txdb, minFiveUTR = 30,minCDS = 30, minThreeUTR = 30)
loadRegions(txdb, parts = c("leaders", "cds", "trailers"), names.keep = txNames)

## ----eval = TRUE, echo = TRUE, warning=FALSE----------------------------------
transcriptWindow(leaders, cds, trailers, df[3,])

## ----eval = FALSE, echo = TRUE, warning=FALSE---------------------------------
#  ORFik:::shiftFootprintsByExperiment(df[df$libtype == "ribo-seq",])

## ----eval = FALSE, echo = TRUE, warning=FALSE---------------------------------
#  outputLibs(df[df$libtype == "ribo-seq",], type = "pshifted")

## ----eval = FALSE, echo = TRUE, warning=FALSE---------------------------------
#  ORFikQC(df)

