### R code from vignette source 'FlowSOM.Rnw'

###################################################
### code chunk number 1: style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: FlowSOM.Rnw:54-56
###################################################
# install.packages("BiocManager")
# BiocManager::install("FlowSOM")


###################################################
### code chunk number 3: FlowSOM.Rnw:66-81
###################################################
set.seed(42)
library(FlowSOM)

fileName <- system.file("extdata", "68983.fcs", package="FlowSOM")
fSOM <- FlowSOM(fileName,
                # Input options:
                compensate = TRUE, transform = TRUE, toTransform=c(8:18),
                scale = TRUE,
                # SOM options:
                colsToUse = c(9,12,14:18), xdim = 7, ydim = 7,
                # Metaclustering options:
                nClus = 10)

PlotStars(fSOM[[1]],
            backgroundValues = as.factor(fSOM[[2]]))


###################################################
### code chunk number 4: FlowSOM.Rnw:114-124
###################################################
set.seed(42)
library(flowCore)
library(FlowSOM)

fileName <- system.file("extdata", "68983.fcs", package="FlowSOM")
fSOM <- ReadInput(fileName, compensate = TRUE, transform = TRUE, 
                    toTransform=c(8:18), scale = TRUE)

ff <- suppressWarnings(flowCore::read.FCS(fileName))
fSOM <- ReadInput(ff, compensate = TRUE, transform = TRUE, scale = TRUE)


###################################################
### code chunk number 5: FlowSOM.Rnw:135-136
###################################################
str(fSOM, max.level = 2)


###################################################
### code chunk number 6: FlowSOM.Rnw:154-156
###################################################
fSOM <- BuildSOM(fSOM, colsToUse = c(9,12,14:18))
str(fSOM$map, max.level = 2)


###################################################
### code chunk number 7: FlowSOM.Rnw:166-168
###################################################
fSOM <- BuildMST(fSOM, tSNE=TRUE)
str(fSOM$MST)


###################################################
### code chunk number 8: FlowSOM.Rnw:176-177
###################################################
PlotStars(fSOM)


###################################################
### code chunk number 9: FlowSOM.Rnw:179-180
###################################################
PlotStars(fSOM, view="grid")


###################################################
### code chunk number 10: FlowSOM.Rnw:182-183
###################################################
PlotStars(fSOM, view="tSNE")


###################################################
### code chunk number 11: FlowSOM.Rnw:189-192
###################################################
fSOM <- UpdateNodeSize(fSOM, maxNodeSize = 8, reset=TRUE)
PlotStars(fSOM)
fSOM <- UpdateNodeSize(fSOM)


###################################################
### code chunk number 12: FlowSOM.Rnw:199-213
###################################################
wsp_file <- system.file("extdata", "gating.wsp", package = "FlowSOM")

# Specify the cell types of interest for assigning one label per cell
cell_types <- c("B cells",
                "gd T cells", "CD4 T cells", "CD8 T cells",
                "NK cells","NK T cells")

# Parse the FlowJo workspace
gatingResult <- GetFlowJoLabels(fileName, 
                                wsp_file,
                                cell_types = cell_types)


PlotPies(fSOM, cellTypes=gatingResult$manual)


###################################################
### code chunk number 13: FlowSOM.Rnw:219-221
###################################################
print(colnames(fSOM$map$medianValues))
PlotMarker(fSOM,"Pacific Blue-A")


###################################################
### code chunk number 14: FlowSOM.Rnw:225-226
###################################################
PlotNumbers(UpdateNodeSize(fSOM,reset=TRUE, maxNodeSize = 0))


###################################################
### code chunk number 15: FlowSOM.Rnw:230-231
###################################################
PlotClusters2D(fSOM,"PE-Texas Red-A","Pacific Blue-A",c(81,82,91,92,93))


###################################################
### code chunk number 16: FlowSOM.Rnw:244-249
###################################################
metaClustering <- metaClustering_consensus(fSOM$map$codes,k=7)
PlotPies(fSOM,cellTypes=gatingResult$manual,
        backgroundValues = as.factor(metaClustering))
PlotLabels(UpdateNodeSize(fSOM,reset=TRUE, maxNodeSize = 0),
           metaClustering)


###################################################
### code chunk number 17: FlowSOM.Rnw:253-254
###################################################
metaClustering_perCell <- GetMetaclusters(fSOM, metaClustering)


###################################################
### code chunk number 18: FlowSOM.Rnw:264-276
###################################################
# Look for CD8+ ab T cells
query <- c("PE-Cy7-A" = "high", #CD3
            "APC-Cy7-A" = "high", #TCRb
            "Pacific Blue-A" = "high") #CD8
query_res <- QueryStarPlot(UpdateNodeSize(fSOM,reset=TRUE), query, 
                            plot = FALSE)

cellTypes <- factor(rep("Unknown",49),levels=c("Unknown","CD8 T cells"))
cellTypes[query_res$selected] <- "CD8 T cells"
PlotStars(fSOM,
            backgroundValues=cellTypes,
            backgroundColor=c("#FFFFFF00","#0000FF22"))


###################################################
### code chunk number 19: FlowSOM.Rnw:282-320
###################################################
#fig=TRUE>>=
library(FlowSOM)
set.seed(1)

# Build the FlowSOM tree on the example file
fileName <-  system.file("extdata", "68983.fcs", package="FlowSOM")
flowSOM.res <- FlowSOM(fileName, compensate = TRUE, transform = TRUE,
scale = TRUE, colsToUse = c(9,12,14:18), nClus = 10)

# Have a look at the resulting tree
# PlotStars(flowSOM.res[[1]],backgroundValues = as.factor(flowSOM.res[[2]]))

# Select all cells except the branch that corresponds with automated
# cluster 7 (CD3+ TCRyd +) and write te another file for the example
# In practice you would not generate any new file but 
# use your different files from your different groups
ff <- flowCore::read.FCS(fileName)
selection_1 <- which(GetClusters(flowSOM.res) %in% which(flowSOM.res$metaclustering != 7))
ff_tmp <- ff[selection_1,]
flowCore::write.FCS(ff_tmp,file="ff_tmp.fcs")
# Make an additional file without cluster 7 and double amount of cluster 5
selection_2 <- c(which(GetClusters(flowSOM.res) %in% which(flowSOM.res$metaclustering != 7)),
                 which(GetClusters(flowSOM.res) %in% which(flowSOM.res$metaclustering == 5)))
ff_tmp <- ff[selection_2,]
flowCore::write.FCS(ff_tmp, file="ff_tmp2.fcs")

# Compare the original file with the two new files we made
groupRes <- CountGroups(flowSOM.res[[1]], 
                        groups=list("AllCells" = c(fileName),
                                    "Without_ydTcells" = c("ff_tmp.fcs",
                                                           "ff_tmp2.fcs")))
# PlotGroups(flowSOM.res[[1]], groupRes)

# Compare only the file with the double amount of cluster 10
groupRes <- CountGroups(flowSOM.res$FlowSOM, 
                        groups = list("AllCells" = c(fileName),
                                      "Without_ydTcells" = c("ff_tmp2.fcs")))
PlotGroups(flowSOM.res$FlowSOM, groupRes, p_tresh = NULL, tresh = 2)


###################################################
### code chunk number 20: FlowSOM.Rnw:332-333
###################################################
sessionInfo()


