/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.SharedDoubleArrayReductionBuf;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedDoubleArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedDoubleArrayBuf
extends DoubleBuf {
    SharedDoubleArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedDoubleArrayBuf(SharedDoubleArray sharedDoubleArray, Range range) {
        super(range.length());
        this.myArray = sharedDoubleArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public double get(int n) {
        return this.myArray.get(this.myArrayOffset + n * this.myStride);
    }

    public void put(int n, double d) {
        this.myArray.set(this.myArrayOffset + n * this.myStride, d);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedDoubleArrayReductionBuf(this.myArray, this.myRange, (DoubleOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 8) {
            byteBuffer.putDouble(this.myArray.get(n3));
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 8) {
            this.myArray.set(n4, byteBuffer.getDouble());
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

