/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import edu.rit.compbio.seq.Alignment;
import edu.rit.compbio.seq.Blosum62;
import edu.rit.compbio.seq.ProteinSequence;
import java.io.ByteArrayOutputStream;

public abstract class ProteinLocalAlignment {
    int[][] delta = Blosum62.matrix;
    int g = -11;
    int h = -1;
    byte[] A;
    long myQueryId;
    int myQueryLength;
    byte[] B;
    long mySubjectId;
    int mySubjectLength;
    int[][] S;
    int[][] GA;
    int[][] GB;
    long p0;
    long p1;
    long p2;
    long p3;
    long p4;
    long p5;
    long p6;
    long p7;
    long p8;
    long p9;
    long pa;
    long pb;
    long pc;
    long pd;
    long pe;
    long pf;

    public void setSubstitutionMatrix(int[][] nArray) {
        this.delta = nArray;
    }

    public void setGapExistencePenalty(int n) {
        this.g = n;
    }

    public void setGapExtensionPenalty(int n) {
        this.h = n;
    }

    public void setQuerySequence(ProteinSequence proteinSequence, long l) {
        this.A = proteinSequence.sequence();
        this.myQueryId = l;
        this.myQueryLength = proteinSequence.length();
        int n = this.A.length;
        if (this.S == null || this.S.length < n + 32) {
            this.S = new int[n + 32][];
            this.GA = new int[n + 32][];
            this.GB = new int[n + 32][];
        }
    }

    public void setSubjectSequence(ProteinSequence proteinSequence, long l) {
        if (this.A == null) {
            throw new IllegalStateException("ProteinLocalAlignment.setSubjectSequence(): Query sequence not set");
        }
        this.B = proteinSequence.sequence();
        this.mySubjectId = l;
        this.mySubjectLength = proteinSequence.length();
        int n = this.B.length;
        if (this.S[0] == null || this.S[0].length < n + 32) {
            int n2 = this.S.length - 32;
            for (int i = 0; i < n2; ++i) {
                this.S[i] = new int[n + 32];
                this.GA[i] = new int[n + 32];
                this.GB[i] = new int[n + 32];
            }
        }
    }

    public abstract Alignment align() throws Exception;

    Alignment computeTraceback(int n, int n2, int n3) {
        Alignment alignment = new Alignment();
        alignment.myQueryId = this.myQueryId;
        alignment.mySubjectId = this.mySubjectId;
        alignment.myQueryLength = this.myQueryLength;
        alignment.mySubjectLength = this.mySubjectLength;
        if (n == 0) {
            alignment.myTraceback = new byte[0];
            return alignment;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = n2;
        int n5 = n3;
        int n6 = n4;
        int n7 = n5;
        int n8 = 0;
        while (this.S[n4][n5] != 0) {
            switch (n8) {
                case 0: {
                    if (this.S[n4][n5] == this.S[n4 - 1][n5 - 1] + this.delta[this.A[n4]][this.B[n5]]) {
                        byteArrayOutputStream.write(0);
                        n6 = n4--;
                        n7 = n5--;
                        break;
                    }
                    if (this.S[n4][n5] == this.GA[n4][n5]) {
                        n8 = 1;
                        break;
                    }
                    n8 = 2;
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(1);
                    if (this.GA[n4][n5] == this.S[n4 - 1][n5] + this.g) {
                        n8 = 0;
                    }
                    n6 = n4--;
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(2);
                    if (this.GB[n4][n5] == this.S[n4][n5 - 1] + this.g) {
                        n8 = 0;
                    }
                    n7 = n5--;
                }
            }
        }
        alignment.myScore = n;
        alignment.myQueryStart = n6;
        alignment.mySubjectStart = n7;
        alignment.myQueryFinish = n2;
        alignment.mySubjectFinish = n3;
        alignment.myTraceback = byteArrayOutputStream.toByteArray();
        return alignment;
    }
}

