### R code from vignette source 'ADaCGH2.Rnw'

###################################################
### code chunk number 1: ADaCGH2.Rnw:329-334
###################################################
library(ADaCGH2)

data(inputEx)
summary(inputEx)
head(inputEx)


###################################################
### code chunk number 2: ADaCGH2.Rnw:425-430
###################################################
fnameRdata <- list.files(path = system.file("data", package = "ADaCGH2"),
                     full.names = TRUE, pattern = "inputEx.RData")

inputToADaCGH(ff.or.RAM = "RAM",
                      RDatafilename = fnameRdata)


###################################################
### code chunk number 3: ADaCGH2.Rnw:458-461
###################################################
data(inputEx) ## make inputEx available as a data frame with that name
inputToADaCGH(ff.or.RAM = "RAM",
                      dataframe = inputEx)


###################################################
### code chunk number 4: ADaCGH2.Rnw:472-476
###################################################
data(inputEx)
cgh.dat <- inputEx[, -c(1, 2, 3)]
chrom.dat <- as.integer(inputEx[, 2])
pos.dat <- inputEx[, 3]


###################################################
### code chunk number 5: ADaCGH2.Rnw:492-497
###################################################
fnametxt <- list.files(path = system.file("data", package = "ADaCGH2"),
                         full.names = TRUE, pattern = "inputEx.txt")

tmp <- inputToADaCGH(ff.or.RAM = "RAM",
                             textfilename = fnametxt)


###################################################
### code chunk number 6: ADaCGH2.Rnw:558-559 (eval = FALSE)
###################################################
## help(pSegment)


###################################################
### code chunk number 7: ADaCGH2.Rnw:562-565
###################################################
haar.RAM.fork <- pSegmentHaarSeg(cgh.dat, chrom.dat,
                                   merging = "MAD",
                                   typeParall = "fork")


###################################################
### code chunk number 8: ADaCGH2.Rnw:571-573
###################################################
lapply(haar.RAM.fork, head)
summary(haar.RAM.fork[[1]])


###################################################
### code chunk number 9: ADaCGH2.Rnw:588-595
###################################################
pChromPlot(haar.RAM.fork,
           cghRDataName = cgh.dat,
           chromRDataName = chrom.dat,
           posRDataName = pos.dat,
           probenamesRDataName = probenames.dat,
           imgheight = 350,
           typeParall = "fork")


###################################################
### code chunk number 10: ADaCGH2.Rnw:653-659
###################################################
if(.Platform$OS.type != "windows") {

originalDir <- getwd()
## make it explicit where we are
print(originalDir)
}


###################################################
### code chunk number 11: ADaCGH2.Rnw:662-667
###################################################
if(.Platform$OS.type != "windows") {
if(!file.exists("ADaCGH2_vignette_tmp_dir"))
  dir.create("ADaCGH2_vignette_tmp_dir")
setwd("ADaCGH2_vignette_tmp_dir")
}


###################################################
### code chunk number 12: ADaCGH2.Rnw:709-715
###################################################
if(.Platform$OS.type != "windows") {
fnameRdata <- list.files(path = system.file("data", package = "ADaCGH2"),
                     full.names = TRUE, pattern = "inputEx.RData")
inputToADaCGH(ff.or.RAM = "ff",
                      RDatafilename = fnameRdata)
}


###################################################
### code chunk number 13: ADaCGH2.Rnw:765-772 (eval = FALSE)
###################################################
## mcparallel(inputToADaCGH(ff.or.RAM = "ff",
##                                  RDatafilename = fnameRData),
##                                  silent = FALSE)
##   tableChromArray <- mccollect()
##   if(inherits(tableChromArray, "try-error")) {
##     stop("ERROR in input data conversion")
##   }


###################################################
### code chunk number 14: ADaCGH2.Rnw:786-791
###################################################
if(.Platform$OS.type != "windows") {
data(inputEx) ## make inputEx available as a data frame with that name
inputToADaCGH(ff.or.RAM = "ff",
                      dataframe = inputEx)
}


###################################################
### code chunk number 15: ADaCGH2.Rnw:807-814
###################################################
if(.Platform$OS.type != "windows") {
fnametxt <- list.files(path = system.file("data", package = "ADaCGH2"),
                         full.names = TRUE, pattern = "inputEx.txt")

inputToADaCGH(ff.or.RAM = "ff",
                      textfilename = fnametxt)
}


###################################################
### code chunk number 16: ADaCGH2.Rnw:865-876
###################################################
if(.Platform$OS.type != "windows") {
number.of.nodes <- detectCores()
cl2 <- parallel::makeCluster(number.of.nodes, "PSOCK")
parallel::clusterSetRNGStream(cl2)
parallel::setDefaultCluster(cl2) 
parallel::clusterEvalQ(NULL, library("ADaCGH2"))

wdir <- getwd()
parallel::clusterExport(NULL, "wdir")
parallel::clusterEvalQ(NULL, setwd(wdir))
}


###################################################
### code chunk number 17: ADaCGH2.Rnw:906-907 (eval = FALSE)
###################################################
## help(pSegment)


###################################################
### code chunk number 18: ADaCGH2.Rnw:909-915
###################################################
if(.Platform$OS.type != "windows") {
haar.ff.cluster <- pSegmentHaarSeg("cghData.RData",
                                   "chromData.RData", 
                                   merging = "MAD",
                                   typeParall = "cluster")
}


###################################################
### code chunk number 19: ADaCGH2.Rnw:923-927
###################################################
if(.Platform$OS.type != "windows") {
lapply(haar.ff.cluster, open)
summary(haar.ff.cluster[[1]][,])
}


###################################################
### code chunk number 20: ADaCGH2.Rnw:940-951
###################################################
if(.Platform$OS.type != "windows") {
save(haar.ff.cluster, file = "hs_mad.out.RData", compress = FALSE)

pChromPlot(outRDataName = "hs_mad.out.RData",
           cghRDataName = "cghData.RData",
           chromRDataName = "chromData.RData",
           posRDataName = "posData.RData",
           probenamesRDataName = "probeNames.RData",
           imgheight = 350,
           typeParall = "cluster")
}


###################################################
### code chunk number 21: ADaCGH2.Rnw:956-959
###################################################
if(.Platform$OS.type != "windows") {
parallel::stopCluster(cl2)
}


###################################################
### code chunk number 22: ADaCGH2.Rnw:1019-1025
###################################################
if(.Platform$OS.type != "windows") {
fnameRdata <- list.files(path = system.file("data", package = "ADaCGH2"),
                     full.names = TRUE, pattern = "inputEx.RData")
inputToADaCGH(ff.or.RAM = "ff",
                      RDatafilename = fnameRdata)
}


###################################################
### code chunk number 23: ADaCGH2.Rnw:1039-1046 (eval = FALSE)
###################################################
## mcparallel(inputToADaCGH(ff.or.RAM = "ff",
##                                  RDatafilename = fnameRdata), 
##            silent = FALSE)
## tableChromArray <- collect()
## if(inherits(tableChromArray, "try-error")) {
##   stop("ERROR in input data conversion")
## }


###################################################
### code chunk number 24: ADaCGH2.Rnw:1059-1066
###################################################
if(.Platform$OS.type != "windows") {
fnametxt <- list.files(path = system.file("data", package = "ADaCGH2"),
                         full.names = TRUE, pattern = "inputEx.txt")

inputToADaCGH(ff.or.RAM = "ff",
                      textfilename = fnametxt)
}


###################################################
### code chunk number 25: ADaCGH2.Rnw:1127-1144
###################################################
if( (.Platform$OS.type == "unix") && (Sys.info()['sysname'] != "Darwin") ) {
  fnametxt <- list.files(path = system.file("data", package = "ADaCGH2"),
                          full.names = TRUE, pattern = "inputEx.txt")
  if(file.exists("cuttedFile")) {
    stop("The cuttedFile directory already exists. ",
         "Did you run this vignette from this directory before? ",
         "You will not want to do that, unless you modify the arguments ",
         "to inputToADaCGH below")
  } else dir.create("cuttedFile")
  setwd("cuttedFile")
  cutFile(fnametxt, 1, 2, 3, sep = "\t")
  cuttedFile.dir <- getwd()
  setwd("../")
} else {
  cuttedFile.dir <- system.file("example-datadir", 
                                 package = "ADaCGH2")
}


###################################################
### code chunk number 26: ADaCGH2.Rnw:1237-1242
###################################################
if(.Platform$OS.type != "windows") {
inputToADaCGH(ff.or.RAM = "ff",
              path = cuttedFile.dir,
              verbose = TRUE)
}


###################################################
### code chunk number 27: ADaCGH2.Rnw:1287-1293
###################################################
if(.Platform$OS.type != "windows") {
haar.ff.fork <- pSegmentHaarSeg("cghData.RData",
                                "chromData.RData",
                                 merging = "MAD",
                                typeParall = "fork")
}


###################################################
### code chunk number 28: ADaCGH2.Rnw:1302-1313
###################################################
if(.Platform$OS.type != "windows") {
save(haar.ff.fork, file = "haar.ff.fork.RData", compress = FALSE)

pChromPlot(outRDataName = "haar.ff.fork.RData",
           cghRDataName = "cghData.RData",
           chromRDataName = "chromData.RData",
           posRDataName = "posData.RData",
           probenamesRDataName = "probeNames.RData",
           imgheight = 350,
           typeParall = "fork")
}


###################################################
### code chunk number 29: ADaCGH2.Rnw:1342-1366
###################################################
if(.Platform$OS.type != "windows") {
require("limma")
require("snapCGH")
datadir <- system.file("testdata", package = "snapCGH")
targets <- readTargets("targets.txt", path = datadir)
RG1 <- read.maimages(targets$FileName, path = datadir, source = "genepix")


## This is snapCGH-specific
RG1 <- read.clonesinfo("cloneinfo.txt", RG1, path = datadir) 
RG1$printer <- getLayout(RG1$genes)
types <- readSpotTypes("SpotTypes.txt", path = datadir)
RG1$genes$Status <- controlStatus(types, RG1)

RG1$design <- c(-1, -1)


RG2 <- backgroundCorrect(RG1, method = "minimum") ## class RGList
MA <- normalizeWithinArrays(RG2, method = "median") ## class MAList
class(MA)
## now obtain an object of class SegList
MA2 <- processCGH(MA, method.of.averaging = mean, ID = "ID") 
class(MA2)
}


###################################################
### code chunk number 30: ADaCGH2.Rnw:1384-1394
###################################################
if(.Platform$OS.type != "windows") {
tmp <- inputToADaCGH(MAList = MA, 
                             robjnames = c("cgh-ma.dat", "chrom-ma.dat",
                                          "pos-ma.dat", "probenames-ma.dat"))

tmp <- inputToADaCGH(MAList = MA2, 
                             robjnames = c("cgh-ma.dat", "chrom-ma.dat",
                                          "pos-ma.dat", "probenames-ma.dat"),
                             minNumPerChrom = 4)
}


###################################################
### code chunk number 31: ADaCGH2.Rnw:1417-1425
###################################################
if(.Platform$OS.type != "windows") {
targets.limma <- readTargets("targets.txt", path = datadir)
RG.limma <- read.maimages(targets.limma, path = datadir, 
                          source="genepix")
RG.limma <- backgroundCorrect(RG.limma, method="normexp", 
                              offset=50)
MA.limma <- normalizeWithinArrays(RG.limma)
}


###################################################
### code chunk number 32: ADaCGH2.Rnw:1434-1443
###################################################
if(.Platform$OS.type != "windows") {
fclone <- list.files(path = system.file("testdata", package = "snapCGH"),
                     full.names = TRUE, pattern = "cloneinfo.txt")
fclone
tmp <- inputToADaCGH(MAList = MA.limma, 
                             cloneinfo = fclone,
                             robjnames = c("cgh-ma.dat", "chrom-ma.dat",
                                          "pos-ma.dat", "probenames-ma.dat"))
}


###################################################
### code chunk number 33: ADaCGH2.Rnw:1452-1459
###################################################
if(.Platform$OS.type != "windows") {
acloneinfo <- MA$genes
tmp <- inputToADaCGH(MAList = MA.limma, 
                             cloneinfo = acloneinfo,
                             robjnames = c("cgh-ma.dat", "chrom-ma.dat",
                                          "pos-ma.dat", "probenames-ma.dat"))
}


###################################################
### code chunk number 34: ADaCGH2.Rnw:1483-1490
###################################################
if(.Platform$OS.type != "windows") {
forcghr <- outputToCGHregions(haar.ff.cluster)
if(require(CGHregions)) {
  regions1 <- CGHregions(na.omit(forcghr))
  regions1
}
}


###################################################
### code chunk number 35: ADaCGH2.Rnw:1499-1505
###################################################
if(.Platform$OS.type != "windows") {
## We are done with the executable code in the vignette.
## Restore the directory
setwd(originalDir)
print(getwd())
}


###################################################
### code chunk number 36: ADaCGH2.Rnw:1508-1516
###################################################
if(.Platform$OS.type != "windows") {
## Remove the tmp dir. Sys.sleep to prevent Windoze problems.
## Sys.sleep(1)
## What is in that dir?
dir("ADaCGH2_vignette_tmp_dir")
unlink("ADaCGH2_vignette_tmp_dir", recursive = TRUE)
## Sys.sleep(1)
}


###################################################
### code chunk number 37: ADaCGH2.Rnw:2245-2246
###################################################
sessionInfo()


###################################################
### code chunk number 38: ADaCGH2.Rnw:2253-2256
###################################################
## try(closeAllConnections()) ## nope, breaks things
## Remove this sys.sleep; is this sometimes breaking windoze build in BioC?
## Sys.sleep(1) ## I hope we do not need this


