/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation;

class AddLogs {
    static final double interval = 0.01;
    static final int xlateFactor = (int)Math.round(100.0);
    static final int stopVal = -13;
    static final int maxIndex = 0 - xlateFactor * -13;
    static final int xlateTableSize = 1 - -13 * xlateFactor;
    static final double[] xlateTable = new double[xlateTableSize];

    AddLogs() {
    }

    static double add(double p1, double p2) {
        double pMax = Math.max(p1, p2);
        double pMin = Math.min(p1, p2);
        double scaledDiff = (pMax - pMin) * (double)xlateFactor;
        double index = Math.floor(scaledDiff);
        double delta = scaledDiff - index;
        double retVal = (int)index < maxIndex ? pMax + xlateTable[(int)index] * (1.0 - delta) + xlateTable[(int)index + 1] * delta : pMax;
        return retVal;
    }

    static {
        for (int i = 0; i < xlateTableSize; ++i) {
            AddLogs.xlateTable[i] = Math.log(1.0 + Math.exp(0.0 - (double)i * 0.01));
        }
    }
}

