/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.xmlindex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;

public class PsimiXmlIndexer {
    public static final Log log = LogFactory.getLog(PsimiXmlIndexer.class);
    private static final Pattern ID_PATTERN = Pattern.compile("id(?:\\s*)=(?:\\s*)\"(\\d*)\"", 128);

    public PsimiXmlFileIndex build(File f) throws IOException {
        int read;
        long start = System.currentTimeMillis();
        PsimiXmlFileIndex index = new PsimiXmlFileIndex(f);
        long length = f.length();
        if (log.isInfoEnabled()) {
            log.info("length = " + length);
        }
        FileInputStream fis = new FileInputStream(f);
        BufferedReader r = new BufferedReader(new InputStreamReader(fis));
        long offset = 0L;
        fis.getChannel().position(offset);
        char[] c = new char[1];
        int idx = 0;
        boolean recording = false;
        char x = ' ';
        StringBuilder sb = null;
        Stack<Integer> idStack = new Stack<Integer>();
        int currentId = -1;
        while (-1 != (read = ((Reader)r).read(c, 0, 1))) {
            idx += read;
            x = c[0];
            if (recording) {
                if (!this.isAlphabeticalChar(x)) {
                    long position;
                    if (x == '/') {
                        while (-1 != (read = ((Reader)r).read(c, 0, 1))) {
                            idx += read;
                            x = c[0];
                            if (this.isAlphabeticalChar(x)) {
                                sb.append(x);
                                continue;
                            }
                            if (x != 62) continue;
                        }
                        position = offset + (long)idx;
                        if ("experimentDescription".equalsIgnoreCase(sb.toString())) {
                            currentId = (Integer)idStack.pop();
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": end:" + position);
                            }
                            InputStreamRange range = index.getExperimentPosition(currentId);
                            range.setToPosition(position);
                        } else if ("interactor".equalsIgnoreCase(sb.toString())) {
                            currentId = (Integer)idStack.pop();
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": end:" + position);
                            }
                            InputStreamRange range = index.getInteractorPosition(currentId);
                            range.setToPosition(position);
                        } else if ("interaction".equalsIgnoreCase(sb.toString())) {
                            currentId = (Integer)idStack.pop();
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": end:" + position);
                            }
                            InputStreamRange range = index.getInteractionPosition(currentId);
                            range.setToPosition(position);
                        } else if ("participant".equalsIgnoreCase(sb.toString())) {
                            currentId = (Integer)idStack.pop();
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": end:" + position);
                            }
                            InputStreamRange range = index.getParticipantPosition(currentId);
                            range.setToPosition(position);
                        } else if ("feature".equalsIgnoreCase(sb.toString())) {
                            currentId = (Integer)idStack.pop();
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": end:" + position);
                            }
                            InputStreamRange range = index.getFeaturePosition(currentId);
                            range.setToPosition(position);
                        }
                        recording = false;
                    } else if (x == '!') {
                        recording = false;
                        int c1 = 32;
                        int c2 = 32;
                        int c3 = 32;
                        log.debug("Skiping comment");
                        while (-1 != (read = ((Reader)r).read(c, 0, 1))) {
                            idx += read;
                            c1 = c2;
                            c2 = c3;
                            c3 = c[0];
                            if (c1 != 45 || c2 != 45 || c3 != 62) continue;
                            log.debug("End of comment");
                            break;
                        }
                    } else {
                        InputStreamRange range;
                        position = offset + (long)idx - (long)sb.length() - 2L;
                        if ("experimentDescription".equalsIgnoreCase(sb.toString())) {
                            int[] result = this.getId(r, c);
                            currentId = result[0];
                            idStack.push(currentId);
                            idx += result[1];
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": " + position);
                            }
                            range = new InputStreamRange();
                            range.setFromPosition(position);
                            index.addExperiment(currentId, range);
                        } else if ("interactor".equalsIgnoreCase(sb.toString())) {
                            int[] result = this.getId(r, c);
                            currentId = result[0];
                            idStack.push(currentId);
                            idx += result[1];
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": " + position);
                            }
                            range = new InputStreamRange();
                            range.setFromPosition(position);
                            index.addInteractor(currentId, range);
                        } else if ("interaction".equalsIgnoreCase(sb.toString())) {
                            int[] result = this.getId(r, c);
                            currentId = result[0];
                            idStack.push(currentId);
                            idx += result[1];
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": " + position);
                            }
                            range = new InputStreamRange();
                            range.setFromPosition(position);
                            index.addInteraction(currentId, range);
                        } else if ("participant".equalsIgnoreCase(sb.toString())) {
                            int[] result = this.getId(r, c);
                            currentId = result[0];
                            idStack.push(currentId);
                            idx += result[1];
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": " + position);
                            }
                            range = new InputStreamRange();
                            range.setFromPosition(position);
                            index.addParticipant(currentId, range);
                        } else if ("feature".equalsIgnoreCase(sb.toString())) {
                            int[] result = this.getId(r, c);
                            currentId = result[0];
                            idStack.push(currentId);
                            idx += result[1];
                            if (log.isDebugEnabled()) {
                                log.debug("'" + sb.toString() + "' id=" + currentId + ": " + position);
                            }
                            range = new InputStreamRange();
                            range.setFromPosition(position);
                            index.addFeature(currentId, range);
                        }
                        recording = false;
                    }
                } else {
                    sb.append(x);
                }
            }
            if (x != 60) continue;
            recording = true;
            sb = new StringBuilder(50);
        }
        long stop = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Time elapsed: " + (stop - start) + "ms");
        }
        ((Reader)r).close();
        return index;
    }

    private int[] getId(Reader r, char[] c) throws IOException {
        int read;
        int id = -1;
        int idx = 0;
        StringBuilder sb = new StringBuilder(20);
        while (-1 != (read = r.read(c, 0, 1))) {
            idx += read;
            char x = c[0];
            if (x == '>') {
                Matcher matcher = ID_PATTERN.matcher(sb.toString());
                if (!matcher.matches()) break;
                String strId = matcher.group(1);
                id = Integer.parseInt(strId);
                break;
            }
            sb.append(x);
        }
        return new int[]{id, idx};
    }

    private boolean isAlphabeticalChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }
}

