/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl254;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl254.NamesConverter;
import psidev.psi.mi.xml.converter.impl254.OpenCvTypeConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.model.CellType;
import psidev.psi.mi.xml.model.Compartment;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.HostOrganism;
import psidev.psi.mi.xml.model.Tissue;
import psidev.psi.mi.xml254.jaxb.ExperimentRefList;

public class HostOrganismConverter {
    private OpenCvTypeConverter openCvTypeConverter = new OpenCvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public HostOrganism fromJaxb(psidev.psi.mi.xml254.jaxb.HostOrganism jOrganism) throws ConverterException {
        if (jOrganism == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Organism.");
        }
        HostOrganism mOrganism = new HostOrganism();
        mOrganism.setNcbiTaxId(jOrganism.getNcbiTaxId());
        if (jOrganism.getNames() != null) {
            mOrganism.setNames(this.namesConverter.fromJaxb(jOrganism.getNames()));
        }
        if (jOrganism.getCellType() != null) {
            mOrganism.setCellType(this.openCvTypeConverter.fromJaxb(jOrganism.getCellType(), CellType.class));
        }
        if (jOrganism.getCompartment() != null) {
            mOrganism.setCompartment(this.openCvTypeConverter.fromJaxb(jOrganism.getCompartment(), Compartment.class));
        }
        if (jOrganism.getTissue() != null) {
            mOrganism.setTissue(this.openCvTypeConverter.fromJaxb(jOrganism.getTissue(), Tissue.class));
        }
        if (jOrganism.getExperimentRefList() != null) {
            for (Integer jExperimentId : jOrganism.getExperimentRefList().getExperimentReves()) {
                ExperimentDescription mExperimentDescription = this.factory.getExperimentDAO().retreive(jExperimentId);
                if (mExperimentDescription == null) {
                    mOrganism.getExperimentRefs().add(new ExperimentRef(jExperimentId));
                    continue;
                }
                mOrganism.getExperiments().add(mExperimentDescription);
            }
        }
        return mOrganism;
    }

    public psidev.psi.mi.xml254.jaxb.HostOrganism toJaxb(HostOrganism mOrganism) throws ConverterException {
        psidev.psi.mi.xml254.jaxb.HostOrganism jOrganism;
        block10: {
            block9: {
                if (mOrganism == null) {
                    throw new IllegalArgumentException("You must give a non null Organism from the model.");
                }
                this.checkDependencies();
                jOrganism = new psidev.psi.mi.xml254.jaxb.HostOrganism();
                jOrganism.setNcbiTaxId(mOrganism.getNcbiTaxId());
                if (mOrganism.hasNames()) {
                    jOrganism.setNames(this.namesConverter.toJaxb(mOrganism.getNames()));
                }
                if (mOrganism.hasCellType()) {
                    jOrganism.setCellType(this.openCvTypeConverter.toJaxb(mOrganism.getCellType()));
                }
                if (mOrganism.hasCompartment()) {
                    jOrganism.setCompartment(this.openCvTypeConverter.toJaxb(mOrganism.getCompartment()));
                }
                if (mOrganism.hasTissue()) {
                    jOrganism.setTissue(this.openCvTypeConverter.toJaxb(mOrganism.getTissue()));
                }
                if (!mOrganism.hasExperiments()) break block9;
                if (jOrganism.getExperimentRefList() == null) {
                    jOrganism.setExperimentRefList(new ExperimentRefList());
                }
                for (ExperimentDescription mExperiemnt : mOrganism.getExperiments()) {
                    jOrganism.getExperimentRefList().getExperimentReves().add(mExperiemnt.getId());
                }
                break block10;
            }
            if (!mOrganism.hasExperimentRefs()) break block10;
            if (jOrganism.getExperimentRefList() == null) {
                jOrganism.setExperimentRefList(new ExperimentRefList());
            }
            for (ExperimentRef mExperiemnt : mOrganism.getExperimentRefs()) {
                jOrganism.getExperimentRefList().getExperimentReves().add(mExperiemnt.getRef());
            }
        }
        return jOrganism;
    }
}

