/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl253;

import java.math.BigDecimal;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl253.ExperimentDescriptionConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.Parameter;
import psidev.psi.mi.xml253.jaxb.ParticipantType;

public class ParticipantParameterConverter {
    private ExperimentDescriptionConverter experimentDescriptionConverter = new ExperimentDescriptionConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.experimentDescriptionConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Parameter fromJaxb(ParticipantType.ParameterList.Parameter jParameter) throws ConverterException {
        if (jParameter == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Parameter.");
        }
        this.checkDependencies();
        Parameter mParameter = new Parameter();
        mParameter.setBase(jParameter.getBase());
        mParameter.setExponent(jParameter.getExponent());
        mParameter.setFactor(jParameter.getFactor().doubleValue());
        mParameter.setTerm(jParameter.getTerm());
        mParameter.setTermAc(jParameter.getTermAc());
        if (jParameter.getUncertainty() != null) {
            mParameter.setUncertainty(jParameter.getUncertainty());
        }
        mParameter.setUnit(jParameter.getUnit());
        mParameter.setUnitAc(jParameter.getUnitAc());
        int ref = jParameter.getExperimentRef();
        ExperimentDescription experimentDescription = this.factory.getExperimentDAO().retreive(ref);
        if (experimentDescription == null) {
            mParameter.setExperimentRef(new ExperimentRef(ref));
        } else {
            mParameter.setExperiment(experimentDescription);
        }
        return mParameter;
    }

    public ParticipantType.ParameterList.Parameter toJaxb(Parameter mParameter) throws ConverterException {
        if (mParameter == null) {
            throw new IllegalArgumentException("You must give a non null model Parameter.");
        }
        this.checkDependencies();
        ParticipantType.ParameterList.Parameter jParameter = new ParticipantType.ParameterList.Parameter();
        jParameter.setBase((short)mParameter.getBase());
        jParameter.setExponent((short)mParameter.getExponent());
        jParameter.setFactor(BigDecimal.valueOf(mParameter.getFactor()));
        jParameter.setTerm(mParameter.getTerm());
        jParameter.setTermAc(mParameter.getTermAc());
        jParameter.setUncertainty(new Double(mParameter.getUncertainty()));
        jParameter.setUnit(mParameter.getUnit());
        jParameter.setUnitAc(mParameter.getUnitAc());
        if (mParameter.hasExperiment()) {
            jParameter.setExperimentRef(mParameter.getExperiment().getId());
        } else if (mParameter.hasExperimentRef()) {
            jParameter.setExperimentRef(mParameter.getExperimentRef().getRef());
        }
        return jParameter;
    }
}

