/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.expansion;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.expansion.BinaryExpansionStrategy;
import psidev.psi.mi.tab.expansion.InteractionCategory;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixExpansion
extends BinaryExpansionStrategy {
    public static final String EXPANSION_NAME = "Matrix";
    public static final Log log = LogFactory.getLog(MatrixExpansion.class);

    @Override
    public Collection<Interaction> expand(Interaction interaction2) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        if (interaction2.getParticipants().isEmpty()) {
            return interactions;
        }
        InteractionCategory category = this.findInteractionCategory(interaction2);
        if (category == null) {
            return interactions;
        }
        if (this.isBinary(interaction2) || category.equals((Object)InteractionCategory.self_intra_molecular)) {
            log.debug("interaction " + interaction2.getId() + "/" + interaction2.getImexId() + " was binary or intra molecular, no further processing involved.");
            interactions.add(interaction2);
        }
        if (category.equals((Object)InteractionCategory.self_inter_molecular)) {
            log.debug("interaction " + interaction2.getId() + "/" + interaction2.getImexId() + " was inter molecular, reset stoichiometry of one of interactors");
            interactions.add(interaction2);
        } else {
            Participant[] participants = interaction2.getParticipants().toArray(new Participant[0]);
            log.debug(participants.length + " participant(s) found.");
            for (int i = 0; i < participants.length; ++i) {
                Participant p1 = participants[i];
                for (int j = i + 1; j < participants.length; ++j) {
                    Participant p2 = participants[j];
                    if (log.isDebugEnabled()) {
                        String p1Str = this.displayParticipant(p1);
                        String p2Str = this.displayParticipant(p2);
                        log.debug("Build new binary interaction [" + p1Str + "," + p2Str + "]");
                    }
                    Interaction newInteraction = this.buildInteraction(interaction2, p1, p2);
                    interactions.add(newInteraction);
                }
            }
            log.debug("After expansion: " + interactions.size() + " binary interaction(s) were generated.");
        }
        return interactions;
    }

    private String displayParticipant(Participant p) {
        String role = "";
        for (ExperimentalRole aRole : p.getExperimentalRoles()) {
            if (role.length() > 0) {
                role = role + "&";
            }
            if (aRole.hasNames()) {
                role = role + aRole.getNames().getShortLabel();
                continue;
            }
            role = role + "?";
        }
        String interactor = p.getInteractor().getNames().getShortLabel();
        return interactor + ":" + role;
    }

    @Override
    public String getName() {
        return EXPANSION_NAME;
    }
}

