/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.ArrayList;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class UncheckedJDOMFactory
implements JDOMFactory {
    public void addContent(Parent parent, Content child) {
        if (parent instanceof Element) {
            Element elt = (Element)parent;
            elt.content.uncheckedAddContent(child);
        } else {
            Document doc = (Document)parent;
            doc.content.uncheckedAddContent(child);
        }
    }

    public void addNamespaceDeclaration(Element parent, Namespace additional) {
        if (parent.additionalNamespaces == null) {
            parent.additionalNamespaces = new ArrayList(5);
        }
        parent.additionalNamespaces.add(additional);
    }

    public Attribute attribute(String name, String value) {
        Attribute a = new Attribute();
        a.name = name;
        a.value = value;
        a.namespace = Namespace.NO_NAMESPACE;
        return a;
    }

    public Attribute attribute(String name, String value, int type) {
        Attribute a = new Attribute();
        a.name = name;
        a.type = type;
        a.value = value;
        a.namespace = Namespace.NO_NAMESPACE;
        return a;
    }

    public Attribute attribute(String name, String value, int type, Namespace namespace2) {
        Attribute a = new Attribute();
        a.name = name;
        a.type = type;
        a.value = value;
        if (namespace2 == null) {
            namespace2 = Namespace.NO_NAMESPACE;
        }
        a.namespace = namespace2;
        return a;
    }

    public Attribute attribute(String name, String value, Namespace namespace2) {
        Attribute a = new Attribute();
        a.name = name;
        a.value = value;
        if (namespace2 == null) {
            namespace2 = Namespace.NO_NAMESPACE;
        }
        a.namespace = namespace2;
        return a;
    }

    public CDATA cdata(String str2) {
        CDATA c = new CDATA();
        c.value = str2;
        return c;
    }

    public Comment comment(String str2) {
        Comment c = new Comment();
        c.text = str2;
        return c;
    }

    public DocType docType(String elementName) {
        return this.docType(elementName, null, null);
    }

    public DocType docType(String elementName, String systemID) {
        return this.docType(elementName, null, systemID);
    }

    public DocType docType(String elementName, String publicID, String systemID) {
        DocType d = new DocType();
        d.elementName = elementName;
        d.publicID = publicID;
        d.systemID = systemID;
        return d;
    }

    public Document document(Element rootElement) {
        return this.document(rootElement, null, null);
    }

    public Document document(Element rootElement, DocType docType) {
        return this.document(rootElement, docType, null);
    }

    public Document document(Element rootElement, DocType docType, String baseURI) {
        Document d = new Document();
        if (docType != null) {
            this.addContent(d, docType);
        }
        if (rootElement != null) {
            this.addContent(d, rootElement);
        }
        if (baseURI != null) {
            d.baseURI = baseURI;
        }
        return d;
    }

    public Element element(String name) {
        Element e2 = new Element();
        e2.name = name;
        e2.namespace = Namespace.NO_NAMESPACE;
        return e2;
    }

    public Element element(String name, String uri) {
        return this.element(name, Namespace.getNamespace("", uri));
    }

    public Element element(String name, String prefix, String uri) {
        return this.element(name, Namespace.getNamespace(prefix, uri));
    }

    public Element element(String name, Namespace namespace2) {
        Element e2 = new Element();
        e2.name = name;
        if (namespace2 == null) {
            namespace2 = Namespace.NO_NAMESPACE;
        }
        e2.namespace = namespace2;
        return e2;
    }

    public EntityRef entityRef(String name) {
        EntityRef e2 = new EntityRef();
        e2.name = name;
        return e2;
    }

    public EntityRef entityRef(String name, String systemID) {
        EntityRef e2 = new EntityRef();
        e2.name = name;
        e2.systemID = systemID;
        return e2;
    }

    public EntityRef entityRef(String name, String publicID, String systemID) {
        EntityRef e2 = new EntityRef();
        e2.name = name;
        e2.publicID = publicID;
        e2.systemID = systemID;
        return e2;
    }

    public ProcessingInstruction processingInstruction(String target, String data) {
        ProcessingInstruction p = new ProcessingInstruction();
        p.target = target;
        p.setData(data);
        return p;
    }

    public ProcessingInstruction processingInstruction(String target, Map data) {
        ProcessingInstruction p = new ProcessingInstruction();
        p.target = target;
        p.setData(data);
        return p;
    }

    public void setAttribute(Element parent, Attribute a) {
        parent.attributes.uncheckedAddAttribute(a);
    }

    public Text text(String str2) {
        Text t = new Text();
        t.value = str2;
        return t;
    }
}

