/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.util;

import java.util.List;

public abstract class QuickSort {
    private List<Object> objectList;
    private Object[] objectArray;
    boolean fromList;

    public QuickSort(List<Object> objectList) {
        this.objectList = objectList;
        this.fromList = true;
    }

    public QuickSort(Object[] objectArray) {
        this.objectArray = objectArray;
        this.fromList = false;
    }

    public void quicksort() {
        int endIndex = this.fromList ? this.objectList.size() - 1 : this.objectArray.length - 1;
        if (endIndex >= 0) {
            this.quicksort(0, endIndex);
        }
    }

    public void quicksort(int lo, int hi) {
        int i = lo;
        int j = hi;
        int middleIndex = (lo + hi) / 2;
        Object middle = this.getObjectAt(middleIndex);
        while (true) {
            if (this.compare(this.getObjectAt(i), middle)) {
                ++i;
                continue;
            }
            while (this.compare(middle, this.getObjectAt(j))) {
                --j;
            }
            if (i <= j) {
                Object temp = this.getObjectAt(i);
                this.setObjectAt(i, this.getObjectAt(j));
                this.setObjectAt(j, temp);
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            this.quicksort(lo, j);
        }
        if (i < hi) {
            this.quicksort(i, hi);
        }
    }

    private Object getObjectAt(int i) {
        if (this.fromList) {
            return this.objectList.get(i);
        }
        return this.objectArray[i];
    }

    private void setObjectAt(int i, Object o) {
        if (this.fromList) {
            this.objectList.set(i, o);
        } else {
            this.objectArray[i] = o;
        }
    }

    public abstract boolean compare(Object var1, Object var2);
}

