/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.util;

public class PolyominoQuickSort {
    private int n;
    private double[] key;
    private int[] index;

    public void sort(int n, double[] key, int[] index) {
        this.n = n;
        this.key = key;
        this.index = index;
        for (int i = 0; i < this.n; ++i) {
            this.index[i] = i;
        }
        this.recSortStatic(0, this.n - 1);
        this.insertionSortStatic();
    }

    public void indexSort(int n, int[] index, double[] key) {
        int i;
        int[] tempIndex = new int[n];
        double[] tempKey = new double[n];
        int[] oldIndex = new int[n];
        for (i = 0; i < n; ++i) {
            tempKey[i] = key[index[i]];
            oldIndex[i] = index[i];
        }
        this.sort(n, tempKey, tempIndex);
        for (i = 0; i < n; ++i) {
            index[i] = oldIndex[tempIndex[i]];
        }
    }

    public void sort(int n, double[] key) {
        this.n = n;
        this.key = key;
        this.recSortNonStatic(0, this.n - 1);
        this.insertionSortNonStatic();
    }

    private void recSortStatic(int left, int right) {
        if (left + 10 > right) {
            return;
        }
        int pivot = this.median3Static(left, right);
        int i = left;
        int j = right - 1;
        while (true) {
            if (this.cmp(this.index[++i], pivot) == -1) {
                continue;
            }
            while (this.cmp(this.index[--j], pivot) == 1) {
            }
            if (i >= j) break;
            this.swapStatic(i, j);
        }
        this.swapStatic(i, right - 1);
        this.recSortStatic(left, i - 1);
        this.recSortStatic(i + 1, right);
    }

    private int median3Static(int left, int right) {
        int center = (left + right) / 2;
        if (this.cmp(this.index[left], this.index[center]) == 1) {
            this.swapStatic(left, center);
        }
        if (this.cmp(this.index[left], this.index[right]) == 1) {
            this.swapStatic(left, right);
        }
        if (this.cmp(this.index[center], this.index[right]) == 1) {
            this.swapStatic(center, right);
        }
        this.swapStatic(center, right - 1);
        return this.index[right - 1];
    }

    private int cmp(int i, int j) {
        if (this.key[i] < this.key[j]) {
            return -1;
        }
        if (this.key[i] > this.key[j]) {
            return 1;
        }
        if (i < j) {
            return -1;
        }
        if (i > j) {
            return 1;
        }
        return 0;
    }

    private void swapStatic(int i, int j) {
        int temp = this.index[i];
        this.index[i] = this.index[j];
        this.index[j] = temp;
    }

    private void insertionSortStatic() {
        for (int i = 1; i < this.n; ++i) {
            int temp = this.index[i];
            for (int j = i; j >= 1 && this.cmp(this.index[j - 1], temp) == 1; --j) {
                this.index[j] = this.index[j - 1];
            }
            this.index[j] = temp;
        }
    }

    private void recSortNonStatic(int left, int right) {
        if (left + 10 > right) {
            return;
        }
        double pivot = this.median3NonStatic(left, right);
        int i = left;
        int j = right - 1;
        while (true) {
            if (this.key[++i] < pivot) {
                continue;
            }
            while (this.key[--j] > pivot) {
            }
            if (i >= j) break;
            this.swapNonStatic(i, j);
        }
        this.swapNonStatic(i, right - 1);
        this.recSortNonStatic(left, i - 1);
        this.recSortNonStatic(i + 1, right);
    }

    private double median3NonStatic(int left, int right) {
        int center = (left + right) / 2;
        if (this.key[left] > this.key[center]) {
            this.swapNonStatic(left, center);
        }
        if (this.key[left] > this.key[right]) {
            this.swapNonStatic(left, right);
        }
        if (this.key[center] > this.key[right]) {
            this.swapNonStatic(center, right);
        }
        this.swapNonStatic(center, right - 1);
        return this.key[right - 1];
    }

    private void swapNonStatic(int i, int j) {
        double temp = this.key[i];
        this.key[i] = this.key[j];
        this.key[j] = temp;
    }

    private void insertionSortNonStatic() {
        for (int i = 1; i < this.n; ++i) {
            double temp = this.key[i];
            for (int j = i; j >= 1 && this.key[j - 1] > temp; --j) {
                this.key[j] = this.key[j - 1];
            }
            this.key[j] = temp;
        }
    }
}

