/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;

public class OR
extends ConstraintAdapter {
    MappedConst[] con;

    public OR(MappedConst ... con) {
        this.con = con;
    }

    @Override
    public boolean satisfies(Match match, int ... ind) {
        for (MappedConst mc : this.con) {
            if (!mc.satisfies(match, ind)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canGenerate() {
        for (MappedConst mc : this.con) {
            if (mc.canGenerate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getVariableSize() {
        int size = 0;
        for (MappedConst mc : this.con) {
            int m = this.max(mc.getInds());
            if (m <= size) continue;
            size = m;
        }
        return size + 1;
    }

    protected int max(int[] v) {
        int x = 0;
        for (int i : v) {
            if (i <= x) continue;
            x = i;
        }
        return x;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        HashSet<BioPAXElement> gen = new HashSet<BioPAXElement>();
        for (MappedConst mc : this.con) {
            gen.addAll(mc.generate(match, ind));
        }
        return gen;
    }
}

