/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class GSEAEntry {
    private final String name;
    private final String taxID;
    private final String idType;
    private final String description;
    private final Set<String> identifiers;

    public GSEAEntry(String name, String taxID, String idType, String description) {
        if (name == null || taxID == null || idType == null || description == null) {
            throw new IllegalArgumentException("Null paraneter (not allowed)");
        }
        this.name = name;
        this.taxID = taxID;
        this.idType = idType;
        this.description = description;
        this.identifiers = new HashSet<String>();
    }

    public String name() {
        return this.name;
    }

    public String taxID() {
        return this.taxID;
    }

    public String description() {
        return this.description;
    }

    Collection<String> getIdentifiers() {
        return this.identifiers;
    }

    public String idType() {
        return this.idType;
    }

    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        if (!this.identifiers.isEmpty()) {
            String tax = this.taxID.isEmpty() ? "unspecified" : this.taxID;
            toReturn.append(tax).append(": ").append(this.name).append("\t").append(this.description).append("; organism: ").append(tax).append("; id type: ").append(this.idType);
            for (String id : this.identifiers) {
                toReturn.append("\t").append(id);
            }
        }
        return toReturn.toString();
    }
}

