/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.impl.level3.XReferrableImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.BPCollections;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.Field;

@Entity
@Proxy(proxyClass=Xref.class)
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public abstract class XrefImpl
extends L3ElementImpl
implements Xref {
    private String db;
    private String dbVersion;
    private String idVersion;
    private String refId;
    private Set<XReferrable> xrefOf = BPCollections.I.createSafeSet();

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement other) {
        if (!(other instanceof Xref)) {
            return false;
        }
        Xref anXref = (Xref)other;
        return (this.db != null ? this.db.equalsIgnoreCase(anXref.getDb()) : anXref.getDb() == null) && (this.refId != null ? this.refId.equals(anXref.getId()) : anXref.getId() == null) && (this.dbVersion != null ? this.dbVersion.equalsIgnoreCase(anXref.getDbVersion()) : anXref.getDbVersion() == null) && (this.idVersion != null ? this.idVersion.equals(anXref.getIdVersion()) : anXref.getIdVersion() == null);
    }

    @Override
    public int equivalenceCode() {
        int result = 29 + (this.db != null ? this.db.hashCode() : 0);
        result = 29 * result + (this.dbVersion != null ? this.dbVersion.hashCode() : 0);
        result = 29 * result + (this.idVersion != null ? this.idVersion.hashCode() : 0);
        result = 29 * result + (this.refId != null ? this.refId.hashCode() : 0);
        return result;
    }

    @Override
    @Field(name="xrefdb", analyze=Analyze.YES)
    public String getDb() {
        return this.db;
    }

    @Override
    public void setDb(String db) {
        this.db = db;
    }

    @Override
    public String getDbVersion() {
        return this.dbVersion;
    }

    @Override
    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    @Override
    public String getIdVersion() {
        return this.idVersion;
    }

    @Override
    public void setIdVersion(String idVersion) {
        this.idVersion = idVersion;
    }

    @Field(name="xrefid", analyze=Analyze.YES)
    @Boost(value=1.1f)
    @Column(name="id")
    public String getIdx() {
        return this.refId;
    }

    public void setIdx(String id) {
        this.refId = id;
    }

    @Override
    @Transient
    public String getId() {
        return this.refId;
    }

    @Override
    public void setId(String id) {
        this.refId = id;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=XReferrableImpl.class, mappedBy="xref")
    public Set<XReferrable> getXrefOf() {
        return this.xrefOf;
    }

    protected void setXrefOf(Set<XReferrable> xrefOf) {
        this.xrefOf = xrefOf;
    }

    @Override
    public String toString() {
        return this.getDb() + (this.getDbVersion() == null ? "" : "." + this.getDbVersion()) + ":" + this.getId() + (this.getIdVersion() == null ? "" : "." + this.getIdVersion());
    }
}

