/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=Stoichiometry.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class StoichiometryImpl
extends L3ElementImpl
implements Stoichiometry {
    private float stoichiometricCoefficient = UNKNOWN_FLOAT.floatValue();
    private PhysicalEntity physicalEntity;

    @Transient
    public Class<? extends Stoichiometry> getModelInterface() {
        return Stoichiometry.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        Stoichiometry that;
        boolean value = false;
        if (element instanceof Stoichiometry && (that = (Stoichiometry)element).getPhysicalEntity() != null && this.getPhysicalEntity() != null) {
            value = that.getStoichiometricCoefficient() == this.getStoichiometricCoefficient() && that.getPhysicalEntity().equals(this.getPhysicalEntity());
        }
        return value;
    }

    @Override
    public int equivalenceCode() {
        return (int)this.getStoichiometricCoefficient() + (this.getPhysicalEntity() != null ? 31 * this.getPhysicalEntity().hashCode() : 0);
    }

    @Override
    @ManyToOne(targetEntity=PhysicalEntityImpl.class)
    public PhysicalEntity getPhysicalEntity() {
        return this.physicalEntity;
    }

    @Override
    public void setPhysicalEntity(PhysicalEntity PhysicalEntity2) {
        this.physicalEntity = PhysicalEntity2;
    }

    @Override
    public float getStoichiometricCoefficient() {
        return this.stoichiometricCoefficient;
    }

    @Override
    public void setStoichiometricCoefficient(float newStoichiometricCoefficient) {
        this.stoichiometricCoefficient = newStoichiometricCoefficient;
    }
}

