/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.text.CharacterIterator;

public class BMPattern {
    char[] pattern;
    int[] shiftTable;
    boolean ignoreCase;

    public BMPattern(String string, boolean bl) {
        this(string, 256, bl);
    }

    public BMPattern(String string, int n, boolean bl) {
        this.pattern = string.toCharArray();
        this.shiftTable = new int[n];
        this.ignoreCase = bl;
        int n2 = this.pattern.length;
        int n4 = 0;
        while (n4 < this.shiftTable.length) {
            this.shiftTable[n4] = n2;
            ++n4;
        }
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n2 - n5 - 1;
            char c = this.pattern[n5];
            int n7 = c % this.shiftTable.length;
            if (n6 < this.shiftTable[n7]) {
                this.shiftTable[n7] = n6;
            }
            if (this.ignoreCase) {
                n7 = (c = Character.toUpperCase(c)) % this.shiftTable.length;
                if (n6 < this.shiftTable[n7]) {
                    this.shiftTable[n7] = n6;
                }
                if (n6 < this.shiftTable[n7 = (c = Character.toLowerCase(c)) % this.shiftTable.length]) {
                    this.shiftTable[n7] = n6;
                }
            }
            ++n5;
        }
    }

    public int matches(CharacterIterator characterIterator, int n, int n2) {
        if (this.ignoreCase) {
            return this.matchesIgnoreCase(characterIterator, n, n2);
        }
        int n4 = this.pattern.length;
        if (n4 == 0) {
            return n;
        }
        int n5 = n + n4;
        while (n5 <= n2) {
            char c;
            int n6 = n4;
            int n7 = n5 + 1;
            while ((c = characterIterator.setIndex(--n5)) == this.pattern[--n6]) {
                if (n6 == 0) {
                    return n5;
                }
                if (n6 > 0) continue;
            }
            if ((n5 += this.shiftTable[c % this.shiftTable.length] + 1) >= n7) continue;
            n5 = n7;
        }
        return -1;
    }

    public int matches(String string, int n, int n2) {
        if (this.ignoreCase) {
            return this.matchesIgnoreCase(string, n, n2);
        }
        int n4 = this.pattern.length;
        if (n4 == 0) {
            return n;
        }
        int n5 = n + n4;
        while (n5 <= n2) {
            char c;
            int n6 = n4;
            int n7 = n5 + 1;
            while ((c = string.charAt(--n5)) == this.pattern[--n6]) {
                if (n6 == 0) {
                    return n5;
                }
                if (n6 > 0) continue;
            }
            if ((n5 += this.shiftTable[c % this.shiftTable.length] + 1) >= n7) continue;
            n5 = n7;
        }
        return -1;
    }

    public int matches(char[] cArray, int n, int n2) {
        if (this.ignoreCase) {
            return this.matchesIgnoreCase(cArray, n, n2);
        }
        int n4 = this.pattern.length;
        if (n4 == 0) {
            return n;
        }
        int n5 = n + n4;
        while (n5 <= n2) {
            char c;
            int n6 = n4;
            int n7 = n5 + 1;
            while ((c = cArray[--n5]) == this.pattern[--n6]) {
                if (n6 == 0) {
                    return n5;
                }
                if (n6 > 0) continue;
            }
            if ((n5 += this.shiftTable[c % this.shiftTable.length] + 1) >= n7) continue;
            n5 = n7;
        }
        return -1;
    }

    int matchesIgnoreCase(CharacterIterator characterIterator, int n, int n2) {
        int n4 = this.pattern.length;
        if (n4 == 0) {
            return n;
        }
        int n5 = n + n4;
        while (n5 <= n2) {
            char c;
            char c2;
            char c3;
            int n6 = n4;
            int n7 = n5 + 1;
            while ((c3 = (c2 = characterIterator.setIndex(--n5))) == (c = this.pattern[--n6]) || (c3 = Character.toUpperCase(c3)) == (c = Character.toUpperCase(c)) || Character.toLowerCase(c3) == Character.toLowerCase(c)) {
                if (n6 == 0) {
                    return n5;
                }
                if (n6 > 0) continue;
            }
            if ((n5 += this.shiftTable[c2 % this.shiftTable.length] + 1) >= n7) continue;
            n5 = n7;
        }
        return -1;
    }

    int matchesIgnoreCase(String string, int n, int n2) {
        int n4 = this.pattern.length;
        if (n4 == 0) {
            return n;
        }
        int n5 = n + n4;
        while (n5 <= n2) {
            char c;
            char c2;
            char c3;
            int n6 = n4;
            int n7 = n5 + 1;
            while ((c3 = (c2 = string.charAt(--n5))) == (c = this.pattern[--n6]) || (c3 = Character.toUpperCase(c3)) == (c = Character.toUpperCase(c)) || Character.toLowerCase(c3) == Character.toLowerCase(c)) {
                if (n6 == 0) {
                    return n5;
                }
                if (n6 > 0) continue;
            }
            if ((n5 += this.shiftTable[c2 % this.shiftTable.length] + 1) >= n7) continue;
            n5 = n7;
        }
        return -1;
    }

    int matchesIgnoreCase(char[] cArray, int n, int n2) {
        int n4 = this.pattern.length;
        if (n4 == 0) {
            return n;
        }
        int n5 = n + n4;
        while (n5 <= n2) {
            char c;
            char c2;
            char c3;
            int n6 = n4;
            int n7 = n5 + 1;
            while ((c3 = (c2 = cArray[--n5])) == (c = this.pattern[--n6]) || (c3 = Character.toUpperCase(c3)) == (c = Character.toUpperCase(c)) || Character.toLowerCase(c3) == Character.toLowerCase(c)) {
                if (n6 == 0) {
                    return n5;
                }
                if (n6 > 0) continue;
            }
            if ((n5 += this.shiftTable[c2 % this.shiftTable.length] + 1) >= n7) continue;
            n5 = n7;
        }
        return -1;
    }
}

