/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryIndexReader;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockObtainFailedException;

public abstract class IndexReader {
    private boolean closed;
    protected boolean hasChanges;
    private volatile int refCount = 1;
    private Directory directory;
    static final /* synthetic */ boolean $assertionsDisabled;

    synchronized int getRefCount() {
        return this.refCount;
    }

    protected synchronized void incRef() {
        if (!$assertionsDisabled && this.refCount <= 0) {
            throw new AssertionError();
        }
        ++this.refCount;
    }

    protected synchronized void decRef() throws IOException {
        if (!$assertionsDisabled && this.refCount <= 0) {
            throw new AssertionError();
        }
        if (this.refCount == 1) {
            this.commit();
            this.doClose();
        }
        --this.refCount;
    }

    protected IndexReader(Directory directory) {
        this();
        this.directory = directory;
    }

    protected IndexReader() {
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.refCount <= 0) {
            throw new AlreadyClosedException("this IndexReader is closed");
        }
    }

    public static IndexReader open(String path) throws CorruptIndexException, IOException {
        return IndexReader.open(FSDirectory.getDirectory(path), true, null);
    }

    public static IndexReader open(File path) throws CorruptIndexException, IOException {
        return IndexReader.open(FSDirectory.getDirectory(path), true, null);
    }

    public static IndexReader open(Directory directory) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, false, null);
    }

    public static IndexReader open(Directory directory, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, false, deletionPolicy);
    }

    private static IndexReader open(Directory directory, boolean closeDirectory, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, IOException {
        return DirectoryIndexReader.open(directory, closeDirectory, deletionPolicy);
    }

    public synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen().");
    }

    public Directory directory() {
        this.ensureOpen();
        if (null != this.directory) {
            return this.directory;
        }
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public static long lastModified(String directory) throws CorruptIndexException, IOException {
        return IndexReader.lastModified(new File(directory));
    }

    public static long lastModified(File fileDirectory) throws CorruptIndexException, IOException {
        return (Long)new SegmentInfos.FindSegmentsFile(fileDirectory){

            public Object doBody(String segmentFileName) {
                return new Long(FSDirectory.fileModified(this.fileDirectory, segmentFileName));
            }
        }.run();
    }

    public static long lastModified(final Directory directory2) throws CorruptIndexException, IOException {
        return (Long)new SegmentInfos.FindSegmentsFile(directory2){

            public Object doBody(String segmentFileName) throws IOException {
                return new Long(directory2.fileModified(segmentFileName));
            }
        }.run();
    }

    public static long getCurrentVersion(String directory) throws CorruptIndexException, IOException {
        return IndexReader.getCurrentVersion(new File(directory));
    }

    public static long getCurrentVersion(File directory) throws CorruptIndexException, IOException {
        FSDirectory dir = FSDirectory.getDirectory(directory);
        long version2 = IndexReader.getCurrentVersion(dir);
        ((Directory)dir).close();
        return version2;
    }

    public static long getCurrentVersion(Directory directory) throws CorruptIndexException, IOException {
        return SegmentInfos.readCurrentVersion(directory);
    }

    public long getVersion() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public void setTermInfosIndexDivisor(int indexDivisor) throws IllegalStateException {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public int getTermInfosIndexDivisor() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public boolean isOptimized() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public abstract TermFreqVector[] getTermFreqVectors(int var1) throws IOException;

    public abstract TermFreqVector getTermFreqVector(int var1, String var2) throws IOException;

    public abstract void getTermFreqVector(int var1, String var2, TermVectorMapper var3) throws IOException;

    public abstract void getTermFreqVector(int var1, TermVectorMapper var2) throws IOException;

    public static boolean indexExists(String directory) {
        return IndexReader.indexExists(new File(directory));
    }

    public static boolean indexExists(File directory) {
        return SegmentInfos.getCurrentSegmentGeneration(directory.list()) != -1L;
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return SegmentInfos.getCurrentSegmentGeneration(directory) != -1L;
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public Document document(int n) throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.document(n, null);
    }

    public abstract Document document(int var1, FieldSelector var2) throws CorruptIndexException, IOException;

    public abstract boolean isDeleted(int var1);

    public abstract boolean hasDeletions();

    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        return this.norms(field) != null;
    }

    public abstract byte[] norms(String var1) throws IOException;

    public abstract void norms(String var1, byte[] var2, int var3) throws IOException;

    public final synchronized void setNorm(int doc, String field, byte value) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doSetNorm(doc, field, value);
    }

    protected abstract void doSetNorm(int var1, String var2, byte var3) throws CorruptIndexException, IOException;

    public void setNorm(int doc, String field, float value) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.setNorm(doc, field, Similarity.encodeNorm(value));
    }

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    public final synchronized void deleteDocument(int docNum) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doDelete(docNum);
    }

    protected abstract void doDelete(int var1) throws CorruptIndexException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deleteDocuments(Term term) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        TermDocs docs = this.termDocs(term);
        if (docs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (docs.next()) {
                this.deleteDocument(docs.doc());
                ++n;
            }
        }
        finally {
            docs.close();
        }
        return n;
    }

    public final synchronized void undeleteAll() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doUndeleteAll();
    }

    protected abstract void doUndeleteAll() throws CorruptIndexException, IOException;

    protected synchronized void acquireWriteLock() throws IOException {
    }

    public final synchronized void flush() throws IOException {
        this.ensureOpen();
        this.commit();
    }

    protected final synchronized void commit() throws IOException {
        if (this.hasChanges) {
            this.doCommit();
        }
        this.hasChanges = false;
    }

    protected abstract void doCommit() throws IOException;

    public final synchronized void close() throws IOException {
        if (!this.closed) {
            this.decRef();
            this.closed = true;
        }
    }

    protected abstract void doClose() throws IOException;

    public abstract Collection getFieldNames(FieldOption var1);

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock("write.lock").isLocked();
    }

    public static boolean isLocked(String directory) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(directory);
        boolean result = IndexReader.isLocked(dir);
        ((Directory)dir).close();
        return result;
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock("write.lock").release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String filename = null;
        boolean extract = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-extract")) {
                extract = true;
                continue;
            }
            if (filename != null) continue;
            filename = args[i];
        }
        if (filename == null) {
            System.out.println("Usage: org.apache.lucene.index.IndexReader [-extract] <cfsfile>");
            return;
        }
        Directory dir = null;
        CompoundFileReader cfr = null;
        try {
            File file = new File(filename);
            String dirname = file.getAbsoluteFile().getParent();
            filename = file.getName();
            dir = FSDirectory.getDirectory(dirname);
            cfr = new CompoundFileReader(dir, filename);
            Object[] files = cfr.list();
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                long len;
                if (extract) {
                    int bufLen;
                    System.out.println("extract " + (String)files[i] + " with " + len + " bytes to local directory...");
                    IndexInput ii = cfr.openInput((String)files[i]);
                    FileOutputStream f = new FileOutputStream((String)files[i]);
                    byte[] buffer = new byte[1024];
                    int chunk = buffer.length;
                    for (len = cfr.fileLength((String)files[i]); len > 0L; len -= (long)bufLen) {
                        bufLen = (int)Math.min((long)chunk, len);
                        ii.readBytes(buffer, 0, bufLen);
                        f.write(buffer, 0, bufLen);
                    }
                    f.close();
                    ii.close();
                    continue;
                }
                System.out.println((String)files[i] + ": " + len + " bytes");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (dir != null) {
                    dir.close();
                }
                if (cfr != null) {
                    cfr.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    static {
        $assertionsDisabled = !IndexReader.class.desiredAssertionStatus();
    }

    public static final class FieldOption {
        private String option;
        public static final FieldOption ALL = new FieldOption("ALL");
        public static final FieldOption INDEXED = new FieldOption("INDEXED");
        public static final FieldOption STORES_PAYLOADS = new FieldOption("STORES_PAYLOADS");
        public static final FieldOption UNINDEXED = new FieldOption("UNINDEXED");
        public static final FieldOption INDEXED_WITH_TERMVECTOR = new FieldOption("INDEXED_WITH_TERMVECTOR");
        public static final FieldOption INDEXED_NO_TERMVECTOR = new FieldOption("INDEXED_NO_TERMVECTOR");
        public static final FieldOption TERMVECTOR = new FieldOption("TERMVECTOR");
        public static final FieldOption TERMVECTOR_WITH_POSITION = new FieldOption("TERMVECTOR_WITH_POSITION");
        public static final FieldOption TERMVECTOR_WITH_OFFSET = new FieldOption("TERMVECTOR_WITH_OFFSET");
        public static final FieldOption TERMVECTOR_WITH_POSITION_OFFSET = new FieldOption("TERMVECTOR_WITH_POSITION_OFFSET");

        private FieldOption() {
        }

        private FieldOption(String option) {
            this.option = option;
        }

        public String toString() {
            return this.option;
        }
    }
}

