/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.execchain.ConnectionHolder;
import org.apache.http.impl.execchain.RequestEntityExecHandler;
import org.apache.http.impl.execchain.ResponseProxyHandler;

@NotThreadSafe
class Proxies {
    Proxies() {
    }

    static void enhanceEntity(HttpEntityEnclosingRequest request) {
        HttpEntity entity2 = request.getEntity();
        if (entity2 != null && !entity2.isRepeatable() && !Proxies.isEnhanced(entity2)) {
            HttpEntity proxy = (HttpEntity)Proxy.newProxyInstance(HttpEntity.class.getClassLoader(), new Class[]{HttpEntity.class}, (InvocationHandler)new RequestEntityExecHandler(entity2));
            request.setEntity(proxy);
        }
    }

    static boolean isEnhanced(HttpEntity entity2) {
        if (entity2 != null && Proxy.isProxyClass(entity2.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(entity2);
            return handler instanceof RequestEntityExecHandler;
        }
        return false;
    }

    static boolean isRepeatable(HttpRequest request) {
        HttpEntity entity2;
        if (request instanceof HttpEntityEnclosingRequest && (entity2 = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            RequestEntityExecHandler handler;
            if (Proxies.isEnhanced(entity2) && !(handler = (RequestEntityExecHandler)Proxy.getInvocationHandler(entity2)).isConsumed()) {
                return true;
            }
            return entity2.isRepeatable();
        }
        return true;
    }

    public static CloseableHttpResponse enhanceResponse(HttpResponse original, ConnectionHolder connHolder) {
        return (CloseableHttpResponse)Proxy.newProxyInstance(ResponseProxyHandler.class.getClassLoader(), new Class[]{CloseableHttpResponse.class}, (InvocationHandler)new ResponseProxyHandler(original, connHolder));
    }
}

