/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMConverter {
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    private DOMConverter() {
    }

    public static Document convert(org.w3c.dom.Document domDocument) {
        org.w3c.dom.Element domRoot = domDocument.getDocumentElement();
        Element xomRoot = DOMConverter.convert(domRoot);
        Document xomDocument = new Document(xomRoot);
        org.w3c.dom.Node current = domDocument.getFirstChild();
        int position = 0;
        while (current.getNodeType() != 1) {
            xomDocument.insertChild(DOMConverter.convert(current), position);
            ++position;
            current = current.getNextSibling();
        }
        for (current = current.getNextSibling(); current != null; current = current.getNextSibling()) {
            xomDocument.appendChild(DOMConverter.convert(current));
        }
        return xomDocument;
    }

    public static Nodes convert(DocumentFragment fragment) {
        Nodes result = new Nodes();
        NodeList children = fragment.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            result.append(DOMConverter.convert(children.item(i)));
        }
        return result;
    }

    private static Node convert(org.w3c.dom.Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                return DOMConverter.convert((org.w3c.dom.Element)node);
            }
            case 8: {
                return DOMConverter.convert((org.w3c.dom.Comment)node);
            }
            case 10: {
                return DOMConverter.convert((DocumentType)node);
            }
            case 3: {
                return DOMConverter.convert((org.w3c.dom.Text)node);
            }
            case 4: {
                return DOMConverter.convert((org.w3c.dom.Text)node);
            }
            case 7: {
                return DOMConverter.convert((org.w3c.dom.ProcessingInstruction)node);
            }
        }
        throw new XMLException("Unexpected DOM node type: " + type);
    }

    public static Comment convert(org.w3c.dom.Comment comment) {
        return new Comment(comment.getNodeValue());
    }

    public static Text convert(org.w3c.dom.Text text) {
        return new Text(text.getNodeValue());
    }

    public static Attribute convert(Attr attribute) {
        String name = attribute.getName();
        String uri = attribute.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        return new Attribute(name, uri, attribute.getNodeValue());
    }

    public static ProcessingInstruction convert(org.w3c.dom.ProcessingInstruction pi2) {
        return new ProcessingInstruction(pi2.getTarget(), pi2.getNodeValue());
    }

    public static DocType convert(DocumentType doctype) {
        DocType result = new DocType(doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
        result.setInternalDTDSubset(doctype.getInternalSubset());
        return result;
    }

    public static Element convert(org.w3c.dom.Element element) {
        Element result;
        org.w3c.dom.Node current = element;
        Node parent = result = DOMConverter.makeElement(element);
        boolean backtracking = false;
        while (true) {
            Node child;
            if (current.hasChildNodes() && !backtracking) {
                current = current.getFirstChild();
                backtracking = false;
            } else {
                if (current == element) break;
                if (current.getNextSibling() != null) {
                    current = current.getNextSibling();
                    backtracking = false;
                } else {
                    current = current.getParentNode();
                    backtracking = true;
                    parent = parent.getParent();
                    continue;
                }
            }
            short type = current.getNodeType();
            if (type == 1) {
                child = DOMConverter.makeElement((org.w3c.dom.Element)current);
                parent.appendChild(child);
                if (!current.hasChildNodes()) continue;
                parent = child;
                continue;
            }
            child = DOMConverter.convert(current);
            parent.appendChild(child);
        }
        return result;
    }

    private static Element makeElement(org.w3c.dom.Element element) {
        String namespaceURI = element.getNamespaceURI();
        String tagName = element.getTagName();
        Element result = new Element(tagName, namespaceURI);
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getName();
            String uri = attribute.getNamespaceURI();
            String value = attribute.getValue();
            if (uri == null) {
                uri = "";
            }
            if (uri.equals(XMLNS_NAMESPACE)) {
                String prefix;
                String currentURI;
                if (name.equals("xmlns") || value.equals(currentURI = result.getNamespaceURI(prefix = name.substring(name.indexOf(58) + 1)))) continue;
                result.addNamespaceDeclaration(prefix, value);
                continue;
            }
            result.addAttribute(new Attribute(name, uri, value));
        }
        return result;
    }

    public static org.w3c.dom.Document convert(Document document, DOMImplementation impl) {
        Element root = document.getRootElement();
        String rootName = root.getQualifiedName();
        String rootNamespace = root.getNamespaceURI();
        DocType doctype = document.getDocType();
        DocumentType domDOCTYPE = null;
        if (doctype != null) {
            domDOCTYPE = impl.createDocumentType(rootName, doctype.getPublicID(), doctype.getSystemID());
        }
        org.w3c.dom.Document domDoc = impl.createDocument(rootNamespace, rootName, domDOCTYPE);
        org.w3c.dom.Element domRoot = domDoc.getDocumentElement();
        boolean beforeRoot = true;
        for (int i = 0; i < document.getChildCount(); ++i) {
            Node original = document.getChild(i);
            if (original instanceof DocType) continue;
            if (original instanceof Element) {
                DOMConverter.convert((Element)original, domDoc);
                beforeRoot = false;
                continue;
            }
            org.w3c.dom.Node domNode = DOMConverter.convert(original, domDoc);
            if (beforeRoot) {
                domDoc.insertBefore(domNode, domRoot);
                continue;
            }
            domDoc.appendChild(domNode);
        }
        return domDoc;
    }

    private static org.w3c.dom.Node convert(Node node, org.w3c.dom.Document document) {
        if (node instanceof Text) {
            return DOMConverter.convert((Text)node, document);
        }
        if (node instanceof Comment) {
            return DOMConverter.convert((Comment)node, document);
        }
        if (node instanceof ProcessingInstruction) {
            return DOMConverter.convert((ProcessingInstruction)node, document);
        }
        throw new XMLException("Unexpected node type: " + node.getClass().getName());
    }

    private static org.w3c.dom.Comment convert(Comment comment, org.w3c.dom.Document document) {
        return document.createComment(comment.getValue());
    }

    private static org.w3c.dom.Text convert(Text text, org.w3c.dom.Document document) {
        return document.createTextNode(text.getValue());
    }

    private static org.w3c.dom.ProcessingInstruction convert(ProcessingInstruction pi2, org.w3c.dom.Document document) {
        return document.createProcessingInstruction(pi2.getTarget(), pi2.getValue());
    }

    private static org.w3c.dom.Element convert(Element xomElement, org.w3c.dom.Document document) {
        org.w3c.dom.Element domResult = DOMConverter.makeElement(xomElement, document);
        org.w3c.dom.Node domParent = domResult;
        Node xomCurrent = xomElement;
        int index = 0;
        int[] indexes = new int[10];
        int top = 0;
        indexes[0] = 0;
        boolean end = false;
        while (true) {
            if (!end && xomCurrent.getChildCount() > 0) {
                xomCurrent = xomCurrent.getChild(0);
                index = 0;
                indexes = DOMConverter.grow(indexes, ++top);
                indexes[top] = 0;
            } else {
                end = false;
                ParentNode xomParent = xomCurrent.getParent();
                org.w3c.dom.Node grandparent = domParent.getParentNode();
                if (grandparent.getNodeType() == 1 && xomCurrent instanceof Element) {
                    domParent = grandparent;
                }
                if (xomParent.getChildCount() - 1 == index) {
                    ParentNode tp;
                    xomCurrent = xomParent;
                    --top;
                    if (xomCurrent == xomElement || (tp = xomCurrent.getParent()) == null) break;
                    index = indexes[top];
                    end = true;
                    continue;
                }
                indexes[top] = ++index;
                xomCurrent = xomParent.getChild(index);
            }
            if (xomCurrent instanceof Element) {
                Node currentElement = xomCurrent;
                org.w3c.dom.Element child = DOMConverter.makeElement((Element)currentElement, document);
                domParent.appendChild(child);
                domParent = child;
                continue;
            }
            org.w3c.dom.Node child = DOMConverter.convert(xomCurrent, document);
            domParent.appendChild(child);
        }
        return domResult;
    }

    private static int[] grow(int[] indexes, int top) {
        if (top < indexes.length) {
            return indexes;
        }
        int[] result = new int[indexes.length * 2];
        System.arraycopy(indexes, 0, result, 0, indexes.length);
        return result;
    }

    private static org.w3c.dom.Element makeElement(Element element, org.w3c.dom.Document document) {
        String namespace2 = element.getNamespaceURI();
        org.w3c.dom.Element result = element.getParent() instanceof Document ? document.getDocumentElement() : (namespace2.equals("") ? document.createElement(element.getQualifiedName()) : document.createElementNS(namespace2, element.getQualifiedName()));
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attr attr;
            Attribute attribute = element.getAttribute(i);
            String attns = attribute.getNamespaceURI();
            if (attns.equals("")) {
                attr = document.createAttribute(attribute.getLocalName());
                result.setAttributeNode(attr);
            } else {
                attr = document.createAttributeNS(attns, attribute.getQualifiedName());
                result.setAttributeNodeNS(attr);
            }
            attr.setValue(attribute.getValue());
        }
        int namespaceCount = element.getNamespaceDeclarationCount();
        for (int i = 0; i < namespaceCount; ++i) {
            Attr attr;
            Element parentElement;
            String additionalPrefix = element.getNamespacePrefix(i);
            String uri = element.getNamespaceURI(additionalPrefix);
            ParentNode parentNode = element.getParent();
            if (!(parentNode instanceof Element) ? uri.equals("") : uri.equals((parentElement = (Element)parentNode).getNamespaceURI(additionalPrefix))) continue;
            if ("".equals(additionalPrefix)) {
                attr = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns");
                result.setAttributeNodeNS(attr);
                attr.setValue(uri);
                continue;
            }
            attr = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns:" + additionalPrefix);
            result.setAttributeNodeNS(attr);
            attr.setValue(uri);
        }
        return result;
    }
}

