/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class RangeVariableDeclaration
implements VariableDeclaration {
    private int nameCode;
    private SequenceType requiredType;
    private String variableName;
    private List references = new ArrayList(5);
    public static final int FILTERED = 10000;

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public void setReferenceList(List list) {
        this.references = list;
    }

    public List getReferenceList() {
        return this.references;
    }

    public int getReferenceCount(Binding binding, StaticContext staticContext) {
        return RangeVariableDeclaration.getReferenceCount(this.references, binding, staticContext, true);
    }

    public static int getReferenceCount(List list, Binding binding, StaticContext staticContext, boolean bl) {
        int n;
        if (bl) {
            for (n = list.size() - 1; n >= 0; --n) {
                if (((VariableReference)list.get(n)).getBinding() != null) continue;
                list.remove(n);
            }
        }
        n = 0;
        block1: for (int i = list.size() - 1; i >= 0; --i) {
            BindingReference bindingReference = (BindingReference)list.get(i);
            if (bindingReference instanceof VariableReference) {
                VariableReference variableReference = (VariableReference)bindingReference;
                ComputedExpression computedExpression = variableReference;
                Container container2 = variableReference.getParentExpression();
                boolean bl2 = container2 instanceof FilterExpression && computedExpression == ((FilterExpression)container2).getBaseExpression();
                int n2 = 0;
                while (container2 instanceof ComputedExpression) {
                    if (container2 == binding) {
                        ++n;
                        continue block1;
                    }
                    if (bl2 && container2 instanceof FilterExpression && computedExpression == ((FilterExpression)container2).getBaseExpression()) {
                        return 10000;
                    }
                    if (ExpressionTool.isRepeatedSubexpression((ComputedExpression)container2, computedExpression, staticContext)) {
                        n += 10;
                        continue block1;
                    }
                    computedExpression = (ComputedExpression)container2;
                    if ((container2 = computedExpression.getParentExpression()) == null) {
                        n += 10;
                        continue block1;
                    }
                    if (n2++ <= 10000) continue;
                    throw new IllegalStateException("The expression tree appears to contain a cycle");
                }
                if (container2 instanceof UserFunction) {
                    UserFunctionParameter[] userFunctionParameterArray = ((UserFunction)container2).getParameterDefinitions();
                    for (int j = 0; j < userFunctionParameterArray.length; ++j) {
                        if (userFunctionParameterArray[j] != binding) continue;
                        int n4 = userFunctionParameterArray[j].getReferenceCount();
                        n += n4;
                    }
                    n += 10;
                    continue;
                }
                n += 10;
                continue;
            }
            ++n;
        }
        return n;
    }

    public void fixupReferences(Binding binding) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            BindingReference bindingReference = (BindingReference)iterator.next();
            bindingReference.setStaticType(this.requiredType, null, 0);
            bindingReference.fixup(binding);
        }
    }

    public void refineTypeInformation(ItemType itemType, int n, Value value, int n2, StaticContext staticContext) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            int n4;
            ItemType itemType2;
            BindingReference bindingReference = (BindingReference)iterator.next();
            if (!(bindingReference instanceof VariableReference)) continue;
            TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
            ItemType itemType3 = itemType2 = ((VariableReference)bindingReference).getItemType(typeHierarchy);
            if (staticContext.getNamePool().getTypeHierarchy().isSubType(itemType, itemType2)) {
                itemType3 = itemType;
            }
            if ((n4 = n & ((VariableReference)bindingReference).getCardinality()) == 0) {
                n4 = ((VariableReference)bindingReference).getCardinality();
            }
            SequenceType sequenceType = SequenceType.makeSequenceType(itemType3, n4);
            bindingReference.setStaticType(sequenceType, value, n2);
        }
    }
}

