/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.core.GraphEdge;
import com.hp.hpl.jena.sparql.engine.optimizer.core.GraphNode;
import com.hp.hpl.jena.sparql.engine.optimizer.core.PrimeNumberGen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectedGraph {
    private PrimeNumberGen prime = new PrimeNumberGen();
    private int OID = 1;
    private int MIN_OID = this.prime.first();
    private Set optGraphNodeList = new LinkedHashSet();
    private Set optGraphEdgeList = new LinkedHashSet();
    private Map nodes = new TreeMap();
    private Map edges = new TreeMap();
    private Map nodesInvertedIndex = new HashMap();
    private static Log log = LogFactory.getLog(ConnectedGraph.class);

    public BasicPattern optimize() {
        BasicPattern pattern = new BasicPattern();
        this.optGraphNodeList = this.getOptimizedNodeList();
        Iterator iter = this.optGraphNodeList.iterator();
        while (iter.hasNext()) {
            GraphNode node = (GraphNode)iter.next();
            pattern.add(node.triple());
        }
        return pattern;
    }

    public GraphNode createNode(Triple triple, double weight) {
        int oid = this.nextOID();
        GraphNode node = new GraphNode(oid, triple, weight);
        this.nodesInvertedIndex.put(triple, new Integer(oid));
        this.nodes.put(new Integer(oid), node);
        return node;
    }

    public GraphEdge createEdge(GraphNode node1, GraphNode node2, double weight) {
        int oid = node1.oid() * node2.oid();
        GraphEdge edge = new GraphEdge(oid, node1, node2, weight);
        this.edges.put(new Integer(oid), edge);
        return edge;
    }

    public GraphNode getNodeByOID(Integer oid) {
        if (!this.nodes.containsKey(oid)) {
            log.fatal("GraphNode not found: " + oid);
        }
        return (GraphNode)this.nodes.get(oid);
    }

    public GraphEdge getEdgeByOID(Integer oid) {
        if (!this.edges.containsKey(oid)) {
            log.fatal("GraphEdge not found: " + oid);
        }
        return (GraphEdge)this.edges.get(oid);
    }

    public GraphNode getNodeByTriple(Triple triple) {
        Integer oid = (Integer)this.nodesInvertedIndex.get(triple);
        if (!this.nodes.containsKey(oid)) {
            log.fatal("GraphNode not found: " + oid);
        }
        return (GraphNode)this.nodes.get(oid);
    }

    public GraphEdge getEdgeByTriples(Triple triple1, Triple triple2) {
        GraphNode node1 = this.getNodeByTriple(triple1);
        GraphNode node2 = this.getNodeByTriple(triple2);
        int oid = node1.oid() * node2.oid();
        if (!this.edges.containsKey(new Integer(oid))) {
            log.fatal("GraphEdge not found: " + oid);
        }
        return (GraphEdge)this.edges.get(new Integer(oid));
    }

    public List getNodes() {
        ArrayList<GraphNode> list = new ArrayList<GraphNode>();
        Iterator iter = this.nodes.values().iterator();
        while (iter.hasNext()) {
            list.add((GraphNode)iter.next());
        }
        return list;
    }

    public List getEdges() {
        ArrayList<GraphEdge> list = new ArrayList<GraphEdge>();
        Iterator iter = this.edges.values().iterator();
        while (iter.hasNext()) {
            list.add((GraphEdge)iter.next());
        }
        return list;
    }

    public Set getOptGraphNodeList() {
        return this.optGraphNodeList;
    }

    public Set getOptGraphEdgeList() {
        return this.optGraphEdgeList;
    }

    private int nextOID() {
        this.OID = this.prime.next();
        return this.OID;
    }

    private Set getOptimizedNodeList() {
        if (this.edges.size() == 0 && this.nodes.size() == 1) {
            return this.optimizeSingleNode();
        }
        return this.optimizeMultipleNodes();
    }

    private Set optimizeSingleNode() {
        log.debug("Optimizing ConnectedGraph with one node, no edge");
        LinkedHashSet qep = new LinkedHashSet();
        qep.add(this.nodes.get(new Integer(this.MIN_OID)));
        if (qep.size() != this.nodes.size()) {
            log.error("The optimized set of nodes does not contain each node");
        }
        return qep;
    }

    private Set optimizeMultipleNodes() {
        GraphEdge edge = null;
        List nodes = null;
        log.debug("Optimizing ConnectedGraph with " + this.nodes.size() + " nodes and " + this.edges.size() + " edges");
        LinkedHashSet<GraphNode> nodeQEP = new LinkedHashSet<GraphNode>();
        ArrayList edges = new ArrayList();
        edges.addAll(this.edges.values());
        Collections.sort(edges, new EdgeComparator());
        this.optGraphEdgeList.addAll(edges);
        edge = (GraphEdge)edges.remove(0);
        nodes = edge.nodes();
        Collections.sort(nodes, new NodeComparator());
        nodeQEP.addAll(nodes);
        while (nodeQEP.size() < this.nodes.size()) {
            edge = this.getNextEdge(nodeQEP, edges);
            edges.remove(edge);
            nodes = edge.nodes();
            Collections.sort(nodes, new NodeComparator());
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                GraphNode node = (GraphNode)iter.next();
                if (nodeQEP.contains(node)) continue;
                nodeQEP.add(node);
            }
        }
        return nodeQEP;
    }

    private GraphEdge getNextEdge(Set qep, List edges) {
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            GraphEdge edge = (GraphEdge)iter.next();
            List nodes = edge.nodes();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                GraphNode node = (GraphNode)it.next();
                if (!qep.contains(node)) continue;
                return edge;
            }
        }
        throw new NullPointerException("FATAL. No edge found which connects to previous nodes in the QEP");
    }

    class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object node1, Object node2) {
            if (!(node1 instanceof GraphNode)) {
                throw new ClassCastException();
            }
            if (!(node2 instanceof GraphNode)) {
                throw new ClassCastException();
            }
            if (((GraphNode)node1).weight() < ((GraphNode)node2).weight()) {
                return -1;
            }
            if (((GraphNode)node1).weight() > ((GraphNode)node2).weight()) {
                return 1;
            }
            return 0;
        }
    }

    class EdgeComparator
    implements Comparator {
        EdgeComparator() {
        }

        public int compare(Object edge1, Object edge2) {
            if (!(edge1 instanceof GraphEdge)) {
                throw new ClassCastException();
            }
            if (!(edge2 instanceof GraphEdge)) {
                throw new ClassCastException();
            }
            if (((GraphEdge)edge1).weight() < ((GraphEdge)edge2).weight()) {
                return -1;
            }
            if (((GraphEdge)edge1).weight() > ((GraphEdge)edge2).weight()) {
                return 1;
            }
            return 0;
        }
    }
}

