/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternJoin;
import com.hp.hpl.jena.sparql.engine.optimizer.core.ConnectedGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.core.GraphNode;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.Heuristic;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicBasicPattern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicPatternGraph {
    private HeuristicBasicPattern heuristic;
    private List components = new ArrayList();
    private static Log log = LogFactory.getLog(BasicPatternGraph.class);

    public BasicPatternGraph(BasicPattern pattern, Heuristic heuristic) {
        this.heuristic = (HeuristicBasicPattern)heuristic;
        List patterns = this.listJoinedBasicPatterns(pattern);
        log.debug("Number of BasicPatternGraph components: " + patterns.size());
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            this.buildGraphComponent((BasicPattern)iter.next());
        }
    }

    public BasicPattern optimize() {
        BasicPattern pattern = new BasicPattern();
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            ConnectedGraph component = (ConnectedGraph)iter.next();
            pattern.addAll(component.optimize());
        }
        log.debug("Optimized BasicPattern: " + pattern.toString());
        return pattern;
    }

    public int numberOfConnectedComponents() {
        return this.components.size();
    }

    public ConnectedGraph getComponent(int index) {
        return (ConnectedGraph)this.components.get(index);
    }

    public List getComponents() {
        return this.components;
    }

    private Vector getNodes(BasicPattern pattern) {
        Vector nodes = new Vector();
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            nodes.addAll(this.getNodes(triple));
        }
        return nodes;
    }

    private Vector getNodes(Triple triple) {
        Vector<Node> nodes = new Vector<Node>();
        Node subject = triple.getSubject();
        Node predicate = triple.getPredicate();
        Node object = triple.getObject();
        if (!nodes.contains(subject)) {
            nodes.add(subject);
        }
        if (!nodes.contains(predicate)) {
            nodes.add(predicate);
        }
        if (!nodes.contains(object)) {
            nodes.add(object);
        }
        return nodes;
    }

    private boolean tripleContainsNode(Triple triple, Node node) {
        if (triple.subjectMatches(node)) {
            return true;
        }
        if (triple.predicateMatches(node)) {
            return true;
        }
        return triple.objectMatches(node);
    }

    private List listJoinedBasicPatterns(BasicPattern pattern) {
        Vector nodes = new Vector();
        ArrayList patterns = new ArrayList();
        HashSet<Triple> considered = new HashSet<Triple>();
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple triple1 = (Triple)iter.next();
            if (considered.contains(triple1)) continue;
            log.debug("Consider triple1: " + triple1);
            this.addTripleToBasicPattern(patterns, triple1, null);
            considered.add(triple1);
            nodes.addAll(this.getNodes(triple1));
            while (nodes.size() > 0) {
                Node node = (Node)nodes.remove(0);
                log.debug("Check the node: " + node.toString());
                ListIterator it = pattern.iterator();
                while (it.hasNext()) {
                    Triple triple2 = (Triple)it.next();
                    if (considered.contains(triple2)) continue;
                    log.debug("Consider triple2: " + triple2);
                    if (!this.tripleContainsNode(triple2, node)) continue;
                    log.debug("The triple contains the node: " + triple2.toString());
                    this.addTripleToBasicPattern(patterns, triple2, node);
                    considered.add(triple2);
                    nodes.addAll(this.getNodes(triple2));
                }
            }
        }
        return patterns;
    }

    private void addTripleToBasicPattern(List patterns, Triple triple, Node node) {
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            BasicPattern pattern = (BasicPattern)iter.next();
            if (!this.getNodes(pattern).contains(node)) continue;
            log.debug("Add the triple to an existing pattern");
            pattern.add(triple);
            return;
        }
        log.debug("Create a new pattern for the triple: " + triple.toString());
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        patterns.add(pattern);
    }

    private void buildGraphComponent(BasicPattern pattern) {
        log.debug("Build ConnectedGraph for component: " + pattern.toString());
        ConnectedGraph component = new ConnectedGraph();
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            double weight = this.heuristic.getCost(triple);
            component.createNode(triple, weight);
        }
        List nodes = component.getNodes();
        ArrayList tmp = new ArrayList();
        tmp.addAll(nodes);
        Iterator iter1 = nodes.iterator();
        while (iter1.hasNext()) {
            GraphNode node1 = (GraphNode)iter1.next();
            tmp.remove(node1);
            Iterator iter2 = tmp.iterator();
            while (iter2.hasNext()) {
                GraphNode node2 = (GraphNode)iter2.next();
                if (!BasicPatternJoin.isJoined(node1, node2)) continue;
                double weight = this.heuristic.getCost(node1.triple(), node2.triple());
                component.createEdge(node1, node2, weight);
            }
        }
        this.components.add(component);
    }
}

