/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.impl.FileGraphTransactionHandler;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileGraph
extends GraphMemFaster {
    public final File name;
    protected final Model model;
    public final String lang;
    protected final NotifyOnClose notify;
    protected TransactionHandler th;

    public FileGraph(File f, boolean create, boolean strict) {
        this(NotifyOnClose.ignore, f, create, strict, ReificationStyle.Minimal);
    }

    public FileGraph(NotifyOnClose notify, File f, boolean create, boolean strict, ReificationStyle style) {
        this(notify, f, FileUtils.guessLang(f.toString()), create, strict, style);
    }

    public FileGraph(NotifyOnClose notify, File f, String lang, boolean create, boolean strict, ReificationStyle style) {
        super(style);
        this.name = f;
        this.notify = notify;
        this.model = new ModelCom(this);
        this.lang = lang;
        if (create) {
            if (f.exists() && strict) {
                throw new AlreadyExistsException(f.toString());
            }
        } else {
            this.readModel(this.model, strict);
        }
    }

    protected void readModel(Model m, boolean strict) {
        this.readModelFrom(m, strict, this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readModelFrom(Model m, boolean strict, File name) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(name);
            this.model.read(in, "", this.lang);
        }
        catch (FileNotFoundException f) {
            if (strict) {
                throw new DoesNotExistException(name.toString());
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public FileGraph(String s, boolean create) {
        this(new File(s), create, true);
    }

    public static FileGraph create() {
        return new FileGraph(FileUtils.tempFileName("anonymousFileGraph", ".rdf"), true, true);
    }

    public static boolean isPlausibleGraphName(String name) {
        return FileUtils.guessLang(name, null) != null;
    }

    public void close() {
        this.saveContents(this.name);
        super.close();
        if (this.count == 0) {
            this.notify.notifyClosed(this.name);
        }
    }

    public void delete() {
        this.name.delete();
    }

    protected void saveContents(File targetName) {
        try {
            File intermediate = new File(targetName.getPath() + ".new");
            FileOutputStream out = new FileOutputStream(intermediate);
            this.model.write(out, this.lang);
            out.close();
            this.updateFrom(targetName, intermediate);
        }
        catch (Exception e2) {
            throw new JenaException(e2);
        }
    }

    protected void updateFrom(File targetName, File intermediate) {
        if (!intermediate.renameTo(targetName)) {
            if (targetName.exists()) {
                this.mustDelete(targetName);
            }
            this.mustRename(intermediate, targetName);
        }
    }

    protected void mustDelete(File f) {
        if (!f.delete()) {
            throw new JenaException("could not delete " + f);
        }
    }

    protected void mustRename(File from, File to) {
        if (!from.renameTo(to)) {
            throw new JenaException("could not rename " + from + " to " + to);
        }
    }

    public TransactionHandler getTransactionHandler() {
        if (this.th == null) {
            this.th = new FileGraphTransactionHandler(this);
        }
        return this.th;
    }

    public static interface NotifyOnClose {
        public static final NotifyOnClose ignore = new NotifyOnClose(){

            public void notifyClosed(File f) {
            }
        };

        public void notifyClosed(File var1);
    }
}

