## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, results = "markup", message = FALSE)

## ----bcell,fig.show='asis',fig.keep='all'-------------------------------------
library(flowCore)
library(flowDensity)
data_dir <- system.file("extdata", package = "flowDensity")
load(list.files(pattern = 'sampleFCS_1', data_dir, full = TRUE))
f
sngl <- flowDensity(f,channels = c("FSC-A","FSC-H"),position = c(F,F),
                    percentile =c(.99999,.99999),use.percentile = c(T,T),
                    ellip.gate = T,scale = .99 )

## -----------------------------------------------------------------------------
plotDens(f,c(1,2))
lines(sngl@filter,type="l")

## ----plot---------------------------------------------------------------------
plot(f,sngl)

## ----plasma-------------------------------------------------------------------
data_dir <- system.file("extdata", package = "flowDensity")
load(list.files(pattern = 'sampleFCS_1', data_dir, full = TRUE))
#bcell <- flowDensity(f,channels = c(4,9),position = c(NA,T))
CD19pCD20n <- flowDensity(obj=f, channels=c(8, 6),
                        position=c(T,F))
plasmablasts <- flowDensity(obj=CD19pCD20n, channels=c(5, 12),
                            position=c(T, T))

## ----plot2--------------------------------------------------------------------
plotDens(CD19pCD20n@flow.frame, plasmablasts@channels, pch=19)
points(plasmablasts@filter, type='l', col=2, lwd=2)


## ----twsteps------------------------------------------------------------------
library(flowCore)
library(flowDensity)
data_dir <- system.file("extdata", package = "flowDensity")
load(list.files(pattern = 'sampleFCS_2', data_dir, full = TRUE))
f2
channels <- c("V500-A", "SSC-A")
# First call to flowDensity
tmp.cp1 <- flowDensity(obj=f2, channels=channels,
                      position=c(TRUE, FALSE), percentile=c(0.25, NA))
# Second call to flowDensity
tmp.cp2 <- flowDensity(obj=tmp.cp1, channels=channels,
                       position=c(TRUE, FALSE), gates=c(FALSE, NA), 
                       percentile=c(NA, 0.85))
# Final call to flowDensity
lymph <- flowDensity(obj=f2, channels=channels,
                     position=c(TRUE, FALSE), gates=c(tmp.cp1@gates[1], 
                     tmp.cp2@gates[2]), ellip.gate=TRUE, scale=.99)

plot(f2, tmp.cp1)


plot(f2, tmp.cp2)

## ----plot3--------------------------------------------------------------------
par(mfrow=c(1,1))
plotDens(f2, channels=channels,axes=T)
lines(lymph@filter, type="l", col=2, lwd=2)
legend("topleft",legend = paste0("count: ",lymph@cell.count),bty = "n")

## ----frame--------------------------------------------------------------------
getflowFrame(lymph)

## ----control,fig.keep='all'---------------------------------------------------
load(list.files(pattern = 'sampleFCS_3.Rdata', data_dir, full = TRUE))
f3
load(list.files(pattern = 'sampleFCS_3_FMO', data_dir, full = TRUE))
f3.fmo
f3.gated <- flowDensity(obj=f3, channels=c('BV421-A', 'FSC-A'),
                        position = c(TRUE, NA),use.control = c(TRUE, F)
                        , control = c(f3.fmo, NA),verbose=F)
f3.fmo.gated <- flowDensity(obj=f3.fmo, channels=c('BV421-A', 'FSC-A'),
                            position=c(TRUE, NA),
                            gates=c(f3.gated@gates[1], NA),verbose=F)
plot(f3.fmo, f3.fmo.gated)

plot(f3, f3.gated)

## ----control2,fig.keep='all'--------------------------------------------------
f3.gated.98p <- flowDensity(obj=f3, channels=c('BV421-A', 'FSC-A'),
                            position = c(TRUE, NA),use.percentile = c(TRUE, NA),
                            percentile = 0.98, use.control = c(TRUE, FALSE),
                            control = c(f3.fmo, NA))
f3.fmo.gated.98p <- flowDensity(obj=f3.fmo, channels=c('BV421-A', 'FSC-A'),
                                position = c(TRUE, NA),
                                gates=c(f3.gated.98p@gates[1], NA))
plot(f3.fmo, f3.fmo.gated.98p)

plot(f3, f3.gated.98p)

## ----deGate-------------------------------------------------------------------
load(list.files(pattern = 'sampleFCS_2', data_dir, full = TRUE))
thresholds <- deGate(obj = f2,channel = 9)
#Percentile default is .95, which can be changed
thresholds.prcnt <- deGate(f2,channel = 9,use.percentile=T,percentile=.3) 
thresholds.lo <- deGate(f2,channel = 9,use.upper=T,upper=F,alpha = .9)
thresholds.hi <- deGate(f2,channel = 9,use.upper=T,upper=T,alpha = .9)

plotDens(f2,c(9,12))
abline(v=c(thresholds,thresholds.prcnt,thresholds.lo,thresholds.hi),col=c(1,2,3,4))

## ----nutsub-------------------------------------------------------------------
cd19.gate <- deGate(f, channel = 8)
cd20.gate <- deGate(f,channel = 9)
cd20.neg <- notSubFrame(f, channels = c(8,9),position = c(F,F),gates=c(cd19.gate,cd20.gate))
plotDens(f,c(8,9),axes=T)
lines(cd20.neg@filter, type="l")


## ----plo4---------------------------------------------------------------------
plotDens(cd20.neg,c(8,9),main="Not CD19-CD20-")

## ----peaks--------------------------------------------------------------------
load(list.files(pattern = 'sampleFCS_2', data_dir, full = TRUE))
getPeaks(f2,channel = 9)


## -----------------------------------------------------------------------------
load(list.files(pattern = 'sampleFCS_2', data_dir, full = TRUE))

plotDens(f2, channels = c(9,12),density.overlay = c(T,T))


