/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.swing;

import edu.rit.swing.Displayable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class DisplayableList
implements Displayable {
    private Vector<Displayable> myDisplayList = new Vector();
    private static final Rectangle2D EMPTY = new Rectangle2D.Double();
    private Rectangle2D myBoundingBox = EMPTY;
    private Paint myBackgroundPaint = Color.white;

    public synchronized void clear() {
        this.myDisplayList.clear();
        this.myBoundingBox = EMPTY;
        this.myBackgroundPaint = Color.white;
    }

    public synchronized void add(Displayable displayable) {
        if (displayable == null) {
            throw new NullPointerException();
        }
        if (this.myDisplayList.isEmpty()) {
            this.myBackgroundPaint = displayable.getBackgroundPaint();
        }
        this.myBoundingBox = this.myBoundingBox.createUnion(displayable.getBoundingBox());
        this.myDisplayList.add(displayable);
    }

    public synchronized void draw(Graphics2D graphics2D) {
        for (Displayable displayable : this.myDisplayList) {
            displayable.draw(graphics2D);
        }
    }

    public synchronized Rectangle2D getBoundingBox() {
        return this.myBoundingBox;
    }

    public synchronized Paint getBackgroundPaint() {
        return this.myBackgroundPaint;
    }
}

