## ----setup, echo=FALSE--------------------------------------------------------
suppressPackageStartupMessages({ 
    library(ToPASeq)
    library(graphite)
})

## ----lib----------------------------------------------------------------------
library(ToPASeq)

## ----loadAirway---------------------------------------------------------------
library(airway)
data(airway)

## ----processAirway------------------------------------------------------------
airSE <- airway[grep("^ENSG", rownames(airway)),]
dim(airSE)
assay(airSE)[1:4,1:4]

## ----remove zeros-------------------------------------------------------------
airSE <- airway[rowSums(assay(airSE))>0,]
dim(airSE)
assay(airSE)[1:4,1:4]

## -----------------------------------------------------------------------------
group <- ifelse(airway$dex == "trt", 1, 0)
table(group)

## ----pwys---------------------------------------------------------------------
library(graphite)
pwys <- pathways(species="hsapiens", database="kegg")[1:5]
pwys

## ----nodes--------------------------------------------------------------------
nodes(pwys[[1]])

## ----mapIDs-------------------------------------------------------------------
pwys<-graphite::convertIdentifiers(pwys,"ENSEMBL")
nodes(pwys[[1]])

## ----TopologyGSA--------------------------------------------------------------
top<-TopologyGSA(assay(airSE), group, pwys, type="RNASeq", nperm=10, norm.method="edgeR")
res(top)

## ----DEGraph------------------------------------------------------------------
deg<-DEGraph(assay(airSE), group, pwys, type="RNASeq", norm.method="edgeR")
res(deg)

## ----clipper------------------------------------------------------------------
cli<-clipper(assay(airSE), group, pwys,type="RNASeq", method="mean", nperm=10, norm.method="edgeR")
res(cli)$results[[1]]

## ----SPIA---------------------------------------------------------------------
spi<-SPIA(assay(airSE), group,pwys , type="RNASeq", logFC.th=-1, test.method="edgeR")
res(spi)

## ----TAPPA--------------------------------------------------------------------
tap<-TAPPA(assay(airSE), group, pwys, type="RNASeq", norm.method = "edgeR")
res(tap)

## ----PRS----------------------------------------------------------------------
Prs<-PRS_wrapper( assay(airSE), group, pwys, type="RNASeq",  logFC.th=-1, nperm=10, test.method="edgeR")
res(Prs)

## ----PWEA---------------------------------------------------------------------
pwe<-PWEA(assay(airSE), group, pwys,  type="RNASeq", nperm=10, test.method="edgeR")
res(pwe)

