## ---- include=FALSE-----------------------------------------------------------
library(BiocStyle)

## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SEtools")

## ---- eval=FALSE--------------------------------------------------------------
#  BiocManager::install("plger/SEtools")

## -----------------------------------------------------------------------------
suppressPackageStartupMessages({
  library(SummarizedExperiment)
  library(SEtools)
})
data("SE", package="SEtools")
SE

## -----------------------------------------------------------------------------
g <- c("Egr1", "Nr4a1", "Fos", "Egr2", "Sgk1", "Arc", "Dusp1", "Fosb", "Sik1")
sehm(SE, genes=g)
sehm(SE, genes=g, do.scale=TRUE)

## -----------------------------------------------------------------------------
sehm(SE, genes=g, do.scale=TRUE, anno_rows="meanTPM")

## -----------------------------------------------------------------------------
sehm(SE, genes=g, do.scale=TRUE, anno_rows="meanTPM", gaps_at="Condition")

## -----------------------------------------------------------------------------
lfcs <- assays(SE)$logcpm-rowMeans(assays(SE)$logcpm[,which(SE$Condition=="Homecage")])
rowData(SE)$cluster <- as.character(kmeans(lfcs,4)$cluster)
sehm(SE, genes=g, do.scale=TRUE, anno_rows="cluster", toporder="cluster", gaps_at="Condition")

## ----colors_in_object---------------------------------------------------------
metadata(SE)$hmcols <- c("purple","white","gold")
ancols <- list( Condition=c( Homecage="#DB918B",
                             Handling="#B86FD3",
                             Restraint="#A9CED5",
                             Swim="#B5DF7C" ) )
metadata(SE)$anno_colors <- ancols
sehm(SE, g, do.scale = TRUE)

## ----colors_in_options--------------------------------------------------------
options("SEtools_def_hmcols"=c("white","grey","black"))
options("SEtools_def_anno_colors"=ancols)
sehm(SE, g, do.scale = TRUE)

## -----------------------------------------------------------------------------
resetAllSEtoolsOptions()
metadata(SE)$hmcols <- NULL
metadata(SE)$anno_colors <- NULL

## ----two_heatmaps-------------------------------------------------------------
sechm(SE, g, do.scale = TRUE) + sechm(SE, g, do.scale = FALSE)

## ----crossHm------------------------------------------------------------------
# we build another SE object:
SE2 <- SE
assays(SE2)$logcpm <- jitter(assays(SE2)$logcpm, factor=1000)
crossHm(list(SE1=SE, SE2=SE2), g, do.scale = TRUE)

## ----crosshm2-----------------------------------------------------------------
crossHm(list(SE1=SE, SE2=SE2), g, do.scale = TRUE, uniqueScale = TRUE)

## -----------------------------------------------------------------------------
se1 <- SE[,1:10]
se2 <- SE[,11:20]
se3 <- mergeSEs( list(se1=se1, se2=se2) )
se3

## -----------------------------------------------------------------------------
se3 <- mergeSEs( list(se1=se1, se2=se2), do.scale=FALSE)

## -----------------------------------------------------------------------------
se3 <- mergeSEs( list(se1=se1, se2=se2), use.assays=c("counts", "logcpm"), do.scale=c(FALSE, TRUE))

## ----merging------------------------------------------------------------------
rowData(se1)$metafeature <- sample(LETTERS,nrow(se1),replace = TRUE)
rowData(se2)$metafeature <- sample(LETTERS,nrow(se2),replace = TRUE)
se3 <- mergeSEs( list(se1=se1, se2=se2), do.scale=FALSE, mergeBy="metafeature", aggFun=median)
sehm(se3, genes=row.names(se3))

## ----aggregating--------------------------------------------------------------
se1b <- aggSE(se1, by = "metafeature")
se1b

## ---- fig.cap="An example ggplot created from a melted SE.", fig.height=5-----
d <- meltSE(SE, genes=g[1:4])
head(d)
suppressPackageStartupMessages(library(ggplot2))
ggplot(d, aes(Condition, counts, fill=Condition)) + geom_violin() + 
    facet_wrap(~feature, scale="free")

## ----sessionInfo, echo=FALSE--------------------------------------------------
sessionInfo()

