/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.viewer;

import de.proteinms.xtandemparser.viewer.XTandemViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParametersDialog
extends JDialog {
    private XTandemViewer parent;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel bottomPnl;
    private JPanel centerPnl;
    private JLabel fragmentIonMassAccuracyLbl;
    private JTextField fragmentIonMassAccuracyTtf;

    public ParametersDialog(XTandemViewer parent, boolean modal) {
        this.parent = parent;
        this.setTitle("X!Tandem Viewer --- Parameters");
        this.setDefaultCloseOperation(2);
        Container cp = this.getContentPane();
        this.okBtn = new JButton("OK");
        this.okBtn.setPreferredSize(new Dimension(100, 20));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersDialog.this.okButtonActionPerformed();
            }
        });
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setPreferredSize(new Dimension(100, 20));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersDialog.this.closeButtonActionPerformed();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.bottomPnl = new JPanel();
        this.bottomPnl.add(this.okBtn);
        this.bottomPnl.add(this.cancelBtn);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.centerPnl = new JPanel();
        this.fragmentIonMassAccuracyLbl = new JLabel("Fragment Ion Mass Accuracy: ");
        this.fragmentIonMassAccuracyTtf = new JTextField(10);
        this.fragmentIonMassAccuracyTtf.setText(String.valueOf(parent.getFragmentIonMassAccuracy()));
        this.centerPnl.add(this.fragmentIonMassAccuracyLbl);
        this.centerPnl.add(this.fragmentIonMassAccuracyTtf);
        mainPanel.add((Component)this.centerPnl, "Center");
        mainPanel.add((Component)this.bottomPnl, "South");
        cp.add(mainPanel);
        this.pack();
        this.setSize(350, 100);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void okButtonActionPerformed() {
        this.parent.setFragmentIonMassAccuracy(Double.valueOf(this.fragmentIonMassAccuracyTtf.getText()));
        this.parent.insertFiles(this.parent.getXTandemFile(), "user.home");
        this.setVisible(false);
        this.dispose();
    }

    private void closeButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    private void close() {
        this.dispose();
    }
}

